/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.texture;

import com.madgag.gif.fmsware.GifDecoder;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundSource;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.display.FramePictureDisplay;
import team.creative.littleframes.client.display.FrameVideoDisplay;
import team.creative.littleframes.client.texture.TextureSeeker;

public class TextureCache {
    private static HashMap<String, TextureCache> cached = new HashMap();
    public final String url;
    private int[] textures;
    private int width;
    private int height;
    private long[] delay;
    private long duration;
    private boolean isVideo;
    private TextureSeeker seeker;
    private boolean ready = false;
    private String error;
    private int usage = 0;
    private GifDecoder decoder;
    private int remaining;

    @SubscribeEvent
    public static void render(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Iterator<TextureCache> iterator = cached.values().iterator();
            while (iterator.hasNext()) {
                TextureCache type = iterator.next();
                if (type.isUsed()) continue;
                type.remove();
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    public static void render(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            FrameVideoDisplay.tick();
        }
    }

    public static void reloadAll() {
        for (TextureCache cache : cached.values()) {
            cache.reload();
        }
    }

    @SubscribeEvent
    public static void unload(LevelEvent.Unload event) {
        if (event.getLevel().m_5776_()) {
            for (TextureCache cache : cached.values()) {
                cache.remove();
            }
            cached.clear();
            FrameVideoDisplay.unload();
        }
    }

    public static TextureCache get(String url) {
        TextureCache cache = cached.get(url);
        if (cache != null) {
            cache.use();
            return cache;
        }
        cache = new TextureCache(url);
        cached.put(url, cache);
        return cache;
    }

    public TextureCache(String url) {
        this.url = url;
        this.use();
        this.trySeek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySeek() {
        if (this.seeker != null) {
            return;
        }
        Object object = TextureSeeker.LOCK;
        synchronized (object) {
            if (TextureSeeker.activeDownloads < 5) {
                this.seeker = new TextureSeeker(this);
            }
        }
    }

    private int getTexture(int index) {
        if (this.textures[index] == -1 && this.decoder != null) {
            this.textures[index] = TextureCache.uploadFrame(this.decoder.getFrame(index), this.width, this.height);
            --this.remaining;
            if (this.remaining <= 0) {
                this.decoder = null;
            }
        }
        return this.textures[index];
    }

    public int getTexture(long time) {
        if (this.textures == null) {
            return -1;
        }
        if (this.textures.length == 1) {
            return this.getTexture(0);
        }
        int last = this.getTexture(0);
        for (int i = 1; i < this.delay.length && this.delay[i] <= time; ++i) {
            last = this.getTexture(i);
        }
        return last;
    }

    public FrameDisplay createDisplay(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop) {
        return this.createDisplay(pos, url, volume, minDistance, maxDistance, loop, false);
    }

    public FrameDisplay createDisplay(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop, boolean noVideo) {
        volume *= Minecraft.m_91087_().f_91066_.m_92147_(SoundSource.MASTER);
        if (this.textures == null && !noVideo && LittleFrames.CONFIG.useVLC) {
            return FrameVideoDisplay.createVideoDisplay(pos, url, volume, minDistance, maxDistance, loop);
        }
        return new FramePictureDisplay(this);
    }

    public String getError() {
        return this.error;
    }

    public void processVideo() {
        this.textures = null;
        this.error = null;
        this.isVideo = true;
        this.ready = true;
        this.seeker = null;
    }

    public void processFailed(String error) {
        this.textures = null;
        this.error = error;
        this.ready = true;
        this.seeker = null;
    }

    public void process(BufferedImage image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.textures = new int[]{TextureCache.uploadFrame(image, this.width, this.height)};
        this.delay = new long[]{0L};
        this.duration = 0L;
        this.seeker = null;
        this.ready = true;
    }

    public void process(GifDecoder decoder) {
        Dimension frameSize = decoder.getFrameSize();
        this.width = (int)frameSize.getWidth();
        this.height = (int)frameSize.getHeight();
        this.textures = new int[decoder.getFrameCount()];
        this.delay = new long[decoder.getFrameCount()];
        this.decoder = decoder;
        this.remaining = decoder.getFrameCount();
        long time = 0L;
        for (int i = 0; i < decoder.getFrameCount(); ++i) {
            this.textures[i] = -1;
            this.delay[i] = time;
            time += (long)decoder.getDelay(i);
        }
        this.duration = time;
        this.seeker = null;
        this.ready = true;
    }

    public boolean ready() {
        if (this.ready) {
            return true;
        }
        this.trySeek();
        return false;
    }

    public boolean isVideo() {
        return this.isVideo;
    }

    public void reload() {
        this.remove();
        this.error = null;
        this.trySeek();
    }

    public void use() {
        ++this.usage;
    }

    public void unuse() {
        --this.usage;
    }

    public boolean isUsed() {
        return this.usage > 0;
    }

    public void remove() {
        this.ready = false;
        if (this.textures != null) {
            for (int i = 0; i < this.textures.length; ++i) {
                GlStateManager.m_84541_((int)this.textures[i]);
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public long[] getDelay() {
        return this.delay;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isAnimated() {
        return this.textures.length > 1;
    }

    public int getFrameCount() {
        return this.textures.length;
    }

    private static int uploadFrame(BufferedImage image, int width, int height) {
        int[] pixels = new int[width * height];
        image.getRGB(0, 0, width, height, pixels, 0, width);
        boolean hasAlpha = false;
        if (image.getColorModel().hasAlpha()) {
            for (int pixel : pixels) {
                if ((pixel >> 24 & 0xFF) >= 255) continue;
                hasAlpha = true;
                break;
            }
        }
        int bytesPerPixel = hasAlpha ? 4 : 3;
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * bytesPerPixel));
        for (int pixel : pixels) {
            buffer.put((byte)(pixel >> 16 & 0xFF));
            buffer.put((byte)(pixel >> 8 & 0xFF));
            buffer.put((byte)(pixel & 0xFF));
            if (!hasAlpha) continue;
            buffer.put((byte)(pixel >> 24 & 0xFF));
        }
        buffer.flip();
        int textureID = GlStateManager.m_84111_();
        RenderSystem.m_69396_((int)textureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        if (!hasAlpha) {
            GL11.glPixelStorei((int)3317, (int)1);
        }
        GL11.glTexImage2D((int)3553, (int)0, (int)(hasAlpha ? 32856 : 32849), (int)width, (int)height, (int)0, (int)(hasAlpha ? 6408 : 6407), (int)5121, (ByteBuffer)buffer);
        return textureID;
    }
}

