/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.gui;

import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.controls.parent.GuiColumn;
import team.creative.creativecore.common.gui.controls.parent.GuiRow;
import team.creative.creativecore.common.gui.controls.parent.GuiTable;
import team.creative.creativecore.common.gui.controls.simple.GuiButton;
import team.creative.creativecore.common.gui.controls.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.controls.simple.GuiIconButton;
import team.creative.creativecore.common.gui.controls.simple.GuiLabel;
import team.creative.creativecore.common.gui.controls.simple.GuiSlider;
import team.creative.creativecore.common.gui.controls.simple.GuiStateButtonMapped;
import team.creative.creativecore.common.gui.controls.simple.GuiSteppedSlider;
import team.creative.creativecore.common.gui.controls.simple.GuiTextfield;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.GuiIcon;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.gui.GuiUrlTextfield;
import team.creative.littleframes.client.texture.TextureCache;
import team.creative.littleframes.client.texture.TextureSeeker;
import team.creative.littleframes.common.structure.LittlePictureFrame;

public class GuiLittlePictureFrame
extends GuiLayer {
    public LittlePictureFrame frame;
    public GuiTextfield url;
    public final GuiSyncLocal<EndTag> PLAY = this.getSyncHolder().register("play", x -> this.frame.play());
    public final GuiSyncLocal<EndTag> PAUSE = this.getSyncHolder().register("pause", x -> this.frame.pause());
    public final GuiSyncLocal<EndTag> STOP = this.getSyncHolder().register("stop", x -> this.frame.stop());
    public final GuiSyncLocal<CompoundTag> SET_DATA = this.getSyncHolder().register("set_data", nbt -> {
        String url = nbt.m_128461_("url");
        if (LittleFrames.CONFIG.canUse(this.getPlayer(), url)) {
            this.frame.setURL(url);
            this.frame.renderDistance = Math.min(LittleFrames.CONFIG.maxRenderDistance, nbt.m_128451_("render"));
            this.frame.fitMode = LittlePictureFrame.FitMode.values()[nbt.m_128451_("fit")];
            this.frame.loop = nbt.m_128471_("loop");
            this.frame.volume = nbt.m_128457_("volume");
            this.frame.minDistance = nbt.m_128457_("min");
            this.frame.maxDistance = nbt.m_128457_("max");
            this.frame.alpha = nbt.m_128457_("transparency");
            this.frame.brightness = nbt.m_128457_("brightness");
        }
        this.frame.updateStructure();
    });

    public GuiLittlePictureFrame(LittlePictureFrame frame) {
        super("little_frame");
        this.frame = frame;
    }

    public void create() {
        GuiButton save = new GuiButton("save", x -> {
            CompoundTag nbt = new CompoundTag();
            GuiTextfield url = (GuiTextfield)this.get("url");
            GuiSteppedSlider renderDistance = (GuiSteppedSlider)this.get("distance");
            GuiStateButtonMapped fit = (GuiStateButtonMapped)this.get("fit");
            GuiSlider transparency = (GuiSlider)this.get("transparency");
            GuiSlider brightness = (GuiSlider)this.get("brightness");
            GuiCheckBox loop = (GuiCheckBox)this.get("loop");
            GuiSlider volume = (GuiSlider)this.get("volume");
            GuiSteppedSlider min = (GuiSteppedSlider)this.get("range_min");
            GuiSteppedSlider max = (GuiSteppedSlider)this.get("range_max");
            nbt.m_128405_("fit", fit.getState());
            nbt.m_128405_("render", (int)renderDistance.value);
            nbt.m_128350_("transparency", (float)transparency.value);
            nbt.m_128350_("brightness", (float)brightness.value);
            nbt.m_128379_("loop", loop.value);
            nbt.m_128350_("volume", (float)volume.value);
            nbt.m_128350_("min", (float)min.getValue());
            nbt.m_128350_("max", (float)max.getValue());
            nbt.m_128359_("url", url.getText());
            nbt.m_128405_("type", 0);
            this.SET_DATA.send((Tag)nbt);
        });
        save.setTranslate("gui.save");
        this.align = Align.STRETCH;
        this.flow = GuiFlow.STACK_Y;
        this.url = new GuiUrlTextfield(save, "url", this.frame.getRealURL());
        this.url.setMaxStringLength(512);
        this.add((GuiControl)this.url);
        GuiLabel error = new GuiLabel("error").setDefaultColor(-65536);
        if (this.frame.cache != null && this.frame.cache.getError() != null) {
            error.setTranslate(this.frame.cache.getError());
        }
        this.add((GuiControl)error);
        GuiStateButtonMapped button = new GuiStateButtonMapped("fit", new TextMapBuilder().addComponent((Object[])LittlePictureFrame.FitMode.values(), x -> Component.m_237115_((String)("gui.little_frame.fitmode." + x.name()))));
        button.select((Object)this.frame.fitMode);
        this.add((GuiControl)button);
        GuiTable table = new GuiTable();
        this.add((GuiControl)table);
        GuiColumn left = new GuiColumn();
        GuiColumn right = new GuiColumn();
        table.addRow(new GuiRow(new GuiColumn[]{left, right}));
        left.add((GuiControl)new GuiLabel("t_label").setTitle((Component)Component.m_237115_((String)"gui.creative_frame.transparency").m_130946_(":")));
        right.add(new GuiSlider("transparency", (double)this.frame.alpha, 0.0, 1.0).setExpandableX());
        left = new GuiColumn();
        right = new GuiColumn();
        table.addRow(new GuiRow(new GuiColumn[]{left, right}));
        left.add((GuiControl)new GuiLabel("b_label").setTitle((Component)Component.m_237115_((String)"gui.creative_frame.brightness").m_130946_(":")));
        right.add(new GuiSlider("brightness", (double)this.frame.brightness, 0.0, 1.0).setExpandableX());
        left = new GuiColumn();
        right = new GuiColumn();
        table.addRow(new GuiRow(new GuiColumn[]{left, right}));
        left.add((GuiControl)new GuiLabel("d_label").setTitle((Component)Component.m_237115_((String)"gui.creative_frame.distance").m_130946_(":")));
        right.add(new GuiSteppedSlider("distance", this.frame.renderDistance, 5, 1024).setExpandableX());
        GuiParent play = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)play);
        play.add((GuiControl)new GuiIconButton("play", GuiIcon.PLAY, x -> this.PLAY.send((Tag)EndTag.f_128534_)));
        play.add((GuiControl)new GuiIconButton("pause", GuiIcon.PAUSE, x -> this.PAUSE.send((Tag)EndTag.f_128534_)));
        play.add((GuiControl)new GuiIconButton("stop", GuiIcon.STOP, x -> this.STOP.send((Tag)EndTag.f_128534_)));
        play.add((GuiControl)new GuiCheckBox("loop", this.frame.loop).setTranslate("gui.creative_frame.loop"));
        play.add((GuiControl)new GuiLabel("v_label").setTranslate("gui.creative_frame.volume"));
        play.add((GuiControl)new GuiSlider("volume", (double)this.frame.volume, 0.0, 1.0));
        play.add((GuiControl)new GuiLabel("range_label").setTranslate("gui.creative_frame.range"));
        play.add((GuiControl)new GuiSteppedSlider("range_min", (int)this.frame.minDistance, 0, 512));
        play.add((GuiControl)new GuiSteppedSlider("range_max", (int)this.frame.maxDistance, 0, 512));
        GuiParent bottom = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        bottom.align = Align.RIGHT;
        this.add((GuiControl)bottom);
        save.setEnabled(LittleFrames.CONFIG.canUse(this.getPlayer(), this.url.getText()));
        bottom.add((GuiControl)save);
        bottom.add(new GuiButton("reload", x -> {
            Object object = TextureSeeker.LOCK;
            synchronized (object) {
                if (Screen.m_96638_()) {
                    TextureCache.reloadAll();
                } else if (this.frame.cache != null) {
                    this.frame.cache.reload();
                }
            }
        }).setTranslate("gui.creative_frame.reload").setTooltip(new TextBuilder().translate("gui.creative_frame.reloadtooltip").build()));
    }
}

