/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.display;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.MemoryTracker;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.texture.TextureCache;
import team.creative.littleframes.client.vlc.VLCDiscovery;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.player.base.MediaPlayer;
import uk.co.caprica.vlcj.player.component.CallbackMediaPlayerComponent;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormat;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.BufferFormatCallback;
import uk.co.caprica.vlcj.player.embedded.videosurface.callback.RenderCallback;

public class FrameVideoDisplay
extends FrameDisplay {
    private static final String VLC_DOWNLOAD_32 = "https://i.imgur.com/VF3LuvM.png";
    private static final String VLC_DOWNLOAD_64 = "https://i.imgur.com/2aN8ZQC.png";
    private static final int ACCEPTABLE_SYNC_TIME = 1000;
    private static final List<FrameVideoDisplay> OPEN_DISPLAYS = new ArrayList<FrameVideoDisplay>();
    public volatile int width = 1;
    public volatile int height = 1;
    public CallbackMediaPlayerComponent player;
    public MediaPlayerFactory factory;
    private final Vec3d pos;
    private volatile IntBuffer buffer;
    public int texture;
    private boolean stream = false;
    private float lastSetVolume;
    private volatile boolean needsUpdate = false;
    private ReentrantLock lock = new ReentrantLock();
    private volatile boolean first = true;
    private long lastCorrectedTime = Long.MIN_VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick() {
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (FrameVideoDisplay display : OPEN_DISPLAYS) {
                if (!Minecraft.m_91087_().m_91104_()) continue;
                if (display.stream) {
                    if (!display.player.mediaPlayer().status().isPlaying()) continue;
                    display.player.mediaPlayer().controls().setPause(true);
                    continue;
                }
                if (display.player.mediaPlayer().status().length() <= 0L || !display.player.mediaPlayer().status().isPlaying()) continue;
                display.player.mediaPlayer().controls().setPause(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unload() {
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            for (FrameVideoDisplay display : OPEN_DISPLAYS) {
                display.free();
            }
            OPEN_DISPLAYS.clear();
        }
    }

    public static FrameDisplay createVideoDisplay(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop) {
        if (VLCDiscovery.isLoadedOrRequest()) {
            if (VLCDiscovery.isAvailable()) {
                FrameVideoDisplay display = new FrameVideoDisplay(pos, url, volume, minDistance, maxDistance, loop);
                OPEN_DISPLAYS.add(display);
                return display;
            }
        } else {
            return null;
        }
        String failURL = System.getProperty("sun.arch.data.model").equals("32") ? VLC_DOWNLOAD_32 : VLC_DOWNLOAD_64;
        TextureCache cache = TextureCache.get(failURL);
        if (cache.ready()) {
            return cache.createDisplay(pos, failURL, volume, minDistance, maxDistance, loop, true);
        }
        return null;
    }

    public FrameVideoDisplay(Vec3d pos, String url, float volume, float minDistance, float maxDistance, boolean loop) {
        this.pos = pos;
        this.texture = GlStateManager.m_84111_();
        this.player = new CallbackMediaPlayerComponent(VLCDiscovery.factory, null, null, false, new RenderCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void display(MediaPlayer mediaPlayer, ByteBuffer[] nativeBuffers, BufferFormat bufferFormat) {
                FrameVideoDisplay.this.lock.lock();
                try {
                    FrameVideoDisplay.this.buffer.put(nativeBuffers[0].asIntBuffer());
                    FrameVideoDisplay.this.buffer.rewind();
                    FrameVideoDisplay.this.needsUpdate = true;
                }
                finally {
                    FrameVideoDisplay.this.lock.unlock();
                }
            }
        }, new BufferFormatCallback(){

            @Override
            public BufferFormat getBufferFormat(int sourceWidth, int sourceHeight) {
                FrameVideoDisplay.this.lock.lock();
                try {
                    FrameVideoDisplay.this.width = sourceWidth;
                    FrameVideoDisplay.this.height = sourceHeight;
                    FrameVideoDisplay.this.first = true;
                    FrameVideoDisplay.this.buffer = MemoryTracker.m_182527_((int)(sourceWidth * sourceHeight * 4)).asIntBuffer();
                    FrameVideoDisplay.this.needsUpdate = true;
                }
                finally {
                    FrameVideoDisplay.this.lock.unlock();
                }
                return new BufferFormat("RGBA", sourceWidth, sourceHeight, new int[]{sourceWidth * 4}, new int[]{sourceHeight});
            }

            @Override
            public void allocatedBuffers(ByteBuffer[] buffers) {
            }
        }, null);
        volume = this.getVolume(volume, minDistance, maxDistance);
        this.player.mediaPlayer().audio().setVolume((int)volume);
        this.lastSetVolume = volume;
        this.player.mediaPlayer().controls().setRepeat(loop);
        this.player.mediaPlayer().media().start(url, new String[0]);
    }

    public int getVolume(float volume, float minDistance, float maxDistance) {
        if (this.player == null) {
            return 0;
        }
        float distance = (float)this.pos.distance(Minecraft.m_91087_().f_91074_.m_20318_(CreativeCoreClient.getFrameTime()));
        if (minDistance > maxDistance) {
            float temp = maxDistance;
            maxDistance = minDistance;
            minDistance = temp;
        }
        if (distance > minDistance) {
            volume = distance > maxDistance ? 0.0f : (volume *= 1.0f - (distance - minDistance) / (maxDistance - minDistance));
        }
        return (int)(volume * 100.0f);
    }

    @Override
    public void tick(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        if ((volume = (float)this.getVolume(volume, minDistance, maxDistance)) != this.lastSetVolume) {
            this.player.mediaPlayer().audio().setVolume((int)volume);
            this.lastSetVolume = volume;
        }
        if (this.player.mediaPlayer().media().isValid()) {
            boolean realPlaying;
            boolean bl = realPlaying = playing && !Minecraft.m_91087_().m_91104_();
            if (this.player.mediaPlayer().controls().getRepeat() != loop) {
                this.player.mediaPlayer().controls().setRepeat(loop);
            }
            long tickTime = 50L;
            long newDuration = this.player.mediaPlayer().status().length();
            if (!this.stream && newDuration != -1L && newDuration != 0L && this.player.mediaPlayer().media().info().duration() == 0L) {
                this.stream = true;
            }
            if (this.stream) {
                if (this.player.mediaPlayer().status().isPlaying() != realPlaying) {
                    this.player.mediaPlayer().controls().setPause(!realPlaying);
                }
            } else if (this.player.mediaPlayer().status().length() > 0L) {
                long time;
                if (this.player.mediaPlayer().status().isPlaying() != realPlaying) {
                    this.player.mediaPlayer().controls().setPause(!realPlaying);
                }
                if ((time = (long)tick * tickTime + (realPlaying ? (long)(CreativeCoreClient.getFrameTime() * (float)tickTime) : 0L)) > this.player.mediaPlayer().status().time() && loop) {
                    time %= this.player.mediaPlayer().status().length();
                }
                if (Math.abs(time - this.player.mediaPlayer().status().time()) > 1000L && Math.abs(time - this.lastCorrectedTime) > 1000L) {
                    this.lastCorrectedTime = time;
                    this.player.mediaPlayer().controls().setTime(time);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.lock.lock();
        try {
            if (this.needsUpdate) {
                GlStateManager.m_84522_((int)3314, (int)0);
                GlStateManager.m_84522_((int)3316, (int)0);
                GlStateManager.m_84522_((int)3315, (int)0);
                RenderSystem.m_69396_((int)this.texture);
                if (this.first) {
                    GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (IntBuffer)this.buffer);
                    this.first = false;
                } else {
                    GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.width, (int)this.height, (int)6408, (int)5121, (IntBuffer)this.buffer);
                }
                this.needsUpdate = false;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void free() {
        if (this.player != null) {
            this.player.mediaPlayer().release();
        }
        if (this.texture != -1) {
            GlStateManager.m_84541_((int)this.texture);
            this.texture = -1;
        }
        this.player = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        this.free();
        List<FrameVideoDisplay> list = OPEN_DISPLAYS;
        synchronized (list) {
            OPEN_DISPLAYS.remove(this);
        }
    }

    @Override
    public int texture() {
        return this.texture;
    }

    @Override
    public void pause(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setTime(tick * 50);
        this.player.mediaPlayer().controls().pause();
    }

    @Override
    public void resume(String url, float volume, float minDistance, float maxDistance, boolean playing, boolean loop, int tick) {
        if (this.player == null) {
            return;
        }
        this.player.mediaPlayer().controls().setTime(tick * 50);
        this.player.mediaPlayer().controls().play();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

