/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.model;

import com.jozufozu.flywheel.backend.gl.GlVertexArray;
import com.jozufozu.flywheel.backend.model.BufferedModel;
import com.jozufozu.flywheel.backend.model.IndexedModel;
import com.jozufozu.flywheel.core.model.Model;

public class ArrayModelRenderer {
    private final Model model;
    protected GlVertexArray vao;
    protected BufferedModel vbo;
    protected boolean initialized;

    public ArrayModelRenderer(Model model) {
        this.model = model;
    }

    public Model getModel() {
        return this.model;
    }

    public void draw() {
        if (!this.initialized) {
            this.init();
        }
        if (!this.isValid()) {
            return;
        }
        this.vao.bind();
        this.vbo.drawCall();
    }

    protected void init() {
        this.initialized = true;
        if (this.model.empty()) {
            return;
        }
        this.vbo = new IndexedModel(this.model);
        this.vao = new GlVertexArray();
        this.vao.bind();
        this.vbo.setupState(this.vao);
        GlVertexArray.unbind();
    }

    public void delete() {
        if (this.vbo != null) {
            this.vbo.delete();
        }
    }

    protected boolean isValid() {
        return this.vbo != null && this.vbo.valid();
    }
}

