/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.leosillagers.entity;

import java.util.EnumSet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class VindicatorWithShield
extends AbstractIllager {
    public AnimationState attackAnimationState = new AnimationState();
    protected static final EntityDataAccessor<Integer> ATTACK_TICKS = SynchedEntityData.m_135353_(VindicatorWithShield.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(VindicatorWithShield.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public VindicatorWithShield(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    public int getAttackTicks() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TICKS);
    }

    public void setAttackTicks(int attackTicks) {
        this.f_19804_.m_135381_(ATTACK_TICKS, (Object)attackTicks);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)attacking);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_TICKS, (Object)0);
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTargetGoal());
        this.f_21345_.m_25352_(3, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(4, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public boolean m_7327_(Entity p_21372_) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void performAttack() {
        for (Entity entity : this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
            if (entity instanceof AbstractIllager || !entity.m_6084_()) continue;
            double x = this.m_20185_() - entity.m_20185_();
            double y = this.m_20186_() - entity.m_20186_();
            double z = this.m_20189_() - entity.m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z);
            if (!((double)this.m_20270_(entity) < 5.0)) continue;
            entity.f_19864_ = true;
            entity.m_20256_(entity.m_20184_().m_82520_(-x / d * 5.0, -y / d * 0.3, -z / d * 5.0));
            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 15.0f);
            entity.f_19802_ = 0;
        }
    }

    public void escapeFromTarget() {
        if (this.m_5448_() != null) {
            LivingEntity target = this.m_5448_();
            double x = target.m_20185_() - this.m_20185_();
            double y = target.m_20186_() - this.m_20186_();
            double z = target.m_20189_() - this.m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z);
            if ((double)this.m_20270_((Entity)target) < 10.0 && d != 0.0) {
                this.f_19864_ = true;
                this.m_20256_(this.m_20184_().m_82520_(-x / d * 5.0, -y / d * 2.0 + 0.5, -z / d * 5.0));
            }
        }
    }

    public boolean m_21254_() {
        return !this.isAttacking();
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_146707_()) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (damageSource.equals(DamageSource.f_19317_)) {
            return super.m_6469_(damageSource, f);
        }
        return super.m_6469_(damageSource, Math.min(10.0f, f));
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (accessor.equals(IS_ATTACKING) && this.isAttacking()) {
            this.attackAnimationState.m_216973_();
            this.attackAnimationState.m_216977_(this.f_19797_);
        }
        super.m_7350_(accessor);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (!this.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42386_)) {
                this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42386_));
            }
            if (!this.m_21120_(InteractionHand.OFF_HAND).m_150930_(Items.f_42740_)) {
                this.m_21008_(InteractionHand.OFF_HAND, new ItemStack((ItemLike)Items.f_42740_));
            }
            if (this.m_21526_()) {
                this.m_21559_(false);
            }
            if (this.m_5448_() != null) {
                LivingEntity target = this.m_5448_();
                if (this.f_19797_ % 20 == 0 && !this.isAttacking() && (double)this.m_20270_((Entity)target) < 3.0) {
                    this.setAttacking(true);
                    this.setAttackTicks(0);
                }
            } else {
                this.setAttacking(false);
                this.setAttackTicks(0);
            }
            if (this.isAttacking()) {
                this.setAttackTicks(this.getAttackTicks() + 1);
                if (this.getAttackTicks() == 10 || this.getAttackTicks() == 20) {
                    this.performAttack();
                }
                if (this.getAttackTicks() == 25) {
                    this.escapeFromTarget();
                }
                if (this.getAttackTicks() > 40) {
                    this.setAttackTicks(0);
                    this.setAttacking(false);
                }
            }
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return this.m_21275_(p_33034_) ? SoundEvents.f_12346_ : SoundEvents.f_12579_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12576_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12578_;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12577_;
    }

    class LookAtTargetGoal
    extends Goal {
        public LookAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return VindicatorWithShield.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            return VindicatorWithShield.this.m_5448_() != null;
        }

        public void m_8037_() {
            VindicatorWithShield.this.f_21344_.m_26573_();
            if (VindicatorWithShield.this.m_5448_() != null) {
                VindicatorWithShield.this.m_21563_().m_24960_((Entity)VindicatorWithShield.this.m_5448_(), 100.0f, 100.0f);
            }
        }
    }
}

