/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.leosillagers.entity;

import cn.leolezury.leosillagers.entity.Lava;
import cn.leolezury.leosillagers.entity.Wind;
import cn.leolezury.leosillagers.entity.WoodenPillar;
import cn.leolezury.leosillagers.init.EntityInit;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Summoner
extends AbstractIllager {
    public AnimationState fangsAnimationState = new AnimationState();
    public AnimationState buffAnimationState = new AnimationState();
    public AnimationState windAnimationState = new AnimationState();
    public AnimationState summonAnimationState = new AnimationState();
    public AnimationState lavaAnimationState = new AnimationState();
    public AnimationState oakAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    int fangsCoolDown = 0;
    int buffCoolDown = 0;
    int windCoolDown = 0;
    int summonCoolDown = 0;
    int lavaCoolDown = 0;
    int oakCoolDown = 0;
    protected static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(Summoner.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> ATTACK_TICKS = SynchedEntityData.m_135353_(Summoner.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Summoner(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int attackState) {
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)attackState);
    }

    public int getAttackTicks() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TICKS);
    }

    public void setAttackTicks(int attackTicks) {
        this.f_19804_.m_135381_(ATTACK_TICKS, (Object)attackTicks);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TICKS, (Object)0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SummonerApproachGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTargetGoal());
        this.f_21345_.m_25352_(3, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(4, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 200.0).m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void escapeFromTarget() {
        if (this.m_5448_() != null) {
            LivingEntity target = this.m_5448_();
            double x = target.m_20185_() - this.m_20185_();
            double y = target.m_20186_() - this.m_20186_();
            double z = target.m_20189_() - this.m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z);
            if ((double)this.m_20270_((Entity)target) < 10.0 && d != 0.0) {
                this.f_19864_ = true;
                this.m_20256_(this.m_20184_().m_82520_(-x / d * 1.5, -y / d * 0.3 + 0.5, -z / d * 1.5));
            }
        }
    }

    public boolean m_6785_(double p_37894_) {
        return false;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_146707_() || damageSource.m_7639_() instanceof AbstractIllager) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (damageSource.equals(DamageSource.f_19317_)) {
            return super.m_6469_(damageSource, f);
        }
        return super.m_6469_(damageSource, Math.min(20.0f, f));
    }

    protected void m_6153_() {
        if (this.f_20919_ == 0) {
            this.stopAllAnimStates();
            this.deathAnimationState.m_216977_(this.f_19797_);
            this.setAttackState(-1);
        }
        ++this.f_20919_;
        if (this.f_20919_ == 40 && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void stopAllAnimStates() {
        this.fangsAnimationState.m_216973_();
        this.buffAnimationState.m_216973_();
        this.windAnimationState.m_216973_();
        this.summonAnimationState.m_216973_();
        this.lavaAnimationState.m_216973_();
        this.oakAnimationState.m_216973_();
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (accessor.equals(ATTACK_STATE) && this.getAttackState() != 0) {
            this.stopAllAnimStates();
            switch (this.getAttackState()) {
                case 1: {
                    this.fangsAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.buffAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.windAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.summonAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.lavaAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.oakAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(accessor);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.getAttackState() != 5) {
                this.escapeFromTarget();
            }
            if (this.m_5448_() == null || !this.m_5448_().m_6084_()) {
                this.setAttackState(0);
            }
            if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
                LivingEntity target = this.m_5448_();
                if (this.fangsCoolDown > 0) {
                    --this.fangsCoolDown;
                }
                if (this.buffCoolDown > 0) {
                    --this.buffCoolDown;
                }
                if (this.windCoolDown > 0) {
                    --this.windCoolDown;
                }
                if (this.summonCoolDown > 0) {
                    --this.summonCoolDown;
                }
                if (this.lavaCoolDown > 0) {
                    --this.lavaCoolDown;
                }
                if (this.oakCoolDown > 0) {
                    --this.oakCoolDown;
                }
                if (this.getAttackState() == 0) {
                    this.setAttackTicks(0);
                    if (this.fangsCoolDown == 0) {
                        this.setAttackState(1);
                        this.fangsCoolDown = 500;
                    } else if (this.buffCoolDown == 0) {
                        this.setAttackState(2);
                        this.buffCoolDown = 500;
                    } else if (this.windCoolDown == 0) {
                        this.setAttackState(3);
                        this.windCoolDown = 500;
                    } else if (this.summonCoolDown == 0) {
                        this.setAttackState(4);
                        this.summonCoolDown = 500;
                    } else if (this.lavaCoolDown == 0) {
                        this.setAttackState(5);
                        this.lavaCoolDown = 500;
                    } else if (this.oakCoolDown == 0) {
                        this.setAttackState(6);
                        this.oakCoolDown = 500;
                    }
                }
                switch (this.getAttackState()) {
                    case 1: {
                        if (this.getAttackTicks() == 20) {
                            double d0 = Math.min(target.m_20186_(), this.m_20186_());
                            double d1 = Math.max(target.m_20186_(), this.m_20186_()) + 1.0;
                            float f = (float)Mth.m_14136_((double)(target.m_20189_() - this.m_20189_()), (double)(target.m_20185_() - this.m_20185_()));
                            for (int i = 0; i < 5; ++i) {
                                float f1 = f + (float)i * (float)Math.PI * 0.4f;
                                this.createSpellEntity(this.m_20185_() + (double)Mth.m_14089_((float)f1) * 1.5, this.m_20189_() + (double)Mth.m_14031_((float)f1) * 1.5, d0, d1, f1, 0);
                            }
                            for (int k = 0; k < 8; ++k) {
                                float f2 = f + (float)k * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                                this.createSpellEntity(this.m_20185_() + (double)Mth.m_14089_((float)f2) * 2.5, this.m_20189_() + (double)Mth.m_14031_((float)f2) * 2.5, d0, d1, f2, 3);
                            }
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 41);
                        break;
                    }
                    case 2: {
                        List raiders;
                        if (this.getAttackTicks() == 20 && !(raiders = this.f_19853_.m_45971_(Raider.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82400_(30.0))).isEmpty()) {
                            Raider chosenRaider = (Raider)raiders.get(this.m_217043_().m_188503_(raiders.size()));
                            chosenRaider.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 400, 0));
                            chosenRaider.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 400, 1));
                            chosenRaider.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 400, 1));
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 41);
                        break;
                    }
                    case 3: {
                        if (this.getAttackTicks() == 30) {
                            Wind wind = new Wind((EntityType<? extends Monster>)((EntityType)EntityInit.WIND.get()), this.f_19853_);
                            wind.m_146884_(this.m_20182_());
                            wind.setTargetOffset(target.m_20185_() - this.m_20185_(), target.m_20186_() - this.m_20186_(), target.m_20189_() - this.m_20189_());
                            this.f_19853_.m_7967_((Entity)wind);
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 41);
                        break;
                    }
                    case 4: {
                        if (this.getAttackTicks() == 40) {
                            for (Vex vex : this.f_19853_.m_45971_(Vex.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82400_(50.0))) {
                                vex.m_146870_();
                            }
                            ServerLevel serverLevel = (ServerLevel)this.f_19853_;
                            for (int i = 0; i < 5; ++i) {
                                BlockPos blockPos = this.m_20183_().m_7918_(-2 + this.f_19796_.m_188503_(5), 1, -2 + this.f_19796_.m_188503_(5));
                                Vex vex = (Vex)EntityType.f_20491_.m_20615_(this.f_19853_);
                                vex.m_20035_(blockPos, 0.0f, 0.0f);
                                vex.m_6518_((ServerLevelAccessor)serverLevel, this.f_19853_.m_6436_(blockPos), MobSpawnType.MOB_SUMMONED, null, null);
                                vex.m_33994_((Mob)this);
                                vex.m_34033_(blockPos);
                                vex.m_33987_(20 * (30 + this.f_19796_.m_188503_(90)));
                                serverLevel.m_47205_((Entity)vex);
                            }
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 61);
                        break;
                    }
                    case 5: {
                        if (this.getAttackTicks() == 20) {
                            Lava lava = new Lava((EntityType<? extends Monster>)((EntityType)EntityInit.LAVA.get()), this.f_19853_);
                            lava.m_146884_(target.m_20182_());
                            this.f_19853_.m_7967_((Entity)lava);
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 41);
                        break;
                    }
                    case 6: {
                        if (this.getAttackTicks() == 40) {
                            WoodenPillar pillar;
                            int i;
                            for (i = 0; i < 3; ++i) {
                                Pillager chosenPillager;
                                List pillagers = this.f_19853_.m_45971_(Pillager.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82400_(30.0));
                                if (pillagers.isEmpty() || (chosenPillager = (Pillager)pillagers.get(this.m_217043_().m_188503_(pillagers.size()))).m_20202_() != null) continue;
                                pillar = new WoodenPillar((EntityType<? extends Monster>)((EntityType)EntityInit.WOODEN_PILLAR.get()), this.f_19853_);
                                pillar.m_146884_(chosenPillager.m_20182_());
                                this.f_19853_.m_7967_((Entity)pillar);
                                pillar.m_20334_(this.m_217043_().m_188500_() - 0.5, 0.1, this.m_217043_().m_188500_() - 0.5);
                                chosenPillager.m_20329_((Entity)pillar);
                            }
                            for (i = 0; i < 3; ++i) {
                                Evoker chosenEvoker;
                                List evokers = this.f_19853_.m_45971_(Evoker.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82400_(30.0));
                                if (evokers.isEmpty() || (chosenEvoker = (Evoker)evokers.get(this.m_217043_().m_188503_(evokers.size()))).m_20202_() != null) continue;
                                pillar = new WoodenPillar((EntityType<? extends Monster>)((EntityType)EntityInit.WOODEN_PILLAR.get()), this.f_19853_);
                                pillar.m_146884_(chosenEvoker.m_20182_());
                                this.f_19853_.m_7967_((Entity)pillar);
                                pillar.m_20334_(this.m_217043_().m_188500_() - 0.5, 0.1, this.m_217043_().m_188500_() - 0.5);
                                chosenEvoker.m_20329_((Entity)pillar);
                            }
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 61);
                    }
                }
                if (this.getAttackTicks() == 0) {
                    this.setAttackState(0);
                }
            }
        }
    }

    private void createSpellEntity(double p_32673_, double p_32674_, double p_32675_, double p_32676_, float p_32677_, int p_32678_) {
        BlockPos blockpos = new BlockPos(p_32673_, p_32676_, p_32674_);
        boolean flag = false;
        double d0 = 0.0;
        do {
            BlockState blockstate1;
            VoxelShape voxelshape;
            BlockPos blockpos1;
            BlockState blockstate;
            if (!(blockstate = this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)this.f_19853_, blockpos1, Direction.UP)) continue;
            if (!this.f_19853_.m_46859_(blockpos) && !(voxelshape = (blockstate1 = this.f_19853_.m_8055_(blockpos)).m_60812_((BlockGetter)this.f_19853_, blockpos)).m_83281_()) {
                d0 = voxelshape.m_83297_(Direction.Axis.Y);
            }
            flag = true;
            break;
        } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)p_32675_) - 1);
        if (flag) {
            this.f_19853_.m_7967_((Entity)new EvokerFangs(this.f_19853_, p_32673_, (double)blockpos.m_123342_() + d0, p_32674_, p_32677_, p_32678_, (LivingEntity)this));
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_11866_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11861_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11864_;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_11863_;
    }

    class SummonerApproachGoal
    extends MeleeAttackGoal {
        public SummonerApproachGoal(PathfinderMob pathfinderMob, double d1, boolean b) {
            super(pathfinderMob, d1, b);
        }

        public boolean m_8045_() {
            return super.m_8045_() && Summoner.this.m_5448_() != null && Summoner.this.m_20270_((Entity)Summoner.this.m_5448_()) >= 10.0f;
        }
    }

    class LookAtTargetGoal
    extends Goal {
        public LookAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return Summoner.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            return Summoner.this.m_5448_() != null;
        }

        public void m_8037_() {
            Summoner.this.f_21344_.m_26573_();
            if (Summoner.this.m_5448_() != null) {
                Summoner.this.m_21563_().m_24960_((Entity)Summoner.this.m_5448_(), 100.0f, 100.0f);
            }
        }
    }
}

