/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.leosillagers.entity;

import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class Necromancer
extends AbstractIllager
implements PowerableMob {
    public AnimationState attackAnimationState = new AnimationState();
    int attackCoolDown = 0;
    protected static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.m_135353_(Necromancer.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> ATTACK_TICKS = SynchedEntityData.m_135353_(Necromancer.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int soulCount = 0;

    public Necromancer(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(IS_ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(IS_ATTACKING, (Object)attacking);
    }

    public int getAttackTicks() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TICKS);
    }

    public void setAttackTicks(int attackTicks) {
        this.f_19804_.m_135381_(ATTACK_TICKS, (Object)attackTicks);
    }

    public int getSoulCount() {
        return this.soulCount;
    }

    public void setSoulCount(int count) {
        this.soulCount = count;
    }

    public void m_7378_(CompoundTag compound) {
        this.setSoulCount(compound.m_128451_("SoulCount"));
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("SoulCount", this.getSoulCount());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ATTACKING, (Object)false);
        this.f_19804_.m_135372_(ATTACK_TICKS, (Object)0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new NecromancerApproachGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTargetGoal());
        this.f_21345_.m_25352_(3, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(4, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public boolean m_7090_() {
        return this.isAttacking();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void escapeFromTarget() {
        if (this.m_5448_() != null) {
            LivingEntity target = this.m_5448_();
            double x = target.m_20185_() - this.m_20185_();
            double y = target.m_20186_() - this.m_20186_();
            double z = target.m_20189_() - this.m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z) * 8.0;
            if ((double)this.m_20270_((Entity)target) < 10.0 && d != 0.0) {
                this.f_19864_ = true;
                this.m_20334_(-x / d, -y / d, -z / d);
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_146707_() || damageSource.m_7639_() instanceof AbstractIllager) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (damageSource.equals(DamageSource.f_19317_)) {
            return super.m_6469_(damageSource, f);
        }
        if (this.isAttacking()) {
            return false;
        }
        return super.m_6469_(damageSource, Math.min(15.0f, f));
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (accessor.equals(IS_ATTACKING) && this.isAttacking()) {
            this.attackAnimationState.m_216973_();
            this.attackAnimationState.m_216977_(this.f_19797_);
        }
        super.m_7350_(accessor);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (!this.isAttacking()) {
                this.escapeFromTarget();
            }
            if (this.m_5448_() == null || !this.m_5448_().m_6084_()) {
                this.setAttacking(false);
            }
            if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
                LivingEntity target = this.m_5448_();
                if (this.attackCoolDown > 0) {
                    --this.attackCoolDown;
                }
                if (!this.isAttacking()) {
                    this.setAttackTicks(0);
                    if (this.attackCoolDown == 0 && this.getSoulCount() > 0) {
                        this.setAttacking(true);
                        this.attackCoolDown = 300;
                    }
                }
                if (this.isAttacking()) {
                    ZombieVillager zombieVillager;
                    if (this.getAttackTicks() % 20 == 0 && this.getSoulCount() > 0 && (zombieVillager = (ZombieVillager)EntityType.f_20530_.m_20615_(this.f_19853_)) != null) {
                        zombieVillager.m_146884_(this.m_20182_());
                        this.f_19853_.m_7967_((Entity)zombieVillager);
                        zombieVillager.m_20334_(this.m_217043_().m_188500_(), 0.1, this.m_217043_().m_188500_());
                        zombieVillager.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 1000, 0));
                        this.setSoulCount(this.getSoulCount() - 1);
                    }
                    this.setAttackTicks((this.getAttackTicks() + 1) % 100);
                }
                if (this.getAttackTicks() == 0) {
                    this.setAttacking(false);
                }
            }
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_11866_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11861_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11864_;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_11863_;
    }

    class NecromancerApproachGoal
    extends MeleeAttackGoal {
        public NecromancerApproachGoal(PathfinderMob pathfinderMob, double d1, boolean b) {
            super(pathfinderMob, d1, b);
        }

        public boolean m_8045_() {
            return super.m_8045_() && (Necromancer.this.isAttacking() || Necromancer.this.m_5448_() != null && Necromancer.this.m_20270_((Entity)Necromancer.this.m_5448_()) >= 10.0f);
        }
    }

    class LookAtTargetGoal
    extends Goal {
        public LookAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return Necromancer.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            return Necromancer.this.m_5448_() != null;
        }

        public void m_8037_() {
            Necromancer.this.f_21344_.m_26573_();
            if (Necromancer.this.m_5448_() != null) {
                Necromancer.this.m_21563_().m_24960_((Entity)Necromancer.this.m_5448_(), 100.0f, 100.0f);
            }
        }
    }
}

