/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.leosillagers.entity;

import cn.leolezury.leosillagers.entity.ChargedCreeper;
import cn.leolezury.leosillagers.entity.LightningBall;
import cn.leolezury.leosillagers.entity.LightningHalo;
import cn.leolezury.leosillagers.entity.LightningRod;
import cn.leolezury.leosillagers.init.EntityInit;
import java.util.EnumSet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;

public class LightningCaller
extends AbstractIllager {
    public AnimationState haloAnimationState = new AnimationState();
    public AnimationState rodsAnimationState = new AnimationState();
    public AnimationState ballsAnimationState = new AnimationState();
    public AnimationState creeperAnimationState = new AnimationState();
    public AnimationState meleeAnimationState = new AnimationState();
    public AnimationState healAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    int haloCoolDown = 0;
    int rodsCoolDown = 0;
    int ballsCoolDown = 0;
    int creeperCoolDown = 0;
    int meleeCoolDown = 0;
    int healCoolDown = 0;
    int damageTaken = 0;
    protected static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(LightningCaller.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> ATTACK_TICKS = SynchedEntityData.m_135353_(LightningCaller.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public LightningCaller(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int attackState) {
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)attackState);
    }

    public int getAttackTicks() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TICKS);
    }

    public void setAttackTicks(int attackTicks) {
        this.f_19804_.m_135381_(ATTACK_TICKS, (Object)attackTicks);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TICKS, (Object)0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LightningCallerApproachGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTargetGoal());
        this.f_21345_.m_25352_(3, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(4, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 200.0).m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void escapeFromTarget() {
        if (this.m_5448_() != null) {
            LivingEntity target = this.m_5448_();
            double x = target.m_20185_() - this.m_20185_();
            double y = target.m_20186_() - this.m_20186_();
            double z = target.m_20189_() - this.m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z);
            if ((double)this.m_20270_((Entity)target) < 10.0 && d != 0.0) {
                this.f_19864_ = true;
                this.m_20256_(this.m_20184_().m_82520_(-x / d * 1.5, -y / d * 0.3 + 0.5, -z / d * 1.5));
            }
        }
    }

    public boolean m_6785_(double p_37894_) {
        return false;
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_146707_() || damageSource.m_7639_() instanceof AbstractIllager) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (damageSource.equals(DamageSource.f_19317_)) {
            return super.m_6469_(damageSource, f);
        }
        if (this.getAttackState() == 6) {
            this.damageTaken = (int)((float)this.damageTaken + Math.min(5.0f, f));
            return false;
        }
        return super.m_6469_(damageSource, Math.min(20.0f, f));
    }

    protected void m_6153_() {
        if (this.f_20919_ == 0) {
            this.stopAllAnimStates();
            this.deathAnimationState.m_216977_(this.f_19797_);
            this.setAttackState(-1);
        }
        ++this.f_20919_;
        if (this.f_20919_ == 100 && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_((Entity)this, (byte)60);
            LightningBolt lightningBolt = new LightningBolt(EntityType.f_20465_, this.f_19853_);
            lightningBolt.m_20874_(true);
            lightningBolt.m_146884_(this.m_20182_());
            this.f_19853_.m_7967_((Entity)lightningBolt);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void stopAllAnimStates() {
        this.haloAnimationState.m_216973_();
        this.rodsAnimationState.m_216973_();
        this.ballsAnimationState.m_216973_();
        this.creeperAnimationState.m_216973_();
        this.meleeAnimationState.m_216973_();
        this.healAnimationState.m_216973_();
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (accessor.equals(ATTACK_STATE) && this.getAttackState() != 0) {
            this.stopAllAnimStates();
            switch (this.getAttackState()) {
                case 1: {
                    this.haloAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.rodsAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.ballsAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.creeperAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.meleeAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.healAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(accessor);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.getAttackState() != 5) {
                this.escapeFromTarget();
            }
            if (this.m_5448_() == null || !this.m_5448_().m_6084_()) {
                this.setAttackState(0);
            }
            if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
                LivingEntity target = this.m_5448_();
                if (this.haloCoolDown > 0) {
                    --this.haloCoolDown;
                }
                if (this.rodsCoolDown > 0) {
                    --this.rodsCoolDown;
                }
                if (this.ballsCoolDown > 0) {
                    --this.ballsCoolDown;
                }
                if (this.creeperCoolDown > 0) {
                    --this.creeperCoolDown;
                }
                if (this.meleeCoolDown > 0) {
                    --this.meleeCoolDown;
                }
                if (this.healCoolDown > 0) {
                    --this.healCoolDown;
                }
                if (this.getAttackState() == 0) {
                    this.setAttackTicks(0);
                    if (this.haloCoolDown == 0) {
                        this.setAttackState(1);
                        this.haloCoolDown = 500;
                    } else if (this.rodsCoolDown == 0) {
                        this.setAttackState(2);
                        this.rodsCoolDown = 500;
                    } else if (this.ballsCoolDown == 0) {
                        this.setAttackState(3);
                        this.ballsCoolDown = 500;
                    } else if (this.creeperCoolDown == 0) {
                        this.setAttackState(4);
                        this.creeperCoolDown = 500;
                    } else if (this.meleeCoolDown == 0) {
                        this.setAttackState(5);
                        this.meleeCoolDown = 500;
                    }
                    if (this.healCoolDown == 0 && this.m_21223_() / this.m_21233_() <= 0.6f) {
                        this.setAttackState(6);
                        this.healCoolDown = 500;
                    }
                }
                switch (this.getAttackState()) {
                    case 1: {
                        if (this.getAttackTicks() == 40) {
                            LightningHalo halo = new LightningHalo((EntityType<? extends Monster>)((EntityType)EntityInit.LIGHTNING_HALO.get()), this.f_19853_);
                            halo.setOwner((LivingEntity)this);
                            halo.m_146884_(target.m_20182_());
                            this.f_19853_.m_7967_((Entity)halo);
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 81);
                        break;
                    }
                    case 2: {
                        if (this.getAttackTicks() % 40 == 0) {
                            for (int i = 0; i < 10; ++i) {
                                LightningRod rod = new LightningRod((EntityType<? extends Monster>)((EntityType)EntityInit.LIGHTNING_ROD.get()), this.f_19853_);
                                rod.m_146884_(target.m_20182_().m_82520_((2.0 * this.m_217043_().m_188500_() - 1.0) * 2.0, 0.0, (2.0 * this.m_217043_().m_188500_() - 1.0) * 2.0));
                                this.f_19853_.m_7967_((Entity)rod);
                            }
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 101);
                        break;
                    }
                    case 3: {
                        if (this.getAttackTicks() % 10 == 0) {
                            LightningBall ball = new LightningBall((EntityType<? extends Monster>)((EntityType)EntityInit.LIGHTNING_BALL.get()), this.f_19853_);
                            ball.m_6710_(target);
                            ball.m_146884_(this.m_20182_().m_82520_(0.0, 1.0, 0.0));
                            this.f_19853_.m_7967_((Entity)ball);
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 201);
                        break;
                    }
                    case 4: {
                        if (this.getAttackTicks() == 20) {
                            ChargedCreeper creeper = new ChargedCreeper((EntityType<? extends Monster>)((EntityType)EntityInit.CHARGED_CREEPER.get()), this.f_19853_);
                            creeper.m_6710_(target);
                            creeper.m_146884_(this.m_20182_());
                            this.f_19853_.m_7967_((Entity)creeper);
                            creeper.f_19864_ = true;
                            creeper.m_20334_(0.1, 0.1, 0.1);
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 21);
                        break;
                    }
                    case 5: {
                        if (this.getAttackTicks() > 40) {
                            double x = this.m_20185_() - target.m_20185_();
                            double y = this.m_20186_() - target.m_20186_();
                            double z = this.m_20189_() - target.m_20189_();
                            double d = Math.sqrt(x * x + y * y + z * z);
                            this.f_19864_ = true;
                            this.m_20256_(this.m_20184_().m_82520_(-x / d * 2.0, -y / d * 2.0, -z / d * 2.0));
                            for (LivingEntity livingEntity : this.f_19853_.m_45971_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82400_(2.0))) {
                                if (livingEntity instanceof AbstractIllager) continue;
                                livingEntity.m_6469_(DamageSource.m_19370_((LivingEntity)this), 10.0f);
                                if (!livingEntity.m_20148_().equals(target.m_20148_())) continue;
                                this.setAttackTicks(200);
                            }
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 201);
                        break;
                    }
                    case 6: {
                        if (this.getAttackTicks() >= 5) {
                            this.m_5634_(0.2f);
                        }
                        if (this.damageTaken >= 15) {
                            this.setAttackTicks(200);
                            this.damageTaken = 0;
                        }
                        if (this.getAttackState() == 0) break;
                        this.setAttackTicks((this.getAttackTicks() + 1) % 201);
                    }
                }
                if (this.getAttackTicks() == 0) {
                    this.setAttackState(0);
                }
            }
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_12051_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12048_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12050_;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12048_;
    }

    class LightningCallerApproachGoal
    extends MeleeAttackGoal {
        public LightningCallerApproachGoal(PathfinderMob pathfinderMob, double d1, boolean b) {
            super(pathfinderMob, d1, b);
        }

        public boolean m_8045_() {
            return super.m_8045_() && LightningCaller.this.m_5448_() != null && LightningCaller.this.m_20270_((Entity)LightningCaller.this.m_5448_()) >= 10.0f;
        }
    }

    class LookAtTargetGoal
    extends Goal {
        public LookAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return LightningCaller.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            return LightningCaller.this.m_5448_() != null;
        }

        public void m_8037_() {
            LightningCaller.this.f_21344_.m_26573_();
            if (LightningCaller.this.m_5448_() != null) {
                LightningCaller.this.m_21563_().m_24960_((Entity)LightningCaller.this.m_5448_(), 100.0f, 100.0f);
            }
        }
    }
}

