/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.leosillagers.entity;

import cn.leolezury.leosillagers.init.EntityInit;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Confuser
extends AbstractIllager {
    public AnimationState splitAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    int splitCoolDown = 0;
    protected static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(Confuser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> ATTACK_TICKS = SynchedEntityData.m_135353_(Confuser.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> IS_PHANTOM = SynchedEntityData.m_135353_(Confuser.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Confuser(EntityType<? extends AbstractIllager> entityType, Level level) {
        super(entityType, level);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int attackState) {
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)attackState);
    }

    public int getAttackTicks() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_TICKS);
    }

    public void setAttackTicks(int attackTicks) {
        this.f_19804_.m_135381_(ATTACK_TICKS, (Object)attackTicks);
    }

    public boolean isPhantom() {
        return (Boolean)this.f_19804_.m_135370_(IS_PHANTOM);
    }

    public void setPhantom(boolean isPhantom) {
        this.f_19804_.m_135381_(IS_PHANTOM, (Object)isPhantom);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)0);
        this.f_19804_.m_135372_(ATTACK_TICKS, (Object)0);
        this.f_19804_.m_135372_(IS_PHANTOM, (Object)false);
    }

    public void m_7378_(CompoundTag compound) {
        this.setPhantom(compound.m_128471_("IsPhantom"));
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128379_("IsPhantom", this.isPhantom());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ConfuserApproachGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTargetGoal());
        this.f_21345_.m_25352_(3, (Goal)new AbstractIllager.RaiderOpenDoorGoal((AbstractIllager)this, (Raider)this));
        this.f_21345_.m_25352_(4, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public void escapeFromTarget() {
        if (this.m_5448_() != null) {
            LivingEntity target = this.m_5448_();
            double x = target.m_20185_() - this.m_20185_();
            double y = target.m_20186_() - this.m_20186_();
            double z = target.m_20189_() - this.m_20189_();
            double d = Math.sqrt(x * x + y * y + z * z);
            if ((double)this.m_20270_((Entity)target) < 10.0 && d != 0.0) {
                this.f_19864_ = true;
                this.m_20334_(-x / d * 5.0, -y / d * 2.0 + 0.5, -z / d * 5.0);
            }
        }
    }

    public boolean m_6673_(DamageSource damageSource) {
        if (damageSource.m_146707_() || damageSource.m_7639_() instanceof AbstractIllager) {
            return true;
        }
        return super.m_6673_(damageSource);
    }

    public boolean m_6469_(DamageSource damageSource, float f) {
        if (damageSource.equals(DamageSource.f_19317_)) {
            return super.m_6469_(damageSource, f);
        }
        if (damageSource instanceof EntityDamageSource && !this.isPhantom()) {
            for (int i = 0; i < 5 && !this.teleportTowardsTarget(); ++i) {
            }
        }
        if (this.isPhantom()) {
            return false;
        }
        return super.m_6469_(damageSource, Math.min(15.0f, f));
    }

    boolean teleportTowardsTarget() {
        if (this.m_5448_() != null) {
            Vec3 vec3 = new Vec3(this.m_20185_() - this.m_5448_().m_20185_(), this.m_20227_(0.5) - this.m_5448_().m_20188_(), this.m_20189_() - this.m_5448_().m_20189_());
            vec3 = vec3.m_82541_();
            double d1 = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
            double d2 = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
            double d3 = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
            return this.teleport(d1, d2, d3);
        }
        return false;
    }

    private boolean teleport(double p_32544_, double p_32545_, double p_32546_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(p_32544_, p_32545_, p_32546_);
        while (blockpos$mutableblockpos.m_123342_() > this.f_19853_.m_141937_() && !this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos).m_60767_().m_76334_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.f_19853_.m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_60767_().m_76334_();
        if (flag) {
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(p_32544_, p_32545_, p_32546_, true);
            if (flag2) {
                this.f_19853_.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.f_19853_.m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    public void stopAllAnimStates() {
        this.splitAnimationState.m_216973_();
        this.attackAnimationState.m_216973_();
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (accessor.equals(ATTACK_STATE) && this.getAttackState() != 0) {
            this.stopAllAnimStates();
            switch (this.getAttackState()) {
                case 1: {
                    this.splitAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(accessor);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isPhantom() && this.f_19797_ > 60) {
            this.m_146870_();
        }
        if (!this.f_19853_.f_46443_) {
            if (!this.m_21120_(InteractionHand.MAIN_HAND).m_150930_(Items.f_42411_)) {
                this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
            }
            if (this.m_21526_()) {
                this.m_21559_(false);
            }
            if (this.getAttackState() == 0) {
                this.escapeFromTarget();
            }
            if (this.m_5448_() == null || !this.m_5448_().m_6084_()) {
                if (this.isPhantom()) {
                    this.m_146870_();
                } else {
                    this.setAttackState(0);
                }
            }
            if (this.m_5448_() != null && this.m_5448_().m_6084_()) {
                LivingEntity target = this.m_5448_();
                if (this.splitCoolDown > 0) {
                    --this.splitCoolDown;
                }
                if (this.getAttackState() == 0) {
                    this.setAttackTicks(0);
                    if (this.splitCoolDown == 0) {
                        this.setAttackState(1);
                        this.splitCoolDown = 600;
                    }
                }
                switch (this.getAttackState()) {
                    case 1: {
                        if (this.getAttackTicks() != 60) break;
                        for (int i = 0; i < 2; ++i) {
                            Confuser confuser = new Confuser((EntityType<? extends AbstractIllager>)((EntityType)EntityInit.CONFUSER.get()), this.f_19853_);
                            confuser.m_6710_(target);
                            confuser.setPhantom(true);
                            confuser.m_146884_(this.m_20182_());
                            confuser.setAttackState(2);
                            confuser.setAttackTicks(0);
                            for (int j = 0; j < 5 && !this.teleportTowardsTarget(); ++j) {
                            }
                            this.f_19853_.m_7967_((Entity)confuser);
                            for (Mob mob : this.f_19853_.m_45971_(Mob.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82400_(30.0))) {
                                if (mob.m_5448_() == null || !mob.m_5448_().m_20148_().equals(this.m_20148_())) continue;
                                mob.m_6710_((LivingEntity)confuser);
                            }
                        }
                        this.setAttackState(2);
                        this.setAttackTicks(0);
                        break;
                    }
                    case 2: {
                        if (this.getAttackTicks() >= 20 && this.getAttackTicks() % 20 == 0) {
                            for (int i = 0; i < 5 && !this.teleportTowardsTarget(); ++i) {
                            }
                            target.f_19802_ = 0;
                            Arrow arrow = new Arrow(EntityType.f_20548_, this.f_19853_);
                            arrow.m_5602_((Entity)this);
                            arrow.m_146884_(this.m_20182_().m_82520_(0.0, 1.0, 0.0));
                            double x = this.m_20185_() - target.m_20185_();
                            double y = this.m_20186_() - target.m_20186_();
                            double z = this.m_20189_() - target.m_20189_();
                            double d = Math.sqrt(x * x + y * y + z * z);
                            arrow.m_20334_(-x / d * 4.0, -y / d * 4.0, -z / d * 4.0);
                            this.f_19853_.m_7967_((Entity)arrow);
                        }
                        if (this.getAttackTicks() != 50 || !this.isPhantom()) break;
                        this.m_146870_();
                    }
                }
                if (this.getAttackState() != 0) {
                    this.setAttackTicks((this.getAttackTicks() + 1) % 61);
                }
                if (this.getAttackTicks() == 0) {
                    this.setAttackState(0);
                }
            }
        }
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return SoundEvents.f_12051_;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12048_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12050_;
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12048_;
    }

    class ConfuserApproachGoal
    extends MeleeAttackGoal {
        public ConfuserApproachGoal(PathfinderMob pathfinderMob, double d1, boolean b) {
            super(pathfinderMob, d1, b);
        }

        public boolean m_8045_() {
            return super.m_8045_() && Confuser.this.m_5448_() != null && Confuser.this.m_20270_((Entity)Confuser.this.m_5448_()) >= 10.0f;
        }
    }

    class LookAtTargetGoal
    extends Goal {
        public LookAtTargetGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE, Goal.Flag.JUMP));
        }

        public boolean m_8036_() {
            return Confuser.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            return Confuser.this.m_5448_() != null;
        }

        public void m_8037_() {
            Confuser.this.f_21344_.m_26573_();
            if (Confuser.this.m_5448_() != null) {
                Confuser.this.m_21563_().m_24960_((Entity)Confuser.this.m_5448_(), 100.0f, 100.0f);
            }
        }
    }
}

