/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.leosillagers.client.model;

import cn.leolezury.leosillagers.client.model.animation.SummonerAnimation;
import cn.leolezury.leosillagers.entity.Summoner;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class SummonerModel<T extends Summoner>
extends HierarchicalModel<T>
implements HeadedModel,
ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("leosillagers", "summoner"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart eyebrow1;
    private final ModelPart eyebrow2;
    private final ModelPart body;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart arms;

    public SummonerModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
        this.head = root.m_171324_("body").m_171324_("head");
        this.eyebrow1 = root.m_171324_("body").m_171324_("head").m_171324_("eyebrow1");
        this.eyebrow2 = root.m_171324_("body").m_171324_("head").m_171324_("eyebrow2");
        this.left_arm = root.m_171324_("body").m_171324_("left_arm");
        this.right_arm = root.m_171324_("body").m_171324_("right_arm");
        this.arms = root.m_171324_("body").m_171324_("arms");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition eyebrow1 = head.m_171599_("eyebrow1", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(-2.5f, -2.0f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 6).m_171488_(-1.5f, -1.0f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.5f, (float)-4.0f, (float)-4.5f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition eyebrow2 = head.m_171599_("eyebrow2", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171480_().m_171488_(-0.5f, -2.0f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 6).m_171480_().m_171488_(-1.5f, -1.0f, -0.5f, 3.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)2.5f, (float)-4.0f, (float)-4.5f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 22).m_171480_().m_171488_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(40, 38).m_171488_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.left_leg.f_104203_ = -1.2f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.right_leg.f_104203_ = 1.2f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.body.m_233569_();
        this.head.f_104205_ = 0.0f;
        this.eyebrow1.m_233569_();
        this.eyebrow2.m_233569_();
        this.left_arm.m_233569_();
        this.right_arm.m_233569_();
        if (((Summoner)((Object)entity)).getAttackState() != 0 || ((Summoner)((Object)entity)).f_20919_ > 0) {
            this.arms.f_104207_ = false;
            this.left_arm.f_104207_ = true;
            this.right_arm.f_104207_ = true;
        } else {
            this.arms.f_104207_ = true;
            this.left_arm.f_104207_ = false;
            this.right_arm.f_104207_ = false;
        }
        if (((Summoner)((Object)entity)).getAttackTicks() >= 0 && ((Summoner)((Object)entity)).getAttackState() != 0 && ((Summoner)((Object)entity)).f_20919_ <= 0) {
            int state = ((Summoner)((Object)entity)).getAttackState();
            switch (state) {
                case 1: {
                    this.m_233381_(((Summoner)((Object)entity)).fangsAnimationState, SummonerAnimation.FANGS, ageInTicks);
                    break;
                }
                case 2: {
                    this.m_233381_(((Summoner)((Object)entity)).buffAnimationState, SummonerAnimation.BUFF, ageInTicks);
                    break;
                }
                case 3: {
                    this.m_233381_(((Summoner)((Object)entity)).windAnimationState, SummonerAnimation.WIND, ageInTicks);
                    break;
                }
                case 4: {
                    this.m_233381_(((Summoner)((Object)entity)).summonAnimationState, SummonerAnimation.SUMMON, ageInTicks);
                    break;
                }
                case 5: {
                    this.m_233381_(((Summoner)((Object)entity)).lavaAnimationState, SummonerAnimation.LAVA, ageInTicks);
                    break;
                }
                case 6: {
                    this.m_233381_(((Summoner)((Object)entity)).oakAnimationState, SummonerAnimation.OAK, ageInTicks);
                }
            }
        }
        if (((Summoner)((Object)entity)).f_20919_ > 0) {
            this.m_233381_(((Summoner)((Object)entity)).deathAnimationState, SummonerAnimation.DEATH, ageInTicks);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.left_arm : this.right_arm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).m_104299_(poseStack);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

