/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.leosillagers.client.model;

import cn.leolezury.leosillagers.client.model.animation.MeteoriteCallerAnimation;
import cn.leolezury.leosillagers.entity.MeteoriteCaller;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class MeteoriteCallerModel<T extends MeteoriteCaller>
extends HierarchicalModel<T>
implements HeadedModel,
ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("leosillagers", "meteorite_caller"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart arms;

    public MeteoriteCallerModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
        this.head = root.m_171324_("body").m_171324_("head");
        this.left_arm = root.m_171324_("body").m_171324_("left_arm");
        this.right_arm = root.m_171324_("body").m_171324_("right_arm");
        this.arms = root.m_171324_("body").m_171324_("arms");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)0.3f));
        PartDefinition arms_rotation = arms.m_171599_("arms_rotation", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-8.0f, 0.0f, -2.05f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(40, 38).m_171488_(-4.0f, 4.0f, -2.05f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.05f, (float)-0.7505f, (float)0.0f, (float)0.0f));
        PartDefinition arms_flipped = arms_rotation.m_171599_("arms_flipped", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171488_(4.0f, -24.0f, -2.05f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition left_arm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.left_leg.f_104203_ = -1.2f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.right_leg.f_104203_ = 1.2f * Mth.m_14156_((float)limbSwing, (float)13.0f) * limbSwingAmount;
        this.body.m_233569_();
        this.head.m_233569_();
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.left_arm.m_233569_();
        this.right_arm.m_233569_();
        if (((MeteoriteCaller)((Object)entity)).isAttacking()) {
            this.arms.f_104207_ = false;
            this.left_arm.f_104207_ = true;
            this.right_arm.f_104207_ = true;
        } else {
            this.arms.f_104207_ = true;
            this.left_arm.f_104207_ = false;
            this.right_arm.f_104207_ = false;
        }
        if (((MeteoriteCaller)((Object)entity)).getAttackTicks() >= 0 && ((MeteoriteCaller)((Object)entity)).isAttacking()) {
            this.m_233381_(((MeteoriteCaller)((Object)entity)).attackAnimationState, MeteoriteCallerAnimation.ATTACK, ageInTicks);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.left_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.right_leg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.left_arm : this.right_arm;
    }

    public void m_6002_(HumanoidArm arm, PoseStack poseStack) {
        this.getArm(arm).m_104299_(poseStack);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

