/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.leosillagers;

import cn.leolezury.leosillagers.client.model.ChargedCreeperModel;
import cn.leolezury.leosillagers.client.model.ConfuserModel;
import cn.leolezury.leosillagers.client.model.LavaModel;
import cn.leolezury.leosillagers.client.model.LightningBallModel;
import cn.leolezury.leosillagers.client.model.LightningCallerModel;
import cn.leolezury.leosillagers.client.model.LightningHaloModel;
import cn.leolezury.leosillagers.client.model.LightningRodModel;
import cn.leolezury.leosillagers.client.model.MeteoriteCallerModel;
import cn.leolezury.leosillagers.client.model.MeteoriteModel;
import cn.leolezury.leosillagers.client.model.NecromancerModel;
import cn.leolezury.leosillagers.client.model.SnowingCloudModel;
import cn.leolezury.leosillagers.client.model.SnowolagerModel;
import cn.leolezury.leosillagers.client.model.SummonerModel;
import cn.leolezury.leosillagers.client.model.VindicatorWithShieldModel;
import cn.leolezury.leosillagers.client.model.WindModel;
import cn.leolezury.leosillagers.client.model.WoodenPillarModel;
import cn.leolezury.leosillagers.client.renderer.ChargedCreeperRenderer;
import cn.leolezury.leosillagers.client.renderer.ConfuserRenderer;
import cn.leolezury.leosillagers.client.renderer.LavaRenderer;
import cn.leolezury.leosillagers.client.renderer.LightningBallRenderer;
import cn.leolezury.leosillagers.client.renderer.LightningCallerRenderer;
import cn.leolezury.leosillagers.client.renderer.LightningHaloRenderer;
import cn.leolezury.leosillagers.client.renderer.LightningRodRenderer;
import cn.leolezury.leosillagers.client.renderer.MeteoriteCallerRenderer;
import cn.leolezury.leosillagers.client.renderer.MeteoriteRenderer;
import cn.leolezury.leosillagers.client.renderer.NecromancerRenderer;
import cn.leolezury.leosillagers.client.renderer.SnowingCloudRenderer;
import cn.leolezury.leosillagers.client.renderer.SnowolagerRenderer;
import cn.leolezury.leosillagers.client.renderer.SummonerRenderer;
import cn.leolezury.leosillagers.client.renderer.VindicatorWithShieldRenderer;
import cn.leolezury.leosillagers.client.renderer.WindRenderer;
import cn.leolezury.leosillagers.client.renderer.WoodenPillarRenderer;
import cn.leolezury.leosillagers.client.renderer.layer.CreeperEnergyLayer;
import cn.leolezury.leosillagers.client.renderer.layer.LightningBallEnergyLayer;
import cn.leolezury.leosillagers.client.renderer.layer.NecromancerEnergyLayer;
import cn.leolezury.leosillagers.entity.ChargedCreeper;
import cn.leolezury.leosillagers.entity.Confuser;
import cn.leolezury.leosillagers.entity.Lava;
import cn.leolezury.leosillagers.entity.LightningBall;
import cn.leolezury.leosillagers.entity.LightningCaller;
import cn.leolezury.leosillagers.entity.LightningHalo;
import cn.leolezury.leosillagers.entity.LightningRod;
import cn.leolezury.leosillagers.entity.Meteorite;
import cn.leolezury.leosillagers.entity.MeteoriteCaller;
import cn.leolezury.leosillagers.entity.Necromancer;
import cn.leolezury.leosillagers.entity.SnowingCloud;
import cn.leolezury.leosillagers.entity.Snowolager;
import cn.leolezury.leosillagers.entity.Summoner;
import cn.leolezury.leosillagers.entity.VindicatorWithShield;
import cn.leolezury.leosillagers.entity.Wind;
import cn.leolezury.leosillagers.entity.WoodenPillar;
import cn.leolezury.leosillagers.init.EntityInit;
import cn.leolezury.leosillagers.init.ItemInit;
import cn.leolezury.leosillagers.raid.RaiderTypes;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.ArrayUtils;

@Mod(value="leosillagers")
public class LeosIllagers {
    public static final String MODID = "leosillagers";

    public LeosIllagers() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeEventBus = MinecraftForge.EVENT_BUS;
        modEventBus.addListener(ClientEvents::onRegisterRenderer);
        modEventBus.addListener(ClientEvents::onRegisterLayers);
        modEventBus.addListener(ModEvents::onAttributeCreate);
        modEventBus.addListener(ModEvents::onSpawnPlacementRegister);
        forgeEventBus.addListener(ModEvents::onJoinLevel);
        forgeEventBus.addListener(ModEvents::onLevelLoad);
        forgeEventBus.addListener(ModEvents::onLevelUnload);
        forgeEventBus.addListener(ModEvents::onDeath);
        EntityInit.ENTITIES.register(modEventBus);
        ItemInit.ITEMS.register(modEventBus);
    }

    public class ModEvents {
        public static void onAttributeCreate(EntityAttributeCreationEvent event) {
            event.put((EntityType)EntityInit.VINDICATOR_WITH_SHIELD.get(), VindicatorWithShield.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.CONFUSER.get(), Confuser.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.METEORITE_CALLER.get(), MeteoriteCaller.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.METEORITE.get(), Meteorite.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.SNOWOLAGER.get(), Snowolager.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.SNOWING_CLOUD.get(), SnowingCloud.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.LIGHTNING_CALLER.get(), LightningCaller.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.LIGHTNING_HALO.get(), LightningHalo.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.LIGHTNING_ROD.get(), LightningRod.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.LIGHTNING_BALL.get(), LightningBall.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.CHARGED_CREEPER.get(), ChargedCreeper.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.SUMMONER.get(), Summoner.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.WOODEN_PILLAR.get(), WoodenPillar.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.WIND.get(), Wind.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.LAVA.get(), Lava.createAttributes().m_22265_());
            event.put((EntityType)EntityInit.NECROMANCER.get(), Necromancer.createAttributes().m_22265_());
        }

        public static void onSpawnPlacementRegister(SpawnPlacementRegisterEvent event) {
            event.register((EntityType)EntityInit.VINDICATOR_WITH_SHIELD.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityInit.CONFUSER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityInit.METEORITE_CALLER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityInit.SNOWOLAGER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityInit.LIGHTNING_CALLER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityInit.SUMMONER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
            event.register((EntityType)EntityInit.NECROMANCER.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.OR);
        }

        public static void onJoinLevel(EntityJoinLevelEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof AbstractVillager) {
                double runSpeed = 1.0;
                if (entity instanceof Villager) {
                    runSpeed = 0.8;
                }
                if (entity instanceof WanderingTrader) {
                    runSpeed = 0.5;
                }
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, VindicatorWithShield.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, Confuser.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, MeteoriteCaller.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, Meteorite.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, Snowolager.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, SnowingCloud.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, LightningCaller.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, LightningHalo.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, LightningRod.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, LightningBall.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, ChargedCreeper.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, Summoner.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, WoodenPillar.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, Wind.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, Lava.class, 8.0f, runSpeed, runSpeed));
                ((PathfinderMob)entity).f_21346_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)entity, Necromancer.class, 8.0f, runSpeed, runSpeed));
            }
        }

        public static void onLevelLoad(LevelEvent.Load event) {
            RaiderTypes.registerRaiderTypes();
        }

        public static void onLevelUnload(LevelEvent.Unload event) {
            Raid.RaiderType[] members;
            for (Raid.RaiderType member : members = Raid.RaiderType.values()) {
                if (!RaiderTypes.RAIDER_TYPES.contains(member)) continue;
                ArrayUtils.remove((Object[])members, (int)member.ordinal());
            }
        }

        public static void onDeath(LivingDeathEvent event) {
            if (event.getEntity() instanceof Villager && !event.getEntity().f_19853_.f_46443_) {
                ServerLevel serverLevel = (ServerLevel)event.getEntity().f_19853_;
                List necromancers = serverLevel.m_45971_(Necromancer.class, TargetingConditions.f_26872_, event.getEntity(), event.getEntity().m_20191_().m_82400_(50.0));
                for (Necromancer necromancer : necromancers) {
                    necromancer.setSoulCount(necromancer.getSoulCount() + 1);
                }
            }
        }
    }

    public class ClientEvents {
        public static void onRegisterRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer((EntityType)EntityInit.VINDICATOR_WITH_SHIELD.get(), VindicatorWithShieldRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.CONFUSER.get(), ConfuserRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.METEORITE_CALLER.get(), MeteoriteCallerRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.METEORITE.get(), MeteoriteRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.SNOWOLAGER.get(), SnowolagerRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.SNOWING_CLOUD.get(), SnowingCloudRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.LIGHTNING_CALLER.get(), LightningCallerRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.LIGHTNING_HALO.get(), LightningHaloRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.LIGHTNING_ROD.get(), LightningRodRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.LIGHTNING_BALL.get(), LightningBallRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.CHARGED_CREEPER.get(), ChargedCreeperRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.SUMMONER.get(), SummonerRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.WOODEN_PILLAR.get(), WoodenPillarRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.WIND.get(), WindRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.LAVA.get(), LavaRenderer::new);
            event.registerEntityRenderer((EntityType)EntityInit.NECROMANCER.get(), NecromancerRenderer::new);
        }

        public static void onRegisterLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(VindicatorWithShieldModel.LAYER_LOCATION, VindicatorWithShieldModel::createBodyLayer);
            event.registerLayerDefinition(ConfuserModel.LAYER_LOCATION, ConfuserModel::createBodyLayer);
            event.registerLayerDefinition(MeteoriteCallerModel.LAYER_LOCATION, MeteoriteCallerModel::createBodyLayer);
            event.registerLayerDefinition(MeteoriteModel.LAYER_LOCATION, MeteoriteModel::createBodyLayer);
            event.registerLayerDefinition(SnowolagerModel.LAYER_LOCATION, SnowolagerModel::createBodyLayer);
            event.registerLayerDefinition(SnowingCloudModel.LAYER_LOCATION, SnowingCloudModel::createBodyLayer);
            event.registerLayerDefinition(LightningCallerModel.LAYER_LOCATION, LightningCallerModel::createBodyLayer);
            event.registerLayerDefinition(LightningHaloModel.LAYER_LOCATION, LightningHaloModel::createBodyLayer);
            event.registerLayerDefinition(LightningRodModel.LAYER_LOCATION, LightningRodModel::createBodyLayer);
            event.registerLayerDefinition(LightningBallModel.LAYER_LOCATION, () -> LightningBallModel.createBodyLayer(0.0f));
            event.registerLayerDefinition(LightningBallEnergyLayer.LAYER_LOCATION, () -> LightningBallModel.createBodyLayer(0.5f));
            event.registerLayerDefinition(ChargedCreeperModel.LAYER_LOCATION, () -> ChargedCreeperModel.createBodyLayer(0.0f));
            event.registerLayerDefinition(CreeperEnergyLayer.LAYER_LOCATION, () -> ChargedCreeperModel.createBodyLayer(0.25f));
            event.registerLayerDefinition(SummonerModel.LAYER_LOCATION, SummonerModel::createBodyLayer);
            event.registerLayerDefinition(WoodenPillarModel.LAYER_LOCATION, WoodenPillarModel::createBodyLayer);
            event.registerLayerDefinition(WindModel.LAYER_LOCATION, WindModel::createBodyLayer);
            event.registerLayerDefinition(LavaModel.LAYER_LOCATION, LavaModel::createBodyLayer);
            event.registerLayerDefinition(NecromancerModel.LAYER_LOCATION, () -> NecromancerModel.createBodyLayer(0.0f));
            event.registerLayerDefinition(NecromancerEnergyLayer.LAYER_LOCATION, () -> NecromancerModel.createBodyLayer(0.25f));
        }
    }
}

