/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.network;

import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.network.BaseMessageClient;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class LoggedInMessage
extends BaseMessageClient {
    GrappleConfig.Config conf;

    public LoggedInMessage(FriendlyByteBuf buf) {
        super(buf);
    }

    public LoggedInMessage(GrappleConfig.Config serverconf) {
        this.conf = serverconf;
    }

    public <T> void decodeClass(FriendlyByteBuf buf, Class<T> theClass, T theObject) {
        Field[] fields = theClass.getDeclaredFields();
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Field field : fields) {
            Type fieldtype = field.getGenericType();
            try {
                if (fieldtype.getTypeName().equals("int")) {
                    field.setInt(theObject, buf.readInt());
                    continue;
                }
                if (fieldtype.getTypeName().equals("double")) {
                    field.setDouble(theObject, buf.readDouble());
                    continue;
                }
                if (fieldtype.getTypeName().equals("boolean")) {
                    field.setBoolean(theObject, buf.readBoolean());
                    continue;
                }
                if (fieldtype.getTypeName().equals("java.lang.String")) {
                    int len = buf.readInt();
                    CharSequence charseq = buf.readCharSequence(len, Charset.defaultCharset());
                    field.set(theObject, charseq.toString());
                    continue;
                }
                if (field.getType() != null && Object.class.isAssignableFrom(field.getType())) {
                    Class<?> newClass = field.getType();
                    this.decodeClass(buf, newClass, newClass.cast(field.get(theObject)));
                    continue;
                }
                System.out.println("Unknown Type");
                System.out.println(fieldtype.getTypeName());
            }
            catch (IllegalAccessException e) {
                System.out.println(e);
            }
        }
    }

    @Override
    public void decode(FriendlyByteBuf buf) {
        Class<GrappleConfig.Config> confclass = GrappleConfig.Config.class;
        this.conf = new GrappleConfig.Config();
        this.decodeClass(buf, confclass, this.conf);
    }

    public <T> void encodeClass(FriendlyByteBuf buf, Class<T> theClass, T theObject) {
        Field[] fields = theClass.getDeclaredFields();
        Arrays.sort(fields, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Field field : fields) {
            Type fieldtype = field.getGenericType();
            try {
                if (fieldtype.getTypeName().equals("int")) {
                    buf.writeInt(field.getInt(theObject));
                    continue;
                }
                if (fieldtype.getTypeName().equals("double")) {
                    buf.writeDouble(field.getDouble(theObject));
                    continue;
                }
                if (fieldtype.getTypeName().equals("boolean")) {
                    buf.writeBoolean(field.getBoolean(theObject));
                    continue;
                }
                if (fieldtype.getTypeName().equals("java.lang.String")) {
                    String str = (String)field.get(theObject);
                    buf.writeInt(str.length());
                    buf.writeCharSequence(str.subSequence(0, str.length()), Charset.defaultCharset());
                    continue;
                }
                if (field.getType() != null && Object.class.isAssignableFrom(field.getType())) {
                    Class<?> newClass = field.getType();
                    this.encodeClass(buf, newClass, newClass.cast(field.get(theObject)));
                    continue;
                }
                System.out.println("Unknown Type");
                System.out.println(fieldtype.getTypeName());
            }
            catch (IllegalAccessException e) {
                System.out.println(e);
            }
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        Class<GrappleConfig.Config> confclass = GrappleConfig.Config.class;
        this.encodeClass(buf, confclass, this.conf);
    }

    @Override
    public void processMessage(NetworkEvent.Context ctx) {
        GrappleConfig.setServerOptions(this.conf);
    }
}

