/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.client;

import com.yyon.grapplinghook.client.ClientControllerManager;
import com.yyon.grapplinghook.client.ClientSetup;
import com.yyon.grapplinghook.common.CommonSetup;
import com.yyon.grapplinghook.config.GrappleConfig;
import com.yyon.grapplinghook.controllers.AirfrictionController;
import com.yyon.grapplinghook.controllers.ForcefieldController;
import com.yyon.grapplinghook.controllers.GrappleController;
import com.yyon.grapplinghook.items.KeypressItem;
import com.yyon.grapplinghook.utils.Vec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandlers {
    public static ClientEventHandlers instance = null;
    public boolean[] prevKeys = new boolean[]{false, false, false, false, false};
    public float currentCameraTilt = 0.0f;

    public ClientEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && !Minecraft.m_91087_().m_91104_()) {
            ClientControllerManager.instance.onClientTick((Player)player);
            if (Minecraft.m_91087_().f_91080_ == null) {
                boolean[] keys = new boolean[]{ClientSetup.key_enderlaunch.m_90857_(), ClientSetup.key_leftthrow.m_90857_(), ClientSetup.key_rightthrow.m_90857_(), ClientSetup.key_boththrow.m_90857_(), ClientSetup.key_rocket.m_90857_()};
                for (int i = 0; i < keys.length; ++i) {
                    boolean iskeydown = keys[i];
                    boolean prevkey = this.prevKeys[i];
                    if (iskeydown != prevkey) {
                        KeypressItem.Keys key = KeypressItem.Keys.values()[i];
                        ItemStack stack = this.getKeypressStack((Player)player);
                        if (stack != null && !this.isLookingAtModifierBlock((Player)player)) {
                            if (iskeydown) {
                                ((KeypressItem)stack.m_41720_()).onCustomKeyDown(stack, (Player)player, key, true);
                            } else {
                                ((KeypressItem)stack.m_41720_()).onCustomKeyUp(stack, (Player)player, key, true);
                            }
                        }
                    }
                    this.prevKeys[i] = iskeydown;
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getPos() != null && ClientControllerManager.controllerPos.containsKey(event.getPos())) {
            GrappleController control = ClientControllerManager.controllerPos.get(event.getPos());
            control.unattach();
            ClientControllerManager.controllerPos.remove(event.getPos());
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOutEvent(ClientPlayerNetworkEvent.LoggingOut e) {
        GrappleConfig.setServerOptions(null);
    }

    @SubscribeEvent
    public void onKeyInputEvent(InputEvent.Key event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!Minecraft.m_91087_().m_91396_() || player == null) {
            return;
        }
        GrappleController controller = null;
        if (ClientControllerManager.controllers.containsKey(player.m_19879_())) {
            controller = ClientControllerManager.controllers.get(player.m_19879_());
        }
        if (Minecraft.m_91087_().f_91066_.f_92089_.m_90857_() && controller != null && controller instanceof AirfrictionController && ((AirfrictionController)controller).wasSliding) {
            controller.slidingJump();
        }
        ClientControllerManager.instance.checkSlide((Player)Minecraft.m_91087_().f_91074_);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInputUpdate(MovementInputUpdateEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!Minecraft.m_91087_().m_91396_() || player == null) {
            return;
        }
        int id = player.m_19879_();
        if (ClientControllerManager.controllers.containsKey(id)) {
            Input input = event.getInput();
            GrappleController control = ClientControllerManager.controllers.get(id);
            control.receivePlayerMovementMessage(input.f_108566_, input.f_108567_, input.f_108572_, input.f_108573_);
            boolean overrideMovement = true;
            if (Minecraft.m_91087_().f_91074_.m_20096_() && !(control instanceof AirfrictionController) && !(control instanceof ForcefieldController)) {
                overrideMovement = false;
            }
            if (overrideMovement) {
                input.f_108572_ = false;
                input.f_108569_ = false;
                input.f_108568_ = false;
                input.f_108570_ = false;
                input.f_108571_ = false;
                input.f_108567_ = 0.0f;
                input.f_108566_ = 0.0f;
            }
        }
    }

    @SubscribeEvent
    public void onCameraSetup(ViewportEvent.ComputeCameraAngles event) {
        float cameraDiff;
        GrappleController controller;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!Minecraft.m_91087_().m_91396_() || player == null) {
            return;
        }
        int id = player.m_19879_();
        int targetCameraTilt = 0;
        if (ClientControllerManager.controllers.containsKey(id) && (controller = ClientControllerManager.controllers.get(id)) instanceof AirfrictionController) {
            Vec walldirection;
            AirfrictionController afcontroller = (AirfrictionController)controller;
            if (afcontroller.wasWallrunning && (walldirection = afcontroller.getWallDirection()) != null) {
                int dir;
                Vec lookdirection = Vec.lookVec((Entity)player);
                targetCameraTilt = dir = lookdirection.cross((Vec)walldirection).y > 0.0 ? 1 : -1;
            }
        }
        if (this.currentCameraTilt != (float)targetCameraTilt && (cameraDiff = (float)targetCameraTilt - this.currentCameraTilt) != 0.0f) {
            float speed;
            float anim_s = GrappleConfig.getClientConf().camera.wallrun_camera_animation_s;
            float f = speed = anim_s == 0.0f ? 9999.0f : 1.0f / (anim_s * 20.0f);
            this.currentCameraTilt = speed > Math.abs(cameraDiff) ? (float)targetCameraTilt : (this.currentCameraTilt += speed * (float)(cameraDiff > 0.0f ? 1 : -1));
        }
        if (this.currentCameraTilt != 0.0f) {
            event.setRoll(event.getRoll() + this.currentCameraTilt * GrappleConfig.getClientConf().camera.wallrun_camera_tilt_degrees);
        }
    }

    public ItemStack getKeypressStack(Player player) {
        if (player != null) {
            Item item;
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (stack != null && (item = stack.m_41720_()) instanceof KeypressItem) {
                return stack;
            }
            stack = player.m_21120_(InteractionHand.OFF_HAND);
            if (stack != null && (item = stack.m_41720_()) instanceof KeypressItem) {
                return stack;
            }
        }
        return null;
    }

    public boolean isLookingAtModifierBlock(Player player) {
        HitResult raytraceresult = Minecraft.m_91087_().f_91077_;
        if (raytraceresult != null && raytraceresult.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult bray = (BlockHitResult)raytraceresult;
            BlockPos pos = bray.m_82425_();
            BlockState state = player.f_19853_.m_8055_(pos);
            return state.m_60734_() == CommonSetup.grappleModifierBlock.get();
        }
        return false;
    }
}

