/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math;

import java.util.List;
import java.util.function.UnaryOperator;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;

public class MthUtils {
    public static final float PHI = (float)(1.0 + (Math.sqrt(5.0) - 1.0) / 2.0);

    public static float[] polarToCartesian(float a, float r) {
        float x = r * Mth.m_14089_((float)a);
        float y = r * Mth.m_14031_((float)a);
        return new float[]{x, y};
    }

    public static float signedAngleDiff(double to, double from) {
        float x1 = Mth.m_14089_((float)((float)to));
        float y1 = Mth.m_14031_((float)((float)to));
        float x2 = Mth.m_14089_((float)((float)from));
        float y2 = Mth.m_14031_((float)((float)from));
        return (float)Mth.m_14136_((double)(x1 * y1 - y1 * x2), (double)(x1 * x2 + y1 * y2));
    }

    public static Vec3 changeBasisN(Vec3 newBasisYVector, Vec3 rot) {
        Vec3 y = newBasisYVector.m_82541_();
        Vec3 x = new Vec3(y.f_82480_, y.f_82481_, y.f_82479_).m_82541_();
        Vec3 z = y.m_82537_(x).m_82541_();
        return MthUtils.changeBasis(x, y, z, rot);
    }

    public static Vec3 changeBasis(Vec3 newX, Vec3 newY, Vec3 newZ, Vec3 rot) {
        return newX.m_82490_(rot.f_82479_).m_82549_(newY.m_82490_(rot.f_82480_)).m_82549_(newZ.m_82490_(rot.f_82481_));
    }

    public static Vec3 getNormalFrom3DData(int direction) {
        return MthUtils.V3itoV3(Direction.m_122376_((int)direction).m_122436_());
    }

    public static Vec3 V3itoV3(Vec3i v) {
        return new Vec3((double)v.m_123341_(), (double)v.m_123342_(), (double)v.m_123343_());
    }

    private static double isClockWise(UnaryOperator<Vec3> rot, Direction dir) {
        Vec3 v = MthUtils.V3itoV3(dir.m_122436_());
        Vec3 v2 = (Vec3)rot.apply(v);
        return v2.m_82526_(new Vec3(0.0, 1.0, 0.0));
    }

    public static Vec3 rotateVec3(Vec3 vec, Direction dir) {
        double cos = 1.0;
        double sin = 0.0;
        switch (dir) {
            case SOUTH: {
                cos = -1.0;
                sin = 0.0;
                break;
            }
            case WEST: {
                cos = 0.0;
                sin = 1.0;
                break;
            }
            case EAST: {
                cos = 0.0;
                sin = -1.0;
            }
        }
        double d0 = vec.f_82479_ * cos + vec.f_82481_ * sin;
        double d1 = vec.f_82480_;
        double d2 = vec.f_82481_ * cos - vec.f_82479_ * sin;
        return new Vec3(d0, d1, d2);
    }

    public static float averageAngles(Float ... angles) {
        float x = 0.0f;
        float y = 0.0f;
        Float[] floatArray = angles;
        int n = floatArray.length;
        for (int i = 0; i < n; ++i) {
            float a = floatArray[i].floatValue();
            x += Mth.m_14089_((float)((float)((double)a * Math.PI * 2.0)));
            y += Mth.m_14031_((float)((float)((double)a * Math.PI * 2.0)));
        }
        return (float)(Mth.m_14136_((double)y, (double)x) / (Math.PI * 2));
    }

    public static double wrapRad(double pValue) {
        double p = Math.PI * 2;
        double d0 = pValue % p;
        if (d0 >= Math.PI) {
            d0 -= p;
        }
        if (d0 < -Math.PI) {
            d0 += p;
        }
        return d0;
    }

    public static float wrapRad(float pValue) {
        float p = (float)Math.PI * 2;
        float d0 = pValue % p;
        if ((double)d0 >= Math.PI) {
            d0 -= p;
        }
        if ((double)d0 < -Math.PI) {
            d0 += p;
        }
        return d0;
    }

    public static float nextWeighted(RandomSource rand, float max, float bias) {
        float r = rand.m_188501_();
        if (bias <= 0.0f) {
            if (bias == 0.0f) {
                return r * max;
            }
            bias = -bias / (bias - 1.0f);
        }
        return max * (1.0f - r) / (bias * max * r + 1.0f);
    }

    public static float nextWeighted(RandomSource rand, float max, float bias, float min) {
        return MthUtils.nextWeighted(rand, max, bias) + min;
    }

    public static float nextWeighted(RandomSource rand, float max) {
        return MthUtils.nextWeighted(rand, max, 1.0f);
    }

    public static <T extends BaseColor<T>> T lerpColorScale(List<T> palette, float phase) {
        if (phase >= 1.0f) {
            phase %= 1.0f;
        }
        int n = palette.size();
        float g = (float)n * phase;
        int ind = (int)Math.floor(g);
        float delta = g % 1.0f;
        BaseColor start = (BaseColor)palette.get(ind);
        BaseColor end = (BaseColor)palette.get((ind + 1) % n);
        return (T)start.mixWith(end, delta);
    }
}

