/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.Codec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.ModStairBlock;
import net.mehvahdjukaar.moonlight.api.block.VerticalSlabBlock;
import net.mehvahdjukaar.moonlight.api.misc.RegSupplier;
import net.mehvahdjukaar.moonlight.api.misc.Registrator;
import net.mehvahdjukaar.moonlight.api.misc.TriFunction;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.forge.RegHelperImpl;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class RegHelper {
    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T, E extends T> RegSupplier<E> register(ResourceLocation name, Supplier<E> supplier, Registry<T> reg) {
        void var2_2;
        void var1_1;
        return RegHelperImpl.register(name, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void registerInBatch(Registry<T> reg, Consumer<Registrator<T>> eventListener) {
        void var1_1;
        RegHelperImpl.registerInBatch(reg, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T, E extends T> RegSupplier<E> registerAsync(ResourceLocation name, Supplier<E> supplier, Registry<T> reg) {
        void var2_2;
        void var1_1;
        return RegHelperImpl.registerAsync(name, var1_1, var2_2);
    }

    public static <T extends Block> RegSupplier<T> registerBlock(ResourceLocation name, Supplier<T> block) {
        return RegHelper.register(name, block, Registry.f_122824_);
    }

    public static <T extends Fluid> RegSupplier<T> registerFluid(ResourceLocation name, Supplier<T> fluid) {
        return RegHelper.register(name, fluid, Registry.f_122822_);
    }

    public static <T extends Item> RegSupplier<T> registerItem(ResourceLocation name, Supplier<T> item) {
        return RegHelper.register(name, item, Registry.f_122827_);
    }

    public static <T extends Feature<?>> RegSupplier<T> registerFeature(ResourceLocation name, Supplier<T> feature) {
        return RegHelper.register(name, feature, Registry.f_122839_);
    }

    public static <T extends StructureType<?>> RegSupplier<T> registerStructure(ResourceLocation name, Supplier<T> feature) {
        return RegHelper.registerAsync(name, feature, Registry.f_235740_);
    }

    public static <C extends FeatureConfiguration, F extends Feature<C>> RegSupplier<PlacedFeature> registerPlacedFeature(ResourceLocation name, RegSupplier<ConfiguredFeature<C, F>> feature, Supplier<List<PlacementModifier>> modifiers) {
        return RegHelper.registerPlacedFeature(name, () -> new PlacedFeature(Holder.m_205706_(feature.getHolder()), (List)modifiers.get()));
    }

    public static RegSupplier<PlacedFeature> registerPlacedFeature(ResourceLocation name, Supplier<PlacedFeature> featureSupplier) {
        return RegHelper.register(name, featureSupplier, BuiltinRegistries.f_194653_);
    }

    public static <C extends FeatureConfiguration, F extends Feature<C>> RegSupplier<ConfiguredFeature<C, F>> registerConfiguredFeature(ResourceLocation name, Supplier<F> feature, Supplier<C> featureConfiguration) {
        return RegHelper.registerConfiguredFeature(name, () -> new ConfiguredFeature((Feature)feature.get(), (FeatureConfiguration)featureConfiguration.get()));
    }

    public static <C extends FeatureConfiguration, F extends Feature<C>> RegSupplier<ConfiguredFeature<C, F>> registerConfiguredFeature(ResourceLocation name, Supplier<ConfiguredFeature<C, F>> featureSupplier) {
        return RegHelper.register(name, featureSupplier, BuiltinRegistries.f_123861_);
    }

    public static <T extends SoundEvent> RegSupplier<T> registerSound(ResourceLocation name, Supplier<T> sound) {
        return RegHelper.register(name, sound, Registry.f_122821_);
    }

    public static RegSupplier<SoundEvent> registerSound(ResourceLocation name) {
        return RegHelper.registerSound(name, () -> new SoundEvent(name));
    }

    public static <T extends PaintingVariant> RegSupplier<T> registerPainting(ResourceLocation name, Supplier<T> painting) {
        return RegHelper.register(name, painting, Registry.f_235728_);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <C extends AbstractContainerMenu> RegSupplier<MenuType<C>> registerMenuType(ResourceLocation name, TriFunction<Integer, Inventory, FriendlyByteBuf, C> containerFactory) {
        void var1_1;
        return RegHelperImpl.registerMenuType(name, var1_1);
    }

    public static <T extends MobEffect> RegSupplier<T> registerEffect(ResourceLocation name, Supplier<T> effect) {
        return RegHelper.register(name, effect, Registry.f_122823_);
    }

    public static <T extends Enchantment> RegSupplier<T> registerEnchantment(ResourceLocation name, Supplier<T> enchantment) {
        return RegHelper.register(name, enchantment, Registry.f_122825_);
    }

    public static <T extends SensorType<? extends Sensor<?>>> RegSupplier<T> registerSensor(ResourceLocation name, Supplier<T> sensorType) {
        return RegHelper.register(name, sensorType, Registry.f_122872_);
    }

    public static <T extends Sensor<?>> RegSupplier<SensorType<T>> registerSensorI(ResourceLocation name, Supplier<T> sensor) {
        return RegHelper.register(name, () -> new SensorType(sensor), Registry.f_122872_);
    }

    public static <T extends Activity> RegSupplier<T> registerActivity(ResourceLocation name, Supplier<T> activity) {
        return RegHelper.register(name, activity, Registry.f_122874_);
    }

    public static <T extends Schedule> RegSupplier<T> registerSchedule(ResourceLocation name, Supplier<T> schedule) {
        return RegHelper.register(name, schedule, Registry.f_122873_);
    }

    public static <T extends MemoryModuleType<?>> RegSupplier<T> registerMemoryModule(ResourceLocation name, Supplier<T> memory) {
        return RegHelper.register(name, memory, Registry.f_122871_);
    }

    public static <U> RegSupplier<MemoryModuleType<U>> registerMemoryModule(ResourceLocation name, @Nullable Codec<U> codec) {
        return RegHelper.register(name, () -> new MemoryModuleType(Optional.ofNullable(codec)), Registry.f_122871_);
    }

    public static <T extends RecipeSerializer<?>> RegSupplier<T> registerRecipeSerializer(ResourceLocation name, Supplier<T> recipe) {
        return RegHelper.register(name, recipe, Registry.f_122865_);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Recipe<?>> RegSupplier<RecipeSerializer<T>> registerSpecialRecipe(ResourceLocation name, Function<ResourceLocation, T> factory) {
        void var1_1;
        return RegHelperImpl.registerSpecialRecipe(name, var1_1);
    }

    public static <T extends Recipe<?>> Supplier<RecipeType<T>> registerRecipeType(ResourceLocation name) {
        return RegHelper.register(name, () -> {
            final String id = name.toString();
            return new RecipeType<T>(){

                public String toString() {
                    return id;
                }
            };
        }, Registry.f_122864_);
    }

    public static <T extends BlockEntityType<E>, E extends BlockEntity> RegSupplier<T> registerBlockEntityType(ResourceLocation name, Supplier<T> blockEntity) {
        return RegHelper.register(name, blockEntity, Registry.f_122830_);
    }

    public static RegSupplier<SimpleParticleType> registerParticle(ResourceLocation name) {
        return RegHelper.register(name, PlatformHelper::newParticle, Registry.f_122829_);
    }

    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height) {
        return RegHelper.registerEntityType(name, factory, category, width, height, 5);
    }

    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, int clientTrackingRange) {
        return RegHelper.registerEntityType(name, factory, category, width, height, clientTrackingRange, 3);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, EntityType.EntityFactory<T> factory, MobCategory category, float width, float height, int clientTrackingRange, int updateInterval) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        return RegHelperImpl.registerEntityType(name, var1_1, (MobCategory)var2_2, (float)var3_3, (float)var4_4, (int)var5_5, (int)var6_6);
    }

    public static <T extends Entity> RegSupplier<EntityType<T>> registerEntityType(ResourceLocation name, Supplier<EntityType<T>> type) {
        return RegHelper.register(name, type, Registry.f_122826_);
    }

    public static void registerCompostable(ItemLike name, float chance) {
        ComposterBlock.f_51914_.put((Object)name, chance);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerItemBurnTime(Item item, int burnTime) {
        void var1_1;
        RegHelperImpl.registerItemBurnTime(item, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerBlockFlammability(Block item, int fireSpread, int flammability) {
        void var2_2;
        void var1_1;
        RegHelperImpl.registerBlockFlammability(item, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerVillagerTrades(VillagerProfession profession, int level, Consumer<List<VillagerTrades.ItemListing>> factories) {
        void var2_2;
        void var1_1;
        RegHelperImpl.registerVillagerTrades(profession, (int)var1_1, (Consumer<List<VillagerTrades.ItemListing>>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerWanderingTraderTrades(int level, Consumer<List<VillagerTrades.ItemListing>> factories) {
        void var1_1;
        RegHelperImpl.registerWanderingTraderTrades(level, (Consumer<List<VillagerTrades.ItemListing>>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerSimpleRecipeCondition(ResourceLocation id, Predicate<String> predicate) {
        void var1_1;
        RegHelperImpl.registerSimpleRecipeCondition(id, (Predicate<String>)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addAttributeRegistration(Consumer<AttributeEvent> eventListener) {
        RegHelperImpl.addAttributeRegistration(eventListener);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addCommandRegistration(Consumer<CommandDispatcher<CommandSourceStack>> eventListener) {
        RegHelperImpl.addCommandRegistration(eventListener);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerBaseBlockSet(ResourceLocation baseName, Block parentBlock, boolean isHidden) {
        return RegHelper.registerBaseBlockSet(baseName, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parentBlock), isHidden);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerBaseBlockSet(ResourceLocation baseName, BlockBehaviour.Properties properties, boolean isHidden) {
        return RegHelper.registerBlockSet(new VariantType[]{VariantType.BLOCK, VariantType.SLAB, VariantType.VERTICAL_SLAB}, baseName, properties, isHidden);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerReducedBlockSet(ResourceLocation baseName, Block parentBlock, boolean isHidden) {
        return RegHelper.registerReducedBlockSet(baseName, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parentBlock), isHidden);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerReducedBlockSet(ResourceLocation baseName, BlockBehaviour.Properties properties, boolean isHidden) {
        return RegHelper.registerBlockSet(new VariantType[]{VariantType.BLOCK, VariantType.SLAB, VariantType.VERTICAL_SLAB, VariantType.STAIRS}, baseName, properties, isHidden);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerFullBlockSet(ResourceLocation baseName, Block parentBlock, boolean isHidden) {
        return RegHelper.registerFullBlockSet(baseName, BlockBehaviour.Properties.m_60926_((BlockBehaviour)parentBlock), isHidden);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerFullBlockSet(ResourceLocation baseName, BlockBehaviour.Properties properties, boolean isHidden) {
        return RegHelper.registerBlockSet(VariantType.values(), baseName, properties, isHidden);
    }

    public static EnumMap<VariantType, Supplier<Block>> registerBlockSet(VariantType[] types, ResourceLocation baseName, BlockBehaviour.Properties properties, boolean isHidden) {
        if (!new ArrayList<VariantType>(List.of(types)).contains((Object)VariantType.BLOCK)) {
            throw new IllegalStateException("Must contain base variant type");
        }
        EnumMap<VariantType, Supplier<Block>> map = new EnumMap<VariantType, Supplier<Block>>(VariantType.class);
        for (VariantType type : types) {
            String modId = baseName.m_135827_();
            Object name = baseName.m_135815_();
            if (!type.equals((Object)VariantType.BLOCK)) {
                name = (String)name + "_" + type.name().toLowerCase(Locale.ROOT);
            }
            Supplier<Block> base = type != VariantType.BLOCK ? map.get((Object)VariantType.BLOCK) : null;
            ResourceLocation blockId = new ResourceLocation(modId, (String)name);
            RegSupplier<Block> block = RegHelper.registerBlock(blockId, () -> type.create(properties, base));
            CreativeModeTab tab = switch (type) {
                case VariantType.VERTICAL_SLAB -> {
                    if (!isHidden && RegHelper.shouldRegisterVSlab()) {
                        yield CreativeModeTab.f_40749_;
                    }
                    yield null;
                }
                case VariantType.WALL -> {
                    if (!isHidden) {
                        yield CreativeModeTab.f_40750_;
                    }
                    yield null;
                }
                default -> !isHidden ? CreativeModeTab.f_40749_ : null;
            };
            RegHelper.registerItem(blockId, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
            map.put(type, block);
        }
        return map;
    }

    private static boolean shouldRegisterVSlab() {
        return PlatformHelper.isModLoaded("quark") || PlatformHelper.isModLoaded("v_slab_compat");
    }

    public static enum VariantType {
        BLOCK(Block::new),
        SLAB(SlabBlock::new),
        VERTICAL_SLAB(VerticalSlabBlock::new),
        WALL(WallBlock::new),
        STAIRS(ModStairBlock::new);

        private final BiFunction<Supplier<Block>, BlockBehaviour.Properties, Block> constructor;

        private VariantType(BiFunction<Supplier<Block>, BlockBehaviour.Properties, Block> constructor) {
            this.constructor = constructor;
        }

        private VariantType(Function<BlockBehaviour.Properties, Block> constructor) {
            this.constructor = (b, p) -> (Block)constructor.apply((BlockBehaviour.Properties)p);
        }

        private Block create(BlockBehaviour.Properties properties, @Nullable Supplier<Block> parent) {
            return this.constructor.apply(parent, properties);
        }
    }

    @FunctionalInterface
    public static interface AttributeEvent {
        public void register(EntityType<? extends LivingEntity> var1, AttributeSupplier.Builder var2);
    }
}

