/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.markers.GenericMapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.jetbrains.annotations.Nullable;

public class SimpleDecorationType
extends MapDecorationType<CustomMapDecoration, GenericMapBlockMarker<CustomMapDecoration>> {
    @Nullable
    private final RuleTest target;
    @Nullable
    private final String name;
    private final float rotation;
    public static final Codec<SimpleDecorationType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.f_74307_.optionalFieldOf("target_block").forGetter(SimpleDecorationType::getTarget), (App)Codec.STRING.optionalFieldOf("name").forGetter(SimpleDecorationType::getName), (App)Codec.FLOAT.optionalFieldOf("rotation").forGetter(SimpleDecorationType::getRotation)).apply((Applicative)instance, SimpleDecorationType::new));

    public SimpleDecorationType(Optional<RuleTest> target) {
        this(target, Optional.empty(), Optional.empty());
    }

    public SimpleDecorationType(Optional<RuleTest> target, Optional<String> name, Optional<Float> rotation) {
        this.target = target.orElse(null);
        this.name = name.orElse(null);
        this.rotation = rotation.orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Optional<RuleTest> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Float> getRotation() {
        return Optional.of(Float.valueOf(this.rotation));
    }

    @Override
    public boolean hasMarker() {
        return this.target != null;
    }

    public ResourceLocation getId() {
        return Utils.getID(this);
    }

    @Override
    @Nullable
    public CustomMapDecoration loadDecorationFromBuffer(FriendlyByteBuf buffer) {
        try {
            return new CustomMapDecoration(this, buffer);
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load custom map decoration for decoration type" + this.getId() + ": " + e);
            return null;
        }
    }

    @Override
    @Nullable
    public GenericMapBlockMarker<CustomMapDecoration> loadMarkerFromNBT(CompoundTag compound) {
        if (this.hasMarker()) {
            GenericMapBlockMarker<CustomMapDecoration> marker = new GenericMapBlockMarker<CustomMapDecoration>(this);
            try {
                marker.loadFromNBT(compound);
                return marker;
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Failed to load world map marker for decoration type" + this.getId() + ": " + e);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public GenericMapBlockMarker<CustomMapDecoration> getWorldMarkerFromWorld(BlockGetter reader, BlockPos pos) {
        if (this.target != null && this.target.m_213865_(reader.m_8055_(pos), RandomSource.m_216327_())) {
            return new GenericMapBlockMarker<CustomMapDecoration>(this, pos);
        }
        return null;
    }
}

