/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.widget;

import com.google.common.collect.Iterators;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import me.shedaniel.clothconfig2.api.AbstractConfigEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class SearchFieldEntry
extends AbstractConfigListEntry<Object> {
    private final EditBox editBox;
    private String[] lowerCases;

    public SearchFieldEntry(ConfigScreen screen, ClothConfigScreen.ListWidget<AbstractConfigEntry<AbstractConfigEntry<?>>> listWidget) {
        super((Component)Component.m_237119_(), false);
        this.editBox = new EditBox(Minecraft.m_91087_().f_91062_, 0, 0, 100, 18, (Component)Component.m_237119_());
        this.lowerCases = this.editBox.m_94155_().isEmpty() ? new String[]{} : this.editBox.m_94155_().toLowerCase(Locale.ROOT).split(" ");
        this.editBox.m_94151_(s -> {
            this.lowerCases = s.isEmpty() ? new String[]{} : s.toLowerCase(Locale.ROOT).split(" ");
        });
        listWidget.entriesTransformer = entries -> new AbstractList<AbstractConfigEntry<AbstractConfigEntry<?>>>((List)entries, screen){
            final /* synthetic */ List val$entries;
            final /* synthetic */ ConfigScreen val$screen;
            {
                this.val$entries = list;
                this.val$screen = configScreen;
            }

            @Override
            public Iterator<AbstractConfigEntry<AbstractConfigEntry<?>>> iterator() {
                if (SearchFieldEntry.this.editBox.m_94155_().isEmpty()) {
                    return this.val$entries.iterator();
                }
                return Iterators.filter(this.val$entries.iterator(), entry -> this.val$screen.matchesSearch(entry.getSearchTags()));
            }

            @Override
            public AbstractConfigEntry<AbstractConfigEntry<?>> get(int index) {
                return (AbstractConfigEntry)Iterators.get(this.iterator(), (int)index);
            }

            @Override
            public void add(int index, AbstractConfigEntry<AbstractConfigEntry<?>> element) {
                this.val$entries.add(index, element);
            }

            @Override
            public AbstractConfigEntry<AbstractConfigEntry<?>> remove(int index) {
                Object entry = this.get(index);
                return this.val$entries.remove(entry) ? entry : null;
            }

            @Override
            public boolean remove(Object o) {
                return this.val$entries.remove(o);
            }

            @Override
            public void clear() {
                this.val$entries.clear();
            }

            @Override
            public int size() {
                return Iterators.size(this.iterator());
            }
        };
    }

    public boolean matchesSearch(Iterator<String> tags) {
        if (this.lowerCases.length == 0) {
            return true;
        }
        if (!tags.hasNext()) {
            return true;
        }
        for (String lowerCase : this.lowerCases) {
            boolean found = false;
            for (String tag : () -> tags) {
                if (!tag.toLowerCase(Locale.ROOT).contains(lowerCase)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public void render(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        this.editBox.m_93674_(Mth.m_14045_((int)(entryWidth - 10), (int)0, (int)500));
        this.editBox.f_93620_ = x + entryWidth / 2 - this.editBox.m_5711_() / 2;
        this.editBox.f_93621_ = y + entryHeight / 2 - 9;
        this.editBox.m_6305_(matrices, mouseX, mouseY, delta);
        if (this.editBox.m_94155_().isEmpty()) {
            this.editBox.m_94167_("Search...");
        } else {
            this.editBox.m_94167_(null);
        }
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public Optional<Object> getDefaultValue() {
        return Optional.empty();
    }

    @Override
    public List<? extends NarratableEntry> narratables() {
        return List.of(this.editBox);
    }

    public List<? extends GuiEventListener> m_6702_() {
        return List.of(this.editBox);
    }
}

