/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.api.RawUdpPacket;
import de.maxhenkel.voicechat.api.VoicechatSocket;
import de.maxhenkel.voicechat.debug.CooldownTimer;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.permission.PermissionManager;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.AuthenticateAckPacket;
import de.maxhenkel.voicechat.voice.common.AuthenticatePacket;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.KeepAlivePacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import de.maxhenkel.voicechat.voice.common.Utils;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.GroupManager;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import de.maxhenkel.voicechat.voice.server.ServerCategoryManager;
import de.maxhenkel.voicechat.voice.server.ServerWorldUtils;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;

public class Server
extends Thread {
    private final Map<UUID, ClientConnection> connections;
    private final Map<UUID, UUID> secrets;
    private int port;
    private final MinecraftServer server;
    private VoicechatSocket socket;
    private final ProcessThread processThread;
    private final BlockingQueue<RawUdpPacket> packetQueue;
    private final PingManager pingManager;
    private final PlayerStateManager playerStateManager;
    private final GroupManager groupManager;
    private final ServerCategoryManager categoryManager;

    public Server(MinecraftServer server) {
        if (server instanceof DedicatedServer) {
            int configPort = Voicechat.SERVER_CONFIG.voiceChatPort.get();
            if (configPort < 0) {
                Voicechat.LOGGER.info("Using the Minecraft servers port as voice chat port");
                this.port = server.m_7010_();
            } else {
                this.port = configPort;
            }
        } else {
            this.port = 0;
        }
        this.server = server;
        this.socket = PluginManager.instance().getSocketImplementation(server);
        this.connections = new HashMap<UUID, ClientConnection>();
        this.secrets = new HashMap<UUID, UUID>();
        this.packetQueue = new LinkedBlockingQueue<RawUdpPacket>();
        this.pingManager = new PingManager(this);
        this.playerStateManager = new PlayerStateManager(this);
        this.groupManager = new GroupManager(this);
        this.categoryManager = new ServerCategoryManager(this);
        this.setDaemon(true);
        this.setName("VoiceChatServerThread");
        this.processThread = new ProcessThread();
        this.processThread.start();
    }

    @Override
    public void run() {
        try {
            this.socket.open(this.port, Voicechat.SERVER_CONFIG.voiceChatBindAddress.get());
            Voicechat.LOGGER.info("Server started at port {}", (Object)this.socket.getLocalPort());
            while (!this.socket.isClosed()) {
                try {
                    this.packetQueue.add(this.socket.read());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Voice chat server error {}", (Object)e.getMessage());
        }
    }

    public void changePort(int port) throws Exception {
        VoicechatSocket newSocket = PluginManager.instance().getSocketImplementation(this.server);
        newSocket.open(port, Voicechat.SERVER_CONFIG.voiceChatBindAddress.get());
        VoicechatSocket old = this.socket;
        this.socket = newSocket;
        this.port = port;
        old.close();
        this.connections.clear();
        this.secrets.clear();
    }

    public UUID getSecret(UUID playerUUID) {
        if (this.hasSecret(playerUUID)) {
            return this.secrets.get(playerUUID);
        }
        SecureRandom r = new SecureRandom();
        UUID secret = new UUID(r.nextLong(), r.nextLong());
        this.secrets.put(playerUUID, secret);
        return secret;
    }

    public boolean hasSecret(UUID playerUUID) {
        return this.secrets.containsKey(playerUUID);
    }

    public void disconnectClient(UUID playerUUID) {
        this.connections.remove(playerUUID);
        this.secrets.remove(playerUUID);
        PluginManager.instance().onPlayerDisconnected(playerUUID);
    }

    public void close() {
        this.socket.close();
        this.processThread.close();
        PluginManager.instance().onServerStopped();
    }

    public boolean isClosed() {
        return !this.processThread.running;
    }

    private void processMicPacket(ServerPlayer player, PlayerState state, MicPacket packet) throws Exception {
        if (state.hasGroup()) {
            this.processGroupPacket(state, player, packet);
            if (Voicechat.SERVER_CONFIG.openGroups.get().booleanValue()) {
                this.processProximityPacket(state, player, packet);
            }
            return;
        }
        this.processProximityPacket(state, player, packet);
    }

    private void processGroupPacket(PlayerState senderState, ServerPlayer sender, MicPacket packet) throws Exception {
        ClientGroup group = senderState.getGroup();
        if (group == null) {
            return;
        }
        GroupSoundPacket groupSoundPacket = new GroupSoundPacket(senderState.getUuid(), packet.getData(), packet.getSequenceNumber(), null);
        NetworkMessage soundMessage = new NetworkMessage(groupSoundPacket);
        for (PlayerState state : this.playerStateManager.getStates()) {
            ServerPlayer p;
            ClientConnection connection;
            if (!group.equals(state.getGroup()) || senderState.getUuid().equals(state.getUuid()) || (connection = this.getConnection(state.getUuid())) == null || (p = this.server.m_6846_().m_11259_(state.getUuid())) == null || PluginManager.instance().onSoundPacket(sender, senderState, p, state, groupSoundPacket, "group")) continue;
            connection.send(this, soundMessage);
        }
    }

    private void processProximityPacket(PlayerState senderState, ServerPlayer sender, MicPacket packet) throws Exception {
        ClientGroup group = senderState.getGroup();
        float distance = Utils.getDefaultDistance();
        SoundPacket soundPacket = null;
        String source = null;
        if (sender.m_5833_()) {
            ServerPlayer spectatingPlayer;
            Entity camera;
            if (Voicechat.SERVER_CONFIG.spectatorPlayerPossession.get().booleanValue() && (camera = sender.m_8954_()) instanceof ServerPlayer && (spectatingPlayer = (ServerPlayer)camera) != sender) {
                PlayerState receiverState = this.playerStateManager.getState(spectatingPlayer.m_20148_());
                ClientConnection connection = this.getConnection(receiverState.getUuid());
                if (connection == null) {
                    return;
                }
                GroupSoundPacket groupSoundPacket = new GroupSoundPacket(senderState.getUuid(), packet.getData(), packet.getSequenceNumber(), null);
                if (!PluginManager.instance().onSoundPacket(sender, senderState, spectatingPlayer, receiverState, groupSoundPacket, "spectator")) {
                    this.sendSoundPacket(spectatingPlayer, connection, groupSoundPacket);
                }
                return;
            }
            if (Voicechat.SERVER_CONFIG.spectatorInteraction.get().booleanValue()) {
                soundPacket = new LocationSoundPacket(sender.m_20148_(), sender.m_146892_(), packet.getData(), packet.getSequenceNumber(), distance, null);
                source = "spectator";
            }
        }
        if (soundPacket == null) {
            float crouchMultiplayer = sender.m_6047_() ? Voicechat.SERVER_CONFIG.crouchDistanceMultiplier.get().floatValue() : 1.0f;
            float whisperMultiplayer = packet.isWhispering() ? Voicechat.SERVER_CONFIG.whisperDistanceMultiplier.get().floatValue() : 1.0f;
            float multiplier = crouchMultiplayer * whisperMultiplayer;
            soundPacket = new PlayerSoundPacket(sender.m_20148_(), packet.getData(), packet.getSequenceNumber(), packet.isWhispering(), distance *= multiplier, null);
            source = "proximity";
        }
        this.broadcast(ServerWorldUtils.getPlayersInRange(sender.m_9236_(), sender.m_20182_(), this.getBroadcastRange(distance), p -> !p.m_20148_().equals(sender.m_20148_())), soundPacket, sender, senderState, group, source);
    }

    public void sendSoundPacket(ServerPlayer player, ClientConnection connection, SoundPacket<?> soundPacket) throws Exception {
        if (!PermissionManager.INSTANCE.LISTEN_PERMISSION.hasPermission(player)) {
            CooldownTimer.run("no-listen-" + player.m_20148_(), 30000L, () -> player.m_5661_((Component)Component.m_237115_((String)"message.voicechat.no_listen_permission"), true));
            return;
        }
        connection.send(this, new NetworkMessage(soundPacket));
    }

    public double getBroadcastRange(float minRange) {
        double broadcastRange = Voicechat.SERVER_CONFIG.broadcastRange.get();
        if (broadcastRange < 0.0) {
            broadcastRange = Voicechat.SERVER_CONFIG.voiceChatDistance.get() + 1.0;
        }
        return Math.max(broadcastRange, (double)minRange);
    }

    public void broadcast(Collection<ServerPlayer> players, SoundPacket<?> packet, @Nullable ServerPlayer sender, @Nullable PlayerState senderState, @Nullable ClientGroup group, String source) {
        for (ServerPlayer player : players) {
            ClientConnection connection;
            PlayerState state = this.playerStateManager.getState(player.m_20148_());
            if (state == null || state.isDisabled() || state.isDisconnected() || state.hasGroup() && state.getGroup().equals(group) || (connection = this.getConnection(player.m_36316_().getId())) == null) continue;
            try {
                if (PluginManager.instance().onSoundPacket(sender, senderState, player, state, packet, source)) continue;
                this.sendSoundPacket(player, connection, packet);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sendKeepAlives() throws Exception {
        long timestamp = System.currentTimeMillis();
        this.connections.values().removeIf(connection -> {
            if (timestamp - connection.getLastKeepAliveResponse() >= (long)Voicechat.SERVER_CONFIG.keepAlive.get().intValue() * 10L) {
                this.secrets.remove(connection.getPlayerUUID());
                Voicechat.LOGGER.info("Player {} timed out", (Object)connection.getPlayerUUID());
                ServerPlayer player = this.server.m_6846_().m_11259_(connection.getPlayerUUID());
                if (player != null) {
                    Voicechat.LOGGER.info("Reconnecting player {}", (Object)player.m_5446_().getString());
                    Voicechat.SERVER.initializePlayerConnection(player);
                } else {
                    Voicechat.LOGGER.warn("Reconnecting player {} failed (Could not find player)", (Object)connection.getPlayerUUID());
                }
                CommonCompatibilityManager.INSTANCE.emitServerVoiceChatDisconnectedEvent(connection.getPlayerUUID());
                PluginManager.instance().onPlayerDisconnected(connection.getPlayerUUID());
                return true;
            }
            return false;
        });
        for (ClientConnection connection2 : this.connections.values()) {
            this.sendPacket(new KeepAlivePacket(), connection2);
        }
    }

    public Map<UUID, ClientConnection> getConnections() {
        return this.connections;
    }

    @Nullable
    public ClientConnection getConnection(UUID playerID) {
        return this.connections.get(playerID);
    }

    public VoicechatSocket getSocket() {
        return this.socket;
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    public void sendPacket(Packet<?> packet, ClientConnection connection) throws Exception {
        connection.send(this, new NetworkMessage(packet));
    }

    public PingManager getPingManager() {
        return this.pingManager;
    }

    public PlayerStateManager getPlayerStateManager() {
        return this.playerStateManager;
    }

    public GroupManager getGroupManager() {
        return this.groupManager;
    }

    public ServerCategoryManager getCategoryManager() {
        return this.categoryManager;
    }

    public MinecraftServer getServer() {
        return this.server;
    }

    private class ProcessThread
    extends Thread {
        private boolean running = true;
        private long lastKeepAlive = 0L;

        public ProcessThread() {
            this.setDaemon(true);
            this.setName("VoiceChatPacketProcessingThread");
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    UUID playerUUID;
                    AuthenticatePacket packet;
                    UUID secret;
                    NetworkMessage message;
                    RawUdpPacket rawPacket;
                    Server.this.pingManager.checkTimeouts();
                    long keepAliveTime = System.currentTimeMillis();
                    if (keepAliveTime - this.lastKeepAlive > (long)Voicechat.SERVER_CONFIG.keepAlive.get().intValue()) {
                        Server.this.sendKeepAlives();
                        this.lastKeepAlive = keepAliveTime;
                    }
                    if ((rawPacket = Server.this.packetQueue.poll(10L, TimeUnit.MILLISECONDS)) == null) continue;
                    try {
                        message = NetworkMessage.readPacketServer(rawPacket, Server.this);
                    }
                    catch (Exception e) {
                        CooldownTimer.run("failed_reading_packet", () -> Voicechat.LOGGER.warn("Failed to read packet from {}", (Object)rawPacket.getSocketAddress()));
                        continue;
                    }
                    if (message == null) continue;
                    if (System.currentTimeMillis() - message.getTimestamp() > message.getTTL()) {
                        CooldownTimer.run("ttl", () -> {
                            Voicechat.LOGGER.warn("Dropping voice chat packets! Your Server might be overloaded!");
                            Voicechat.LOGGER.warn("Packet queue has {} packets", (Object)Server.this.packetQueue.size());
                        });
                        continue;
                    }
                    Packet<? extends Packet> packet2 = message.getPacket();
                    if (packet2 instanceof AuthenticatePacket && (secret = Server.this.secrets.get((packet = (AuthenticatePacket)packet2).getPlayerUUID())) != null && secret.equals(packet.getSecret())) {
                        ClientConnection connection;
                        if (!Server.this.connections.containsKey(packet.getPlayerUUID())) {
                            connection = new ClientConnection(packet.getPlayerUUID(), message.getAddress());
                            Server.this.connections.put(packet.getPlayerUUID(), connection);
                            Voicechat.LOGGER.info("Successfully authenticated player {}", (Object)packet.getPlayerUUID());
                            ServerPlayer player = Server.this.server.m_6846_().m_11259_(packet.getPlayerUUID());
                            if (player != null) {
                                CommonCompatibilityManager.INSTANCE.emitServerVoiceChatConnectedEvent(player);
                                PluginManager.instance().onPlayerConnected(player);
                            }
                        } else {
                            connection = Server.this.getConnection(packet.getPlayerUUID());
                        }
                        Server.this.sendPacket(new AuthenticateAckPacket(), connection);
                    }
                    if ((playerUUID = message.getSender(Server.this)) == null) continue;
                    ClientConnection conn = Server.this.getConnection(playerUUID);
                    Packet<? extends Packet> packet3 = message.getPacket();
                    if (packet3 instanceof MicPacket) {
                        MicPacket packet4 = (MicPacket)packet3;
                        ServerPlayer player = Server.this.server.m_6846_().m_11259_(playerUUID);
                        if (player == null) continue;
                        if (!PermissionManager.INSTANCE.SPEAK_PERMISSION.hasPermission(player)) {
                            CooldownTimer.run("no-speak-" + playerUUID, 30000L, () -> player.m_5661_((Component)Component.m_237115_((String)"message.voicechat.no_speak_permission"), true));
                            continue;
                        }
                        PlayerState state = Server.this.playerStateManager.getState(player.m_20148_());
                        if (state == null || PluginManager.instance().onMicPacket(player, state, packet4)) continue;
                        Server.this.processMicPacket(player, state, packet4);
                        continue;
                    }
                    packet3 = message.getPacket();
                    if (packet3 instanceof PingPacket) {
                        PingPacket packet5 = (PingPacket)packet3;
                        Server.this.pingManager.onPongPacket(packet5);
                        continue;
                    }
                    if (!(message.getPacket() instanceof KeepAlivePacket)) continue;
                    conn.setLastKeepAliveResponse(System.currentTimeMillis());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void close() {
            this.running = false;
        }
    }
}

