/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.group.GroupList;
import de.maxhenkel.voicechat.gui.group.JoinGroupScreen;
import de.maxhenkel.voicechat.gui.tooltips.DisableTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.HideGroupHudTooltipSupplier;
import de.maxhenkel.voicechat.gui.tooltips.MuteTooltipSupplier;
import de.maxhenkel.voicechat.gui.widgets.ImageButton;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ToggleImageButton;
import de.maxhenkel.voicechat.net.LeaveGroupPacket;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientPlayerStateManager;
import de.maxhenkel.voicechat.voice.client.MicrophoneActivationType;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import java.util.Collections;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class GroupScreen
extends ListScreenBase {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("voicechat", "textures/gui/gui_group.png");
    protected static final ResourceLocation LEAVE = new ResourceLocation("voicechat", "textures/icons/leave.png");
    protected static final ResourceLocation MICROPHONE = new ResourceLocation("voicechat", "textures/icons/microphone_button.png");
    protected static final ResourceLocation SPEAKER = new ResourceLocation("voicechat", "textures/icons/speaker_button.png");
    protected static final ResourceLocation GROUP_HUD = new ResourceLocation("voicechat", "textures/icons/group_hud_button.png");
    protected static final Component TITLE = Component.m_237115_((String)"gui.voicechat.group.title");
    protected static final Component LEAVE_GROUP = Component.m_237115_((String)"message.voicechat.leave_group");
    protected static final int HEADER_SIZE = 16;
    protected static final int FOOTER_SIZE = 32;
    protected static final int UNIT_SIZE = 18;
    protected static final int CELL_HEIGHT = 36;
    protected GroupList groupList;
    protected int units;
    protected final ClientGroup group;
    protected ToggleImageButton mute;
    protected ToggleImageButton disable;
    protected ToggleImageButton showHUD;
    protected ImageButton leave;

    public GroupScreen(ClientGroup group) {
        super(TITLE, 236, 0);
        this.group = group;
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft += 2;
        this.guiTop = 32;
        int minUnits = Mth.m_14167_((float)2.2222223f);
        this.units = Math.max(minUnits, (this.f_96544_ - 16 - 32 - this.guiTop * 2) / 18);
        this.ySize = 16 + this.units * 18 + 32;
        ClientPlayerStateManager stateManager = ClientManager.getPlayerStateManager();
        if (this.groupList != null) {
            this.groupList.m_93437_(this.f_96543_, this.f_96544_, this.guiTop + 16, this.guiTop + 16 + this.units * 18);
        } else {
            this.groupList = new GroupList(this, this.f_96543_, this.f_96544_, this.guiTop + 16, this.guiTop + 16 + this.units * 18, 36);
        }
        this.m_7787_((GuiEventListener)this.groupList);
        int buttonY = this.guiTop + this.ySize - 20 - 7;
        int buttonSize = 20;
        this.mute = new ToggleImageButton(this.guiLeft + 7, buttonY, MICROPHONE, stateManager::isMuted, button -> stateManager.setMuted(!stateManager.isMuted()), new MuteTooltipSupplier(this, stateManager));
        this.m_142416_((GuiEventListener)this.mute);
        this.disable = new ToggleImageButton(this.guiLeft + 7 + buttonSize + 3, buttonY, SPEAKER, stateManager::isDisabled, button -> stateManager.setDisabled(!stateManager.isDisabled()), new DisableTooltipSupplier(this, stateManager));
        this.m_142416_((GuiEventListener)this.disable);
        this.showHUD = new ToggleImageButton(this.guiLeft + 7 + (buttonSize + 3) * 2, buttonY, GROUP_HUD, VoicechatClient.CLIENT_CONFIG.showGroupHUD::get, button -> VoicechatClient.CLIENT_CONFIG.showGroupHUD.set(VoicechatClient.CLIENT_CONFIG.showGroupHUD.get() == false).save(), new HideGroupHudTooltipSupplier(this));
        this.m_142416_((GuiEventListener)this.showHUD);
        this.leave = new ImageButton(this.guiLeft + this.xSize - buttonSize - 7, buttonY, LEAVE, button -> {
            NetManager.sendToServer(new LeaveGroupPacket());
            this.f_96541_.m_91152_((Screen)new JoinGroupScreen());
        }, (button, matrices, mouseX, mouseY) -> this.m_96617_(matrices, Collections.singletonList(LEAVE_GROUP.m_7532_()), mouseX, mouseY));
        this.m_142416_((GuiEventListener)this.leave);
        this.checkButtons();
    }

    public void m_86600_() {
        super.m_86600_();
        this.checkButtons();
        this.groupList.tick();
    }

    private void checkButtons() {
        this.mute.f_93623_ = VoicechatClient.CLIENT_CONFIG.microphoneActivationType.get().equals((Object)MicrophoneActivationType.VOICE);
        this.showHUD.f_93623_ = VoicechatClient.CLIENT_CONFIG.hideIcons.get() == false;
    }

    @Override
    public void renderBackground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(poseStack, this.guiLeft, this.guiTop, 0, 0, this.xSize, 16);
        for (int i = 0; i < this.units; ++i) {
            this.m_93228_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * i, 0, 16, this.xSize, 18);
        }
        this.m_93228_(poseStack, this.guiLeft, this.guiTop + 16 + 18 * this.units, 0, 34, this.xSize, 32);
        this.m_93228_(poseStack, this.guiLeft + 10, this.guiTop + 16 + 6 - 2, this.xSize, 0, 12, 12);
    }

    @Override
    public void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float delta) {
        MutableComponent title = Component.m_237113_((String)this.group.getName());
        this.f_96547_.m_92889_(poseStack, (Component)title, (float)(this.guiLeft + this.xSize / 2 - this.f_96547_.m_92852_((FormattedText)title) / 2), (float)(this.guiTop + 5), 0x404040);
        this.groupList.m_6305_(poseStack, mouseX, mouseY, delta);
    }
}

