/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.contents;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import tictim.paraglider.contents.ModContainers;
import tictim.paraglider.contents.block.GoddessStatueBlock;
import tictim.paraglider.contents.block.HornedStatueBlock;
import tictim.paraglider.contents.item.AntiVesselItem;
import tictim.paraglider.contents.item.EssenceItem;
import tictim.paraglider.contents.item.HeartContainerItem;
import tictim.paraglider.contents.item.ParagliderItem;
import tictim.paraglider.contents.item.SpiritOrbItem;
import tictim.paraglider.contents.item.StaminaVesselItem;
import tictim.paraglider.contents.loot.ParagliderLoot;
import tictim.paraglider.contents.loot.SpiritOrbLoot;
import tictim.paraglider.contents.loot.VesselLoot;
import tictim.paraglider.contents.recipe.CosmeticRecipe;
import tictim.paraglider.contents.recipe.bargain.SimpleStatueBargain;
import tictim.paraglider.contents.recipe.bargain.StatueBargain;
import tictim.paraglider.contents.recipe.bargain.StatueBargainContainer;
import tictim.paraglider.contents.worldgen.NetherHornedStatue;
import tictim.paraglider.contents.worldgen.TarreyTownGoddessStatue;
import tictim.paraglider.contents.worldgen.UndergroundHornedStatue;

@Mod.EventBusSubscriber(modid="paraglider", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Contents {
    public static final CreativeModeTab GROUP = new CreativeModeTab("paraglider"){

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)PARAGLIDER.get());
        }
    };
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"paraglider");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"paraglider");
    public static final DeferredRegister<MobEffect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"paraglider");
    public static final DeferredRegister<MenuType<?>> MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"paraglider");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> LOOTS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"paraglider");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"paraglider");
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ATTRIBUTES, (String)"paraglider");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"paraglider");
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registry.f_235739_, (String)"paraglider");
    public static final DeferredRegister<StructurePieceType> PIECES = DeferredRegister.create((ResourceKey)Registry.f_122842_, (String)"paraglider");
    public static final RegistryObject<RecipeType<StatueBargain>> STATUE_BARGAIN_RECIPE_TYPE = RECIPE_TYPES.register("statue_bargain", () -> RecipeType.simple((ResourceLocation)new ResourceLocation("paraglider", "statue_bargain")));
    public static final RegistryObject<Block> GODDESS_STATUE = BLOCKS.register("goddess_statue", () -> new GoddessStatueBlock(Contents.statueProperties()));
    public static final RegistryObject<Block> KAKARIKO_GODDESS_STATUE = BLOCKS.register("kakariko_goddess_statue", () -> new GoddessStatueBlock(Contents.statueProperties(), (Component)Component.m_237115_((String)"tooltip.paraglider.kakariko_goddess_statue.0").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY))));
    public static final RegistryObject<Block> GORON_GODDESS_STATUE = BLOCKS.register("goron_goddess_statue", () -> new GoddessStatueBlock(Contents.statueProperties().m_60953_(value -> 15), (Component)Component.m_237115_((String)"tooltip.paraglider.goron_goddess_statue.0").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY))));
    public static final RegistryObject<Block> RITO_GODDESS_STATUE = BLOCKS.register("rito_goddess_statue", () -> new GoddessStatueBlock(Contents.statueProperties(), (Component)Component.m_237115_((String)"tooltip.paraglider.rito_goddess_statue.0").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GRAY))));
    public static final RegistryObject<Block> HORNED_STATUE = BLOCKS.register("horned_statue", () -> new HornedStatueBlock(Contents.statueProperties()));
    public static final RegistryObject<ParagliderItem> PARAGLIDER = ITEMS.register("paraglider", () -> new ParagliderItem(10901845));
    public static final RegistryObject<ParagliderItem> DEKU_LEAF = ITEMS.register("deku_leaf", () -> new ParagliderItem(4175167));
    public static final RegistryObject<Item> HEART_CONTAINER = ITEMS.register("heart_container", HeartContainerItem::new);
    public static final RegistryObject<Item> STAMINA_VESSEL = ITEMS.register("stamina_vessel", StaminaVesselItem::new);
    public static final RegistryObject<Item> SPIRIT_ORB = ITEMS.register("spirit_orb", () -> new SpiritOrbItem(new Item.Properties().m_41497_(Rarity.UNCOMMON).m_41491_(GROUP)));
    public static final RegistryObject<Item> ANTI_VESSEL = ITEMS.register("anti_vessel", () -> new AntiVesselItem(new Item.Properties().m_41497_(Rarity.EPIC).m_41491_(GROUP)));
    public static final RegistryObject<Item> ESSENCE = ITEMS.register("essence", () -> new EssenceItem(new Item.Properties().m_41497_(Rarity.RARE).m_41491_(GROUP)));
    public static final RegistryObject<BlockItem> GODDESS_STATUE_ITEM = ITEMS.register("goddess_statue", () -> new BlockItem((Block)GODDESS_STATUE.get(), new Item.Properties().m_41497_(Rarity.RARE).m_41491_(GROUP)));
    public static final RegistryObject<BlockItem> KAKARIKO_GODDESS_STATUE_ITEM = ITEMS.register("kakariko_goddess_statue", () -> new BlockItem((Block)KAKARIKO_GODDESS_STATUE.get(), new Item.Properties().m_41497_(Rarity.RARE).m_41491_(GROUP)));
    public static final RegistryObject<BlockItem> GORON_GODDESS_STATUE_ITEM = ITEMS.register("goron_goddess_statue", () -> new BlockItem((Block)GORON_GODDESS_STATUE.get(), new Item.Properties().m_41497_(Rarity.RARE).m_41491_(GROUP)));
    public static final RegistryObject<BlockItem> RITO_GODDESS_STATUE_ITEM = ITEMS.register("rito_goddess_statue", () -> new BlockItem((Block)RITO_GODDESS_STATUE.get(), new Item.Properties().m_41497_(Rarity.RARE).m_41491_(GROUP)));
    public static final RegistryObject<BlockItem> HORNED_STATUE_ITEM = ITEMS.register("horned_statue", () -> new BlockItem((Block)HORNED_STATUE.get(), new Item.Properties().m_41497_(Rarity.EPIC).m_41491_(GROUP)));
    public static final RegistryObject<MobEffect> EXHAUSTED = EFFECTS.register("exhausted", () -> new MobEffect(MobEffectCategory.HARMFUL, 5926017){

        public List<ItemStack> getCurativeItems() {
            return new ArrayList<ItemStack>();
        }
    }.m_19472_(Attributes.f_22279_, "65ed2ca4-ceb3-4521-8552-73006dcba58d", -0.3, AttributeModifier.Operation.MULTIPLY_TOTAL));
    public static final RegistryObject<CosmeticRecipe.Serializer> COSMETIC_RECIPE = RECIPE_SERIALIZERS.register("cosmetic", CosmeticRecipe.Serializer::new);
    public static final RegistryObject<SimpleStatueBargain.Serializer> STATUE_BARGAIN_RECIPE = RECIPE_SERIALIZERS.register("statue_bargain", SimpleStatueBargain.Serializer::new);
    public static final RegistryObject<MenuType<StatueBargainContainer>> GODDESS_STATUE_CONTAINER = MENUS.register("goddess_statue", () -> new MenuType(ModContainers::goddessStatue));
    public static final RegistryObject<MenuType<StatueBargainContainer>> HORNED_STATUE_CONTAINER = MENUS.register("horned_statue", () -> new MenuType(ModContainers::hornedStatue));
    public static final RegistryObject<Codec<ParagliderLoot>> PARAGLIDER_LOOT = LOOTS.register("paraglider", () -> ParagliderLoot.CODEC);
    public static final RegistryObject<Codec<SpiritOrbLoot>> SPIRIT_ORB_LOOT = LOOTS.register("spirit_orb", () -> SpiritOrbLoot.CODEC);
    public static final RegistryObject<Codec<VesselLoot>> VESSEL_LOOT = LOOTS.register("vessel", () -> VesselLoot.CODEC);
    public static final RegistryObject<Attribute> MAX_STAMINA = ATTRIBUTES.register("max_stamina", () -> new RangedAttribute("max_stamina", 0.0, 0.0, Double.MAX_VALUE).m_22084_(true));
    public static final RegistryObject<StructureType<UndergroundHornedStatue>> UNDERGROUND_HORNED_STATUE = Contents.structureType("underground_horned_statue", UndergroundHornedStatue.CODEC);
    public static final RegistryObject<StructureType<NetherHornedStatue>> NETHER_HORNED_STATUE = Contents.structureType("nether_horned_statue", NetherHornedStatue.CODEC);
    public static final RegistryObject<StructureType<TarreyTownGoddessStatue>> TARREY_TOWN_GODDESS_STATUE = Contents.structureType("tarrey_town_goddess_statue", TarreyTownGoddessStatue.CODEC);
    public static final RegistryObject<StructurePieceType> TARREY_TOWN_GODDESS_STATUE_PIECE = PIECES.register("tarrey_town_goddess_statue", TarreyTownGoddessStatue::pieceType);
    public static final RegistryObject<StructurePieceType> NETHER_HORNED_STATUE_PIECE = PIECES.register("nether_horned_statue", NetherHornedStatue::pieceType);
    public static final RegistryObject<StructurePieceType> UNDERGROUND_HORNED_STATUE_PIECE = PIECES.register("underground_horned_statue", UndergroundHornedStatue::pieceType);

    private Contents() {
    }

    private static BlockBehaviour.Properties statueProperties() {
        return BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60999_().m_60913_(1.5f, 100.0f).m_60955_();
    }

    private static <T extends Structure> RegistryObject<StructureType<T>> structureType(String id, Codec<T> codec) {
        return STRUCTURE_TYPES.register(id, () -> () -> codec);
    }

    public static void registerEventHandlers(IEventBus eventBus) {
        BLOCKS.register(eventBus);
        ITEMS.register(eventBus);
        EFFECTS.register(eventBus);
        MENUS.register(eventBus);
        LOOTS.register(eventBus);
        RECIPE_SERIALIZERS.register(eventBus);
        ATTRIBUTES.register(eventBus);
        RECIPE_TYPES.register(eventBus);
        STRUCTURE_TYPES.register(eventBus);
        PIECES.register(eventBus);
    }
}

