/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.mixin;

import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.api.EmojiFromGithub;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ChatComponent.class})
public abstract class ChatScreenMixin {
    private static final Pattern DISCORD_EMOJI = Pattern.compile("<:\\w+:[0-9]+>", 2);
    private static final Pattern ANIMATED_DISCORD_EMOJI = Pattern.compile("<a:\\w+:[0-9]+>", 2);

    private static String tryLoadEmoji(String unformattedText) {
        String discordValue;
        Matcher discordMatcher = DISCORD_EMOJI.matcher(unformattedText);
        while (discordMatcher.find()) {
            discordValue = discordMatcher.group(0);
            unformattedText = unformattedText.replaceAll(discordValue, ChatScreenMixin.loadEmoji(discordValue, false));
        }
        discordMatcher = ANIMATED_DISCORD_EMOJI.matcher(unformattedText);
        while (discordMatcher.find()) {
            discordValue = discordMatcher.group(0);
            unformattedText = unformattedText.replaceAll(discordValue, ChatScreenMixin.loadEmoji(discordValue, true));
        }
        return unformattedText;
    }

    private static String loadEmoji(String discordMatcher, boolean isAnimated) {
        String discordEmoji = discordMatcher.replaceAll(isAnimated ? "<a:" : "<:", "").replaceAll(">", "");
        String slug = discordEmoji.split(":")[0];
        String url = discordEmoji.split(":")[1];
        EmojiFromGithub emoji = new EmojiFromGithub();
        emoji.name = slug;
        emoji.strings = new ArrayList();
        emoji.strings.add(":" + slug + ":");
        emoji.location = slug;
        emoji.url = "https://cdn.discordapp.com/emojis/" + url + (isAnimated ? ".gif" : ".png");
        emoji.worldBased = true;
        Constants.EMOJI_MAP.computeIfAbsent("Discord Relay Emojis", s -> new ArrayList()).add(emoji);
        Constants.EMOJI_LIST.add(emoji);
        return ":" + slug + ":";
    }

    @ModifyVariable(method={"addMessage(Lnet/minecraft/network/chat/Component;)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    public Component emojiful_component(Component x) {
        this.emojiful_replaceComponents(x);
        return x;
    }

    private void emojiful_replaceComponents(Component x) {
        ArrayList<Object> components = new ArrayList<Object>();
        for (int i = 0; i < x.m_7360_().size(); ++i) {
            this.emojiful_replaceComponents((Component)x.m_7360_().get(i));
            ComponentContents componentContents = ((Component)x.m_7360_().get(i)).m_214077_();
            if (componentContents instanceof LiteralContents) {
                LiteralContents literalContents = (LiteralContents)componentContents;
                MutableComponent comp = Component.m_237113_((String)ChatScreenMixin.tryLoadEmoji(literalContents.f_237368_())).m_130948_(((Component)x.m_7360_().get(i)).m_7383_());
                components.add(comp);
                continue;
            }
            components.add((Component)x.m_7360_().get(i));
        }
        x.m_7360_().clear();
        x.m_7360_().addAll(components);
    }
}

