/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.gui;

import com.hrznstudio.emojiful.ClientEmojiHandler;
import com.hrznstudio.emojiful.Constants;
import com.hrznstudio.emojiful.api.Emoji;
import com.hrznstudio.emojiful.api.EmojiCategory;
import com.hrznstudio.emojiful.gui.IDrawableGuiListener;
import com.hrznstudio.emojiful.platform.Services;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class EmojiSelectionGui
implements IDrawableGuiListener {
    private final ChatScreen chatScreen;
    private final EditBox fieldWidget;
    private final Rect2i openSelectionArea;
    private final Rect2i selectionArea;
    private final Rect2i categorySelectionArea;
    private final Rect2i emojiInfoArea;
    private final Rect2i textFieldRectangle;
    private int selectionPointer = 1;
    private int categoryPointer = 0;
    private int openSelectionAreaEmoji;
    private boolean showingSelectionArea;
    private double lastMouseX;
    private double lastMouseY;
    private Emoji lastEmoji;
    private List<Emoji[]> filteredEmojis;

    public EmojiSelectionGui(ChatScreen screen) {
        this.chatScreen = screen;
        this.openSelectionAreaEmoji = -1;
        if (Constants.EMOJI_MAP.containsKey("Smileys & Emotion")) {
            this.openSelectionAreaEmoji = new Random().nextInt(Constants.EMOJI_MAP.get("Smileys & Emotion").size());
        }
        this.showingSelectionArea = false;
        int offset = 0;
        if (Services.PLATFORM.isModLoaded("quark")) {
            offset = -80;
        }
        this.openSelectionArea = new Rect2i(this.chatScreen.f_96543_ - 14, this.chatScreen.f_96544_ - 12, 12, 12);
        this.selectionArea = new Rect2i(this.chatScreen.f_96543_ - 14 - 132 + offset, this.chatScreen.f_96544_ - 16 - 110 - 4, 136, 114);
        this.categorySelectionArea = new Rect2i(this.selectionArea.m_110085_(), this.selectionArea.m_110086_() + 20, 22, this.selectionArea.m_110091_() - 20);
        this.emojiInfoArea = new Rect2i(this.selectionArea.m_110085_() + 22, this.selectionArea.m_110086_() + this.selectionArea.m_110091_() - 20, this.selectionArea.m_110090_() - 22, 20);
        this.textFieldRectangle = new Rect2i(this.selectionArea.m_110085_() + 6, this.selectionArea.m_110086_() + 6, this.selectionArea.m_110090_() - 12, 10);
        this.fieldWidget = new EditBox(ClientEmojiHandler.oldFontRenderer, this.textFieldRectangle.m_110085_(), this.textFieldRectangle.m_110086_(), this.textFieldRectangle.m_110090_(), this.textFieldRectangle.m_110091_(), (Component)MutableComponent.m_237204_((ComponentContents)new LiteralContents("")));
        this.fieldWidget.m_94186_(true);
        this.fieldWidget.m_94194_(true);
        this.filteredEmojis = new ArrayList<Emoji[]>();
    }

    @Override
    public void render(PoseStack stack) {
        if (this.openSelectionAreaEmoji != -1) {
            Minecraft.m_91087_().f_91062_.m_92883_(stack, Constants.EMOJI_MAP.get((Object)"Smileys & Emotion").get((int)this.openSelectionAreaEmoji).strings.get(0), (float)this.openSelectionArea.m_110085_(), (float)this.openSelectionArea.m_110086_(), 0);
        }
        if (this.showingSelectionArea) {
            this.drawRectangle(stack, this.selectionArea);
            this.drawRectangle(stack, this.categorySelectionArea);
            this.drawRectangle(stack, this.emojiInfoArea);
            for (int i = 0; i < 6; ++i) {
                this.drawLine(stack, (float)i * 12.0f, i + this.selectionPointer);
            }
            int progressY = (int)((double)(this.emojiInfoArea.m_110086_() - this.categorySelectionArea.m_110086_() - 5) / (double)this.getLineAmount() * (double)this.selectionPointer);
            this.drawRectangle(stack, new Rect2i(this.selectionArea.m_110085_() + this.selectionArea.m_110090_() - 2, this.categorySelectionArea.m_110086_() + progressY, 1, 5), -11382190);
            if (this.lastEmoji != null) {
                Minecraft.m_91087_().f_91062_.m_92883_(stack, this.lastEmoji.strings.get(0), (float)(this.emojiInfoArea.m_110085_() + 2), (float)(this.emojiInfoArea.m_110086_() + 6), 0);
                StringBuilder builder = new StringBuilder();
                this.lastEmoji.strings.forEach(s -> builder.append((String)s).append(" "));
                float textScale = 0.5f;
                List iTextPropertiesList = ClientEmojiHandler.oldFontRenderer.m_92923_(FormattedText.m_130775_((String)builder.toString()), (int)((float)(this.emojiInfoArea.m_110090_() - 18) * (1.0f / textScale)));
                float i = -iTextPropertiesList.size() / 2;
                stack.m_85836_();
                stack.m_85841_(textScale, textScale, textScale);
                for (FormattedCharSequence reorderingProcessor : iTextPropertiesList) {
                    StringBuilder stringBuilder = new StringBuilder();
                    reorderingProcessor.m_13731_((p_accept_1_, p_accept_2_, ch) -> {
                        stringBuilder.append((char)ch);
                        return true;
                    });
                    ClientEmojiHandler.oldFontRenderer.m_92883_(stack, stringBuilder.toString(), (float)(this.emojiInfoArea.m_110085_() + 15) * (1.0f / textScale), ((float)(this.emojiInfoArea.m_110086_() + 8) + 4.0f * i) * (1.0f / textScale), 0x969696);
                    i += 1.0f;
                }
                stack.m_85841_(1.0f, 1.0f, 1.0f);
                stack.m_85849_();
            }
            progressY = (int)((double)(this.categorySelectionArea.m_110091_() - 10) / ((double)ClientEmojiHandler.CATEGORIES.size() - 7.0) * (double)this.categoryPointer);
            this.drawRectangle(stack, new Rect2i(this.categorySelectionArea.m_110085_() + this.categorySelectionArea.m_110090_() - 2, this.categorySelectionArea.m_110086_() + progressY + 2, 1, 5), -11382190);
            EmojiCategory firstCategory = this.getCategory(this.selectionPointer);
            for (int i = 0; i < 7; ++i) {
                int selCategory = i + this.categoryPointer;
                if (selCategory >= ClientEmojiHandler.CATEGORIES.size()) continue;
                EmojiCategory category = ClientEmojiHandler.CATEGORIES.get(selCategory);
                Rect2i rec = new Rect2i(this.categorySelectionArea.m_110085_() + 6, this.categorySelectionArea.m_110086_() + 6 + i * 12, 11, 11);
                if (category.equals(firstCategory)) {
                    GuiComponent.m_93172_((PoseStack)stack, (int)(rec.m_110085_() - 1), (int)(rec.m_110086_() - 2), (int)(rec.m_110085_() + rec.m_110090_()), (int)(rec.m_110086_() + rec.m_110091_() - 1), (int)-2130706433);
                }
                if (rec.m_110087_((int)this.lastMouseX, (int)this.lastMouseY) && Minecraft.m_91087_().f_91080_ != null) {
                    Minecraft.m_91087_().f_91080_.m_96597_(stack, Arrays.asList(MutableComponent.m_237204_((ComponentContents)new LiteralContents(category.name()))), (int)this.lastMouseX, (int)this.lastMouseY);
                }
                if (!ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.containsKey(category) || ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get(category).size() <= 0) continue;
                Minecraft.m_91087_().f_91062_.m_92883_(stack, ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get((Object)category).get((int)0)[0].strings.get(0), (float)(this.categorySelectionArea.m_110085_() + 6), (float)(this.categorySelectionArea.m_110086_() + 6 + i * 12), 0);
            }
            this.fieldWidget.m_6305_(stack, (int)this.lastMouseX, (int)this.lastMouseY, 0.0f);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int p_231044_5_) {
        if (this.openSelectionArea.m_110087_((int)mouseX, (int)mouseY)) {
            this.toggleSelectionArea();
            return true;
        }
        if (this.showingSelectionArea) {
            this.fieldWidget.m_94178_(this.textFieldRectangle.m_110087_((int)mouseX, (int)mouseY));
            if (this.categorySelectionArea.m_110087_((int)mouseX, (int)mouseY)) {
                for (int i = 0; i < 7; ++i) {
                    Rect2i rec;
                    int selCategory = i + this.categoryPointer;
                    if (selCategory >= ClientEmojiHandler.CATEGORIES.size() || !(rec = new Rect2i(this.categorySelectionArea.m_110085_() + 6, this.categorySelectionArea.m_110086_() + 6 + i * 12, 11, 11)).m_110087_((int)mouseX, (int)mouseY)) continue;
                    EmojiCategory name = ClientEmojiHandler.CATEGORIES.get(selCategory);
                    for (int i1 = 0; i1 < this.getLineAmount(); ++i1) {
                        if (!name.equals(this.getLineToDraw(i1))) continue;
                        this.selectionPointer = i1;
                    }
                }
                return true;
            }
            if (this.selectionArea.m_110087_((int)mouseX, (int)mouseY)) {
                for (int line = 0; line < 6; ++line) {
                    Object object = this.getLineToDraw(line + this.selectionPointer);
                    if (!(object instanceof Emoji[])) continue;
                    Emoji[] emojis = (Emoji[])object;
                    for (int i = 0; i < emojis.length; ++i) {
                        float y;
                        float x;
                        Rect2i rec;
                        if (emojis[i] == null || !(rec = new Rect2i((int)(x = (float)(this.categorySelectionArea.m_110085_() + this.categorySelectionArea.m_110090_() + 2) + 12.0f * (float)i), (int)(y = (float)(this.categorySelectionArea.m_110086_() + line * 12 + 2)) - 1, 11, 11)).m_110087_((int)this.lastMouseX, (int)this.lastMouseY)) continue;
                        this.chatScreen.f_95573_.m_94144_(this.chatScreen.f_95573_.m_94155_() + emojis[i].getShorterString());
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void m_94757_(double mouseX, double mouseY) {
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.categorySelectionArea.m_110087_((int)mouseX, (int)mouseY)) {
            this.categoryPointer = (int)((double)this.categoryPointer - delta);
            this.categoryPointer = Mth.m_14045_((int)this.categoryPointer, (int)0, (int)(ClientEmojiHandler.CATEGORIES.size() - 7));
            return true;
        }
        if (this.selectionArea.m_110087_((int)mouseX, (int)mouseY)) {
            this.selectionPointer = (int)((double)this.selectionPointer - delta);
            this.selectionPointer = Mth.m_14045_((int)this.selectionPointer, (int)1, (int)Math.max(1, this.getLineAmount() - 5));
            this.categoryPointer = Mth.m_14045_((int)Arrays.asList(ClientEmojiHandler.CATEGORIES).indexOf(this.getCategory(this.selectionPointer)), (int)0, (int)(ClientEmojiHandler.CATEGORIES.size() - 7));
            return true;
        }
        return false;
    }

    public void drawRectangle(PoseStack stack, Rect2i rectangle2d) {
        this.drawRectangle(stack, rectangle2d, Integer.MIN_VALUE);
    }

    public void drawRectangle(PoseStack stack, Rect2i rectangle2d, int value) {
        GuiComponent.m_93172_((PoseStack)stack, (int)rectangle2d.m_110085_(), (int)rectangle2d.m_110086_(), (int)(rectangle2d.m_110085_() + rectangle2d.m_110090_()), (int)(rectangle2d.m_110086_() + rectangle2d.m_110091_()), (int)value);
    }

    public void toggleSelectionArea() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12490_, (float)1.0f));
        this.showingSelectionArea = !this.showingSelectionArea;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.fieldWidget.m_7933_(keyCode, scanCode, modifiers)) {
            this.updateFilter();
            return true;
        }
        return false;
    }

    public boolean m_5534_(char c, int mod) {
        if (this.fieldWidget.m_5534_(c, mod)) {
            this.updateFilter();
            return true;
        }
        return false;
    }

    public void drawLine(PoseStack stack, float height, int line) {
        Object lineToDraw = this.getLineToDraw(line);
        if (lineToDraw != null) {
            if (lineToDraw instanceof EmojiCategory) {
                float textScale = 1.0f;
                stack.m_85841_(textScale, textScale, textScale);
                Minecraft.m_91087_().f_91062_.m_92883_(stack, ((EmojiCategory)lineToDraw).name(), (float)(this.categorySelectionArea.m_110085_() + this.categorySelectionArea.m_110090_() + 2) * (1.0f / textScale), ((float)this.categorySelectionArea.m_110086_() + height + 2.0f) * (1.0f / textScale), 0x969696);
                stack.m_85841_(1.0f, 1.0f, 1.0f);
            } else {
                Emoji[] emojis = (Emoji[])lineToDraw;
                for (int i = 0; i < emojis.length; ++i) {
                    float y;
                    if (emojis[i] == null) continue;
                    float x = (float)(this.categorySelectionArea.m_110085_() + this.categorySelectionArea.m_110090_() + 2) + 12.0f * (float)i;
                    Rect2i rec = new Rect2i((int)x, (int)(y = (float)this.categorySelectionArea.m_110086_() + height + 2.0f) - 1, 11, 11);
                    if (rec.m_110087_((int)this.lastMouseX, (int)this.lastMouseY)) {
                        this.lastEmoji = emojis[i];
                        GuiComponent.m_93172_((PoseStack)stack, (int)(rec.m_110085_() - 1), (int)(rec.m_110086_() - 1), (int)(rec.m_110085_() + rec.m_110090_()), (int)(rec.m_110086_() + rec.m_110091_()), (int)-2130706433);
                    }
                    Minecraft.m_91087_().f_91062_.m_92883_(stack, emojis[i].strings.get(0), x, y, 0x969696);
                }
            }
        }
    }

    public Object getLineToDraw(int line) {
        if (this.fieldWidget.m_94155_().isEmpty()) {
            for (EmojiCategory category : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.keySet()) {
                if (--line == 0) {
                    return category;
                }
                for (Emoji[] emojis : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get(category)) {
                    if (--line != 0) continue;
                    return emojis;
                }
            }
        } else if (this.filteredEmojis.size() > line - 1 && line - 1 >= 0) {
            return this.filteredEmojis.get(line - 1);
        }
        return null;
    }

    public void updateFilter() {
        if (!this.fieldWidget.m_94155_().isEmpty()) {
            this.selectionPointer = 1;
            this.filteredEmojis = new ArrayList<Emoji[]>();
            List emojis = Constants.EMOJI_LIST.stream().filter(emoji -> emoji.strings.stream().anyMatch(s -> s.toLowerCase().contains(this.fieldWidget.m_94155_().toLowerCase()))).collect(Collectors.toList());
            Emoji[] array = new Emoji[9];
            int i = 0;
            Iterator iterator = emojis.iterator();
            while (iterator.hasNext()) {
                Emoji emoji2;
                array[i] = emoji2 = (Emoji)iterator.next();
                if (++i < array.length) continue;
                this.filteredEmojis.add(array);
                array = new Emoji[9];
                i = 0;
            }
            if (i > 0) {
                this.filteredEmojis.add(array);
            }
        }
    }

    public int getLineAmount() {
        return this.fieldWidget.m_94155_().isEmpty() ? ClientEmojiHandler.lineAmount : this.filteredEmojis.size();
    }

    public EmojiCategory getCategory(int line) {
        for (EmojiCategory category : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.keySet()) {
            if (--line == 0) {
                return category;
            }
            for (Emoji[] emojis : ClientEmojiHandler.SORTED_EMOJIS_FOR_SELECTION.get(category)) {
                if (--line != 0) continue;
                return category;
            }
        }
        return null;
    }

    public ChatScreen getChatScreen() {
        return this.chatScreen;
    }

    public EditBox getFieldWidget() {
        return this.fieldWidget;
    }
}

