/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.SkullRendererCache;
import java.util.Map;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockEntityWithoutLevelRenderer.class})
public class BlockEntityWithoutLevelRendererMixin {
    @Shadow
    private Map<SkullBlock.Type, SkullModelBase> f_172546_;

    @Inject(method={"renderByItem"}, at={@At(value="HEAD")})
    public void renderByItem(ItemStack itemStack, ItemTransforms.TransformType transformType, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j, CallbackInfo info) {
        Block block;
        if (!SkinLayersModBase.config.enableSkullsItems) {
            return;
        }
        Item item = itemStack.m_41720_();
        if (item instanceof BlockItem && (block = ((BlockItem)item).m_40614_()) instanceof AbstractSkullBlock) {
            GameProfile gameProfile = null;
            if (itemStack.m_41782_()) {
                CompoundTag compoundTag = itemStack.m_41783_();
                if (compoundTag.m_128441_("CustomModelData")) {
                    return;
                }
                if (compoundTag.m_128425_("SkullOwner", 10)) {
                    gameProfile = NbtUtils.m_129228_((CompoundTag)compoundTag.m_128469_("SkullOwner"));
                } else if (compoundTag.m_128425_("SkullOwner", 8) && !StringUtils.isBlank((CharSequence)compoundTag.m_128461_("SkullOwner"))) {
                    gameProfile = new GameProfile(null, compoundTag.m_128461_("SkullOwner"));
                    compoundTag.m_128473_("SkullOwner");
                    SkullBlockEntity.m_155738_((GameProfile)gameProfile, gp -> compoundTag.m_128365_("SkullOwner", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)gp)));
                }
            }
            if (gameProfile != null) {
                SkullRendererCache.lastSkull = SkullRendererCache.itemCache.computeIfAbsent(itemStack, it -> new SkullRendererCache.ItemSettings());
                if (SkullRendererCache.lastSkull.getHeadLayers() == null) {
                    SkinUtil.setup3dLayers(gameProfile, SkullRendererCache.lastSkull);
                }
                SkullRendererCache.renderNext = SkullRendererCache.lastSkull.getHeadLayers() != null;
            }
        }
    }
}

