/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public abstract class Widget {
    private static final Consumer<String> NARRATOR;
    public int x;
    public int y;
    public int width;
    public int height;
    public boolean active = true;
    public boolean hovered = false;
    public boolean wasHovered = false;
    protected long nextNarration = Long.MAX_VALUE;
    public float blitOffset = 0.0f;

    public Widget(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void narrate() {
        if (this.wasHovered != this.hovered) {
            long l = this.nextNarration = this.hovered ? Util.m_137550_() + 750L : Long.MAX_VALUE;
        }
        if (this.active && this.hovered && Util.m_137550_() > this.nextNarration) {
            String s;
            Component message = this.getNarrationMessage();
            String string = s = message == null ? "" : message.getString();
            if (!s.isEmpty()) {
                NARRATOR.accept(s);
                this.nextNarration = Long.MAX_VALUE;
            }
        }
    }

    protected abstract Component getNarrationMessage();

    public void setActive(boolean active) {
        this.active = active;
    }

    public abstract void render(PoseStack var1, int var2, int var3, float var4);

    public boolean isHovered() {
        return this.hovered;
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
    }

    public void mouseReleased(int mouseX, int mouseY, int button) {
    }

    public void mouseScrolled(int mouseX, int mouseY, double scroll) {
    }

    public void keyPressed(int keyCode) {
    }

    public void keyReleased(int keyCode) {
    }

    public void charTyped(char c) {
    }

    static {
        Consumer<String> narrator;
        try {
            Class<?> clazz = Class.forName("net.minecraft.client.gui.chat.NarratorChatListener");
            Field instanceField = ObfuscationReflectionHelper.findField(clazz, (String)"f_93311_");
            Object instance = instanceField.get(null);
            Method sayNowMethod = ObfuscationReflectionHelper.findMethod(clazz, (String)"m_93319_", (Class[])new Class[]{String.class});
            narrator = s -> {
                try {
                    sayNowMethod.invoke(instance, s);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
        }
        catch (Exception ignore) {
            narrator = arg_0 -> ((GameNarrator)ClientUtils.getMinecraft().m_240477_()).m_93319_(arg_0);
        }
        NARRATOR = narrator;
    }
}

