/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.ScreenUtils;
import com.supermartijn642.core.gui.widget.IHoverTextWidget;
import com.supermartijn642.core.gui.widget.ITickableWidget;
import com.supermartijn642.core.gui.widget.TextFieldWidget;
import com.supermartijn642.core.gui.widget.Widget;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class BaseScreen
extends Screen {
    private final List<Widget> widgets = new LinkedList<Widget>();
    private final List<ITickableWidget> tickableWidgets = new LinkedList<ITickableWidget>();

    protected BaseScreen(Component title) {
        super(title);
    }

    protected abstract float sizeX();

    protected abstract float sizeY();

    protected float left() {
        return ((float)this.f_96543_ - this.sizeX()) / 2.0f;
    }

    protected float top() {
        return ((float)this.f_96544_ - this.sizeY()) / 2.0f;
    }

    protected void m_7856_() {
        this.widgets.clear();
        this.tickableWidgets.clear();
        this.addWidgets();
    }

    protected abstract void addWidgets();

    protected <T extends Widget> T addWidget(T widget) {
        this.widgets.add(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.add((ITickableWidget)((Object)widget));
        }
        return widget;
    }

    protected <T extends Widget> T removeWidget(T widget) {
        this.widgets.remove(widget);
        if (widget instanceof ITickableWidget) {
            this.tickableWidgets.remove(widget);
        }
        return widget;
    }

    public void m_86600_() {
        this.tickableWidgets.forEach(ITickableWidget::tick);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(poseStack);
        poseStack.m_85836_();
        poseStack.m_85837_((double)this.left(), (double)this.top(), 0.0);
        mouseX = (int)((float)mouseX - this.left());
        mouseY = (int)((float)mouseY - this.top());
        this.renderBackground(poseStack, mouseX, mouseY);
        this.render(poseStack, mouseX, mouseY);
        for (Widget widget : this.widgets) {
            widget.blitOffset = this.m_93252_();
            widget.wasHovered = widget.hovered;
            widget.hovered = mouseX > widget.x && mouseX < widget.x + widget.width && mouseY > widget.y && mouseY < widget.y + widget.height;
            widget.render(poseStack, mouseX, mouseY, partialTicks);
            widget.narrate();
        }
        this.renderForeground(poseStack, mouseX, mouseY);
        for (Widget widget : this.widgets) {
            Component text;
            if (!(widget instanceof IHoverTextWidget) || !widget.isHovered() || (text = ((IHoverTextWidget)((Object)widget)).getHoverText()) == null) continue;
            this.m_96602_(poseStack, text, mouseX, mouseY);
        }
        this.renderTooltips(poseStack, mouseX, mouseY);
        poseStack.m_85849_();
    }

    protected void renderBackground(PoseStack poseStack, int mouseX, int mouseY) {
    }

    protected void render(PoseStack poseStack, int mouseX, int mouseY) {
    }

    protected void renderForeground(PoseStack poseStack, int mouseX, int mouseY) {
    }

    protected void renderTooltips(PoseStack poseStack, int mouseX, int mouseY) {
    }

    protected void drawScreenBackground(PoseStack poseStack, float x, float y, float width, float height) {
        ScreenUtils.drawScreenBackground(poseStack, x, y, width, height);
    }

    protected void drawScreenBackground(PoseStack poseStack) {
        ScreenUtils.drawScreenBackground(poseStack, 0.0f, 0.0f, this.sizeX(), this.sizeY());
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.onMousePress((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseClicked((int)mouseX, (int)mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void onMousePress(int mouseX, int mouseY, int button) {
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.onMouseRelease((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), button);
        for (Widget widget : this.widgets) {
            widget.mouseReleased((int)mouseX, (int)mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected void onMouseRelease(int mouseX, int mouseY, int button) {
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        this.onMouseScroll((int)(mouseX -= (double)this.left()), (int)(mouseY -= (double)this.top()), delta);
        for (Widget widget : this.widgets) {
            widget.mouseScrolled((int)mouseX, (int)mouseY, delta);
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    protected void onMouseScroll(int mouseX, int mouseY, double scroll) {
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.keyPressed(keyCode)) {
            return true;
        }
        InputConstants.Key key = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (ClientUtils.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(key)) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean keyPressed(int keyCode) {
        boolean handled = false;
        for (Widget widget : this.widgets) {
            if (widget instanceof TextFieldWidget && ((TextFieldWidget)widget).canWrite()) {
                handled = true;
            }
            widget.keyPressed(keyCode);
        }
        return handled;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.keyReleased(keyCode);
    }

    public boolean keyReleased(int keyCode) {
        for (Widget widget : this.widgets) {
            widget.keyReleased(keyCode);
        }
        return false;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.charTyped(codePoint);
    }

    public boolean charTyped(char c) {
        for (Widget widget : this.widgets) {
            widget.charTyped(c);
        }
        return false;
    }
}

