/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.network;

import fuzs.puzzleslib.network.Message;
import fuzs.puzzleslib.network.MessageDirection;
import fuzs.puzzleslib.proxy.Proxy;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface NetworkHandler {
    public <T extends Message<T>> void register(Class<? extends T> var1, Supplier<T> var2, MessageDirection var3);

    public Packet<?> toServerboundPacket(Message<?> var1);

    public Packet<?> toClientboundPacket(Message<?> var1);

    default public void sendToServer(Message<?> message) {
        Proxy.INSTANCE.getClientConnection().m_129512_(this.toServerboundPacket(message));
    }

    default public void sendTo(Message<?> message, ServerPlayer player) {
        player.f_8906_.m_9829_(this.toClientboundPacket(message));
    }

    default public void sendToAll(Message<?> message) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11268_(this.toClientboundPacket(message));
    }

    default public void sendToAllExcept(Message<?> message, ServerPlayer exclude) {
        for (ServerPlayer player : Proxy.INSTANCE.getGameServer().m_6846_().m_11314_()) {
            if (player == exclude) continue;
            this.sendTo(message, player);
        }
    }

    default public void sendToAllNear(Message<?> message, BlockPos pos, Level level) {
        this.sendToAllNearExcept(message, null, pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), 64.0, level);
    }

    default public void sendToAllNearExcept(Message<?> message, @Nullable ServerPlayer exclude, double posX, double posY, double posZ, double distance, Level level) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11241_((Player)exclude, posX, posY, posZ, distance, level.m_46472_(), this.toClientboundPacket(message));
    }

    default public void sendToAllTracking(Message<?> message, Entity entity) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8445_(entity, this.toClientboundPacket(message));
    }

    default public void sendToAllTrackingAndSelf(Message<?> message, Entity entity) {
        ((ServerChunkCache)entity.m_20193_().m_7726_()).m_8394_(entity, this.toClientboundPacket(message));
    }

    default public void sendToDimension(Message<?> message, Level level) {
        this.sendToDimension(message, (ResourceKey<Level>)level.m_46472_());
    }

    default public void sendToDimension(Message<?> message, ResourceKey<Level> dimension) {
        Proxy.INSTANCE.getGameServer().m_6846_().m_11270_(this.toClientboundPacket(message), dimension);
    }
}

