/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import fuzs.puzzleslib.config.ConfigCore;
import fuzs.puzzleslib.config.ConfigDataHolder;
import fuzs.puzzleslib.config.ConfigHolder;
import fuzs.puzzleslib.config.ForgeConfigDataHolderImpl;
import fuzs.puzzleslib.core.DistType;
import fuzs.puzzleslib.core.DistTypeExecutor;
import fuzs.puzzleslib.util.PuzzlesUtilForge;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public class ForgeConfigHolderImpl
implements ConfigHolder.Builder {
    private Map<Class<? extends ConfigCore>, ForgeConfigDataHolderImpl<? extends ConfigCore>> configsByClass = Maps.newIdentityHashMap();

    @Override
    public <T extends ConfigCore> ConfigDataHolder<T> getHolder(Class<T> clazz) {
        ForgeConfigDataHolderImpl<? extends ConfigCore> holder = this.configsByClass.get(clazz);
        Objects.requireNonNull(holder, String.format("No config holder available for type %s", clazz));
        return holder;
    }

    @Override
    public <T extends ConfigCore> ConfigHolder.Builder clientConfig(Class<T> clazz, Supplier<T> clientConfig) {
        Supplier<ConfigCore> config = () -> (ConfigCore)DistTypeExecutor.getWhenOn(DistType.CLIENT, () -> ForgeConfigHolderImpl.lambda$clientConfig$0((Supplier)clientConfig));
        if (this.configsByClass.put(clazz, new ForgeConfigDataHolderImpl<ConfigCore>(ModConfig.Type.CLIENT, config)) != null) {
            throw new IllegalStateException(String.format("Duplicate registration for client config of type %s", clazz));
        }
        return this;
    }

    @Override
    public <T extends ConfigCore> ConfigHolder.Builder commonConfig(Class<T> clazz, Supplier<T> commonConfig) {
        if (this.configsByClass.put(clazz, new ForgeConfigDataHolderImpl<T>(ModConfig.Type.COMMON, commonConfig)) != null) {
            throw new IllegalStateException(String.format("Duplicate registration for common config of type %s", clazz));
        }
        return this;
    }

    @Override
    public <T extends ConfigCore> ConfigHolder.Builder serverConfig(Class<T> clazz, Supplier<T> serverConfig) {
        if (this.configsByClass.put(clazz, new ForgeConfigDataHolderImpl<T>(ModConfig.Type.SERVER, serverConfig)) != null) {
            throw new IllegalStateException(String.format("Duplicate registration for server config of type %s", clazz));
        }
        return this;
    }

    @Override
    public <T extends ConfigCore> ConfigHolder.Builder setFileName(Class<T> clazz, UnaryOperator<String> fileName) {
        ForgeConfigDataHolderImpl holder = (ForgeConfigDataHolderImpl)this.getHolder(clazz);
        holder.setFileName(fileName);
        return this;
    }

    @Override
    public void bakeConfigs(String modId) {
        this.configsByClass = ImmutableMap.copyOf(this.configsByClass);
        IEventBus modBus = PuzzlesUtilForge.findModEventBus(modId);
        for (ForgeConfigDataHolderImpl<? extends ConfigCore> holder : this.configsByClass.values()) {
            if (holder.config == null) continue;
            modBus.addListener(evt -> {
                if (evt.getConfig().getModId().equals(modId)) {
                    holder.onModConfig(evt.getConfig(), false);
                }
            });
            modBus.addListener(evt -> {
                if (evt.getConfig().getModId().equals(modId)) {
                    holder.onModConfig(evt.getConfig(), true);
                }
            });
            holder.register((type, spec, fileName) -> {
                ModContainer modContainer = PuzzlesUtilForge.findModContainer(modId);
                ModConfig modConfig = new ModConfig(type, (IConfigSpec)spec, modContainer, (String)fileName.apply(modId));
                modContainer.addConfig(modConfig);
                return modConfig;
            });
        }
    }

    private static /* synthetic */ Supplier lambda$clientConfig$0(Supplier clientConfig) {
        return clientConfig;
    }
}

