/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.client.core;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.puzzleslib.client.core.ClientModConstructor;
import fuzs.puzzleslib.client.extension.WrappedClientItemExtension;
import fuzs.puzzleslib.client.init.builder.ModScreenConstructor;
import fuzs.puzzleslib.client.init.builder.ModSpriteParticleRegistration;
import fuzs.puzzleslib.client.renderer.entity.DynamicItemDecorator;
import fuzs.puzzleslib.client.resources.model.DynamicModelBakingContext;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.mixin.client.accessor.ItemAccessor;
import fuzs.puzzleslib.util.PuzzlesUtilForge;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.renderer.texture.AtlasSet;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.client.searchtree.SearchRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RegisterItemDecorationsEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.logging.log4j.util.Strings;

public class ForgeClientModConstructor {
    private final String modId;
    private final ClientModConstructor constructor;
    private final List<Consumer<DynamicModelBakingContext>> modelBakingListeners = Lists.newArrayList();

    private ForgeClientModConstructor(String modId, ClientModConstructor constructor) {
        this.modId = modId;
        this.constructor = constructor;
        constructor.onConstructMod();
    }

    @SubscribeEvent
    public void onClientSetup(FMLClientSetupEvent evt) {
        this.constructor.onClientSetup();
        this.constructor.onRegisterMenuScreens(this.getMenuScreensContext());
        this.constructor.onRegisterSearchTrees(this.getSearchRegistryContext());
        this.constructor.onRegisterModelBakingCompletedListeners(this.modelBakingListeners::add);
        this.constructor.onRegisterItemModelProperties(this.getItemPropertiesContext());
        this.constructor.onRegisterBuiltinModelItemRenderers(this.getBuiltinModelItemRendererContext());
    }

    private ClientModConstructor.MenuScreensContext getMenuScreensContext() {
        return new ClientModConstructor.MenuScreensContext(){

            @Override
            public <M extends AbstractContainerMenu, U extends Screen> void registerMenuScreen(MenuType<? extends M> menuType, ModScreenConstructor<M, U> factory) {
                Objects.requireNonNull(menuType, "menu type is null");
                Objects.requireNonNull(factory, "screen constructor is null");
                MenuScreens.m_96206_(menuType, factory::create);
            }
        };
    }

    private ClientModConstructor.SearchRegistryContext getSearchRegistryContext() {
        return new ClientModConstructor.SearchRegistryContext(){

            @Override
            public <T> void registerSearchTree(SearchRegistry.Key<T> searchRegistryKey, SearchRegistry.TreeBuilderSupplier<T> treeBuilder) {
                Objects.requireNonNull(searchRegistryKey, "search registry key is null");
                Objects.requireNonNull(treeBuilder, "search registry tree builder is null");
                SearchRegistry searchTreeManager = Minecraft.m_91087_().getSearchTreeManager();
                Objects.requireNonNull(searchTreeManager, "search tree manager is null");
                searchTreeManager.m_235232_(searchRegistryKey, treeBuilder);
            }
        };
    }

    private ClientModConstructor.ItemModelPropertiesContext getItemPropertiesContext() {
        return new ClientModConstructor.ItemModelPropertiesContext(){

            @Override
            public void register(ResourceLocation name, ClampedItemPropertyFunction function) {
                Objects.requireNonNull(name, "property name is null");
                Objects.requireNonNull(function, "property function is null");
                ItemProperties.registerGeneric((ResourceLocation)name, (ItemPropertyFunction)function);
            }

            @Override
            public void registerItem(Item item, ResourceLocation name, ClampedItemPropertyFunction function) {
                Objects.requireNonNull(item, "item is null");
                Objects.requireNonNull(name, "property name is null");
                Objects.requireNonNull(function, "property function is null");
                ItemProperties.register((Item)item, (ResourceLocation)name, (ItemPropertyFunction)function);
            }
        };
    }

    private ClientModConstructor.BuiltinModelItemRendererContext getBuiltinModelItemRendererContext() {
        return (item, renderer) -> {
            Objects.requireNonNull(item, "item is null");
            Objects.requireNonNull(renderer, "renderer is null");
            if (FMLLoader.getLaunchHandler().isData()) {
                return;
            }
            final IClientItemExtensions clientItemExtension = new IClientItemExtensions(){

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    Minecraft minecraft = Minecraft.m_91087_();
                    return new BlockEntityWithoutLevelRenderer(minecraft.m_167982_(), minecraft.m_167973_()){

                        public void m_108829_(ItemStack stack, ItemTransforms.TransformType mode, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
                            renderer.renderByItem(stack, mode, matrices, vertexConsumers, light, overlay);
                        }

                        public void m_6213_(ResourceManager resourceManager) {
                        }
                    };
                }
            };
            Object currentClientItemExtension = ((ItemAccessor)item.m_5456_()).getRenderProperties();
            ((ItemAccessor)item.m_5456_()).setRenderProperties(currentClientItemExtension != null ? new WrappedClientItemExtension((IClientItemExtensions)currentClientItemExtension){

                @Override
                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return clientItemExtension.getCustomRenderer();
                }
            } : clientItemExtension);
        };
    }

    @SubscribeEvent
    public void onRegisterRenderers(final EntityRenderersEvent.RegisterRenderers evt) {
        this.constructor.onRegisterEntityRenderers(new ClientModConstructor.EntityRenderersContext(){

            @Override
            public <T extends Entity> void registerEntityRenderer(EntityType<? extends T> entityType, EntityRendererProvider<T> entityRendererProvider) {
                Objects.requireNonNull(entityType, "entity type is null");
                Objects.requireNonNull(entityRendererProvider, "entity renderer provider is null");
                evt.registerEntityRenderer(entityType, entityRendererProvider);
            }
        });
        this.constructor.onRegisterBlockEntityRenderers(new ClientModConstructor.BlockEntityRenderersContext(){

            @Override
            public <T extends BlockEntity> void registerBlockEntityRenderer(BlockEntityType<? extends T> blockEntityType, BlockEntityRendererProvider<T> blockEntityRendererProvider) {
                Objects.requireNonNull(blockEntityType, "block entity type is null");
                Objects.requireNonNull(blockEntityRendererProvider, "block entity renderer provider is null");
                evt.registerBlockEntityRenderer(blockEntityType, blockEntityRendererProvider);
            }
        });
    }

    @SubscribeEvent
    public void onRegisterClientTooltipComponentFactories(final RegisterClientTooltipComponentFactoriesEvent evt) {
        this.constructor.onRegisterClientTooltipComponents(new ClientModConstructor.ClientTooltipComponentsContext(){

            @Override
            public <T extends TooltipComponent> void registerClientTooltipComponent(Class<T> type, Function<? super T, ? extends ClientTooltipComponent> factory) {
                Objects.requireNonNull(type, "tooltip component type is null");
                Objects.requireNonNull(factory, "tooltip component factory is null");
                evt.register(type, factory);
            }
        });
    }

    @SubscribeEvent
    public void onRegisterParticleProviders(final RegisterParticleProvidersEvent evt) {
        this.constructor.onRegisterParticleProviders(new ClientModConstructor.ParticleProvidersContext(){

            @Override
            public <T extends ParticleOptions> void registerParticleProvider(ParticleType<T> type, ParticleProvider<T> provider) {
                Objects.requireNonNull(type, "particle type is null");
                Objects.requireNonNull(provider, "particle provider is null");
                evt.register(type, provider);
            }

            @Override
            public <T extends ParticleOptions> void registerParticleFactory(ParticleType<T> type, ModSpriteParticleRegistration<T> factory) {
                Objects.requireNonNull(type, "particle type is null");
                Objects.requireNonNull(factory, "particle provider factory is null");
                evt.register(type, factory::create);
            }
        });
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre evt) {
        this.constructor.onRegisterAtlasSprites((atlasId, spriteId) -> {
            Objects.requireNonNull(atlasId, "atlas id is null");
            Objects.requireNonNull(spriteId, "sprite id is null");
            if (evt.getAtlas().m_118330_().equals((Object)atlasId)) {
                evt.addSprite(spriteId);
            }
        });
    }

    @SubscribeEvent
    public void onRegisterLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions evt) {
        this.constructor.onRegisterLayerDefinitions((ModelLayerLocation layerLocation, Supplier<LayerDefinition> supplier) -> {
            Objects.requireNonNull(layerLocation, "layer location is null");
            Objects.requireNonNull(supplier, "layer supplier is null");
            evt.registerLayerDefinition(layerLocation, supplier);
        });
    }

    @SubscribeEvent
    public void onBakingCompleted(ModelEvent.BakingCompleted evt) {
        DynamicModelBakingContext context = new DynamicModelBakingContext(evt.getModelManager(), evt.getModels(), evt.getModelBakery()){

            @Override
            public BakedModel bakeModel(ResourceLocation model) {
                Objects.requireNonNull(model, "model location is null");
                UnbakedModel unbakedModel = this.modelBakery.m_119341_(model);
                return unbakedModel.m_7611_(this.modelBakery, arg_0 -> ((AtlasSet)this.modelBakery.getAtlasSet()).m_117971_(arg_0), (ModelState)BlockModelRotation.X0_Y0, model);
            }
        };
        for (Consumer<DynamicModelBakingContext> listener : this.modelBakingListeners) {
            try {
                listener.accept(context);
            }
            catch (Exception e) {
                PuzzlesLib.LOGGER.error("Unable to execute additional resource pack model processing provided by {}", (Object)this.modId, (Object)e);
            }
        }
    }

    @SubscribeEvent
    public void onRegisterAdditional(ModelEvent.RegisterAdditional evt) {
        this.constructor.onRegisterAdditionalModels(model -> {
            Objects.requireNonNull(model, "additional model is null");
            evt.register(model);
        });
    }

    @SubscribeEvent
    public void onRegisterItemDecorations(RegisterItemDecorationsEvent evt) {
        this.constructor.onRegisterItemDecorations((ItemLike item, DynamicItemDecorator decorator) -> {
            Objects.requireNonNull(item, "item is null");
            Objects.requireNonNull(decorator, "item decorator is null");
            evt.register(item, decorator::renderItemDecorations);
        });
    }

    @SubscribeEvent
    public void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent evt) {
        this.constructor.onRegisterClientReloadListeners((String id, PreparableReloadListener reloadListener) -> {
            Objects.requireNonNull(id, "reload listener id is null");
            Objects.requireNonNull(reloadListener, "reload listener is null");
            evt.registerReloadListener(reloadListener);
        });
    }

    @SubscribeEvent
    public void onAddLayers(final EntityRenderersEvent.AddLayers evt) {
        this.constructor.onRegisterLivingEntityRenderLayers(new ClientModConstructor.LivingEntityRenderLayersContext(){

            @Override
            public <T extends LivingEntity> void registerRenderLayer(EntityType<? extends T> entityType, BiFunction<RenderLayerParent<T, ? extends EntityModel<T>>, EntityRendererProvider.Context, RenderLayer<T, ? extends EntityModel<T>>> factory) {
                Objects.requireNonNull(entityType, "entity type is null");
                Objects.requireNonNull(factory, "render layer factory is null");
                if (entityType == EntityType.f_20532_) {
                    evt.getSkins().stream().map(arg_0 -> ((EntityRenderersEvent.AddLayers)evt).getSkin(arg_0)).filter(Objects::nonNull).map(entityRenderer -> (LivingEntityRenderer)entityRenderer).forEach(entityRenderer -> this.actuallyRegisterRenderLayer((LivingEntityRenderer)entityRenderer, factory));
                } else {
                    LivingEntityRenderer entityRenderer2 = evt.getRenderer(entityType);
                    Objects.requireNonNull(entityRenderer2, "entity renderer for %s is null".formatted(Registry.f_122826_.m_7981_(entityType).toString()));
                    this.actuallyRegisterRenderLayer(entityRenderer2, factory);
                }
            }

            private <T extends LivingEntity> void actuallyRegisterRenderLayer(LivingEntityRenderer<T, EntityModel<T>> entityRenderer, BiFunction<RenderLayerParent<T, ? extends EntityModel<T>>, EntityRendererProvider.Context, RenderLayer<T, ? extends EntityModel<T>>> factory) {
                Minecraft minecraft = Minecraft.m_91087_();
                EntityRendererProvider.Context context = new EntityRendererProvider.Context(minecraft.m_91290_(), minecraft.m_91291_(), minecraft.m_91289_(), minecraft.m_91290_().m_234586_(), null, evt.getEntityModels(), minecraft.f_91062_);
                entityRenderer.m_115326_(factory.apply((RenderLayerParent<LivingEntityRenderer<T, EntityModel<T>>, EntityModel<LivingEntityRenderer<T, EntityModel<T>>>>)entityRenderer, context));
            }
        });
    }

    @SubscribeEvent
    public void onRegisterKeyMappings(RegisterKeyMappingsEvent evt) {
        this.constructor.onRegisterKeyMappings((KeyMapping key) -> {
            Objects.requireNonNull(key, "key mapping is null");
            evt.register(key);
        });
    }

    public static void construct(String modId, ClientModConstructor constructor) {
        if (Strings.isBlank((String)modId)) {
            throw new IllegalArgumentException("modId cannot be empty");
        }
        PuzzlesLib.LOGGER.info("Constructing client components for mod {}", (Object)modId);
        ForgeClientModConstructor forgeModConstructor = new ForgeClientModConstructor(modId, constructor);
        PuzzlesUtilForge.findModEventBus(modId).register((Object)forgeModConstructor);
    }
}

