/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.networking;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.tileEntity.SyncedTileEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public abstract class TileEntityConfigurationPacket<TE extends SyncedTileEntity>
extends SimplePacketBase {
    protected BlockPos pos;

    public TileEntityConfigurationPacket(FriendlyByteBuf buffer) {
        this.pos = buffer.m_130135_();
        this.readSettings(buffer);
    }

    public TileEntityConfigurationPacket(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        this.writeSettings(buffer);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            Level world = player.f_19853_;
            if (world == null || !world.m_46749_(this.pos)) {
                return;
            }
            if (!this.pos.m_123314_((Vec3i)player.m_20183_(), (double)this.maxRange())) {
                return;
            }
            BlockEntity tileEntity = world.m_7702_(this.pos);
            if (tileEntity instanceof SyncedTileEntity) {
                this.applySettings(player, (SyncedTileEntity)tileEntity);
                if (!this.causeUpdate()) {
                    return;
                }
                ((SyncedTileEntity)tileEntity).sendData();
                tileEntity.m_6596_();
            }
        });
        context.get().setPacketHandled(true);
    }

    protected int maxRange() {
        return 20;
    }

    protected abstract void writeSettings(FriendlyByteBuf var1);

    protected abstract void readSettings(FriendlyByteBuf var1);

    protected void applySettings(ServerPlayer player, TE te) {
        this.applySettings(te);
    }

    protected boolean causeUpdate() {
        return true;
    }

    protected abstract void applySettings(TE var1);
}

