/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.entity;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.ContraptionRelocationPacket;
import com.simibubi.create.content.logistics.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.entity.TrainRelocator;
import com.simibubi.create.content.logistics.trains.track.BezierTrackPointLocation;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.VecHelper;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class TrainRelocationPacket
extends SimplePacketBase {
    UUID trainId;
    BlockPos pos;
    Vec3 lookAngle;
    int entityId;
    private boolean direction;
    private BezierTrackPointLocation hoveredBezier;

    public TrainRelocationPacket(FriendlyByteBuf buffer) {
        this.trainId = buffer.m_130259_();
        this.pos = buffer.m_130135_();
        this.lookAngle = VecHelper.read(buffer);
        this.entityId = buffer.readInt();
        this.direction = buffer.readBoolean();
        if (buffer.readBoolean()) {
            this.hoveredBezier = new BezierTrackPointLocation(buffer.m_130135_(), buffer.readInt());
        }
    }

    public TrainRelocationPacket(UUID trainId, BlockPos pos, BezierTrackPointLocation hoveredBezier, boolean direction, Vec3 lookAngle, int entityId) {
        this.trainId = trainId;
        this.pos = pos;
        this.hoveredBezier = hoveredBezier;
        this.direction = direction;
        this.lookAngle = lookAngle;
        this.entityId = entityId;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.trainId);
        buffer.m_130064_(this.pos);
        VecHelper.write(this.lookAngle, buffer);
        buffer.writeInt(this.entityId);
        buffer.writeBoolean(this.direction);
        buffer.writeBoolean(this.hoveredBezier != null);
        if (this.hoveredBezier != null) {
            buffer.m_130064_(this.hoveredBezier.curveTarget());
            buffer.writeInt(this.hoveredBezier.segment());
        }
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            ServerPlayer sender = ctx.getSender();
            Train train = Create.RAILWAYS.trains.get(this.trainId);
            Entity entity = sender.f_19853_.m_6815_(this.entityId);
            String messagePrefix = sender.m_7755_().getString() + " could not relocate Train ";
            if (train == null || !(entity instanceof CarriageContraptionEntity)) {
                Create.LOGGER.warn(messagePrefix + train.id.toString().substring(0, 5) + ": not present on server");
                return;
            }
            CarriageContraptionEntity cce = (CarriageContraptionEntity)entity;
            if (!train.id.equals(cce.trainId)) {
                return;
            }
            int verifyDistance = (Integer)AllConfigs.SERVER.trains.maxTrackPlacementLength.get() * 2;
            if (!sender.m_20182_().m_82509_((Position)Vec3.m_82512_((Vec3i)this.pos), (double)verifyDistance)) {
                Create.LOGGER.warn(messagePrefix + train.name.getString() + ": player too far from clicked pos");
                return;
            }
            if (!sender.m_20182_().m_82509_((Position)cce.m_20182_(), (double)verifyDistance + cce.m_20191_().m_82362_() / 2.0)) {
                Create.LOGGER.warn(messagePrefix + train.name.getString() + ": player too far from carriage entity");
                return;
            }
            if (TrainRelocator.relocate(train, sender.f_19853_, this.pos, this.hoveredBezier, this.direction, this.lookAngle, false)) {
                sender.m_5661_((Component)Lang.translateDirect("train.relocate.success", new Object[0]).m_130940_(ChatFormatting.GREEN), true);
                train.carriages.forEach(c -> c.forEachPresentEntity(e -> {
                    e.nonDamageTicks = 10;
                    AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> e), (Object)new ContraptionRelocationPacket(e.m_19879_()));
                }));
                return;
            }
            Create.LOGGER.warn(messagePrefix + train.name.getString() + ": relocation failed server-side");
        });
        ctx.setPacketHandled(true);
    }
}

