/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display.source;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.logistics.block.display.DisplayBehaviour;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.target.DisplayBoardTarget;
import com.simibubi.create.content.logistics.block.display.target.DisplayTarget;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayLayout;
import com.simibubi.create.content.logistics.trains.management.display.FlapDisplayTileEntity;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Components;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class DisplaySource
extends DisplayBehaviour {
    public static final List<MutableComponent> EMPTY = ImmutableList.of((Object)Components.empty());
    public static final MutableComponent EMPTY_LINE = Components.empty();
    public static final MutableComponent WHITESPACE = Components.literal(" ");

    public abstract List<MutableComponent> provideText(DisplayLinkContext var1, DisplayTargetStats var2);

    public void transferData(DisplayLinkContext context, DisplayTarget activeTarget, int line) {
        List<MutableComponent> text;
        DisplayTargetStats stats = activeTarget.provideStats(context);
        if (activeTarget instanceof DisplayBoardTarget) {
            DisplayBoardTarget fddt = (DisplayBoardTarget)activeTarget;
            List<List<MutableComponent>> flapDisplayText = this.provideFlapDisplayText(context, stats);
            fddt.acceptFlapText(line, flapDisplayText, context);
        }
        if ((text = this.provideText(context, stats)).isEmpty()) {
            text = EMPTY;
        }
        activeTarget.acceptText(line, text, context);
    }

    public void onSignalReset(DisplayLinkContext context) {
    }

    public void populateData(DisplayLinkContext context) {
    }

    public int getPassiveRefreshTicks() {
        return 100;
    }

    protected String getTranslationKey() {
        return this.id.m_135815_();
    }

    public Component getName() {
        return Components.translatable(this.id.m_135827_() + ".display_source." + this.getTranslationKey());
    }

    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayTileEntity flapDisplay, FlapDisplayLayout layout, int lineIndex) {
        this.loadFlapDisplayLayout(context, flapDisplay, layout);
    }

    public void loadFlapDisplayLayout(DisplayLinkContext context, FlapDisplayTileEntity flapDisplay, FlapDisplayLayout layout) {
        if (!layout.isLayout("Default")) {
            layout.loadDefault(flapDisplay.getMaxCharCount());
        }
    }

    public List<List<MutableComponent>> provideFlapDisplayText(DisplayLinkContext context, DisplayTargetStats stats) {
        return this.provideText(context, stats).stream().map(xva$0 -> Arrays.asList(xva$0)).toList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
    }
}

