/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.DirectionalKineticBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.advanced.GantryShaftTileEntity;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import com.simibubi.create.foundation.utility.placement.util.PoleHelper;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GantryShaftBlock
extends DirectionalKineticBlock
implements ITE<GantryShaftTileEntity> {
    public static final Property<Part> PART = EnumProperty.m_61587_((String)"part", Part.class);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{PART, POWERED}));
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (!placementHelper.matchesItem(heldItem)) {
            return InteractionResult.PASS;
        }
        return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return AllShapes.EIGHT_VOXEL_POLE.get(((Direction)state.m_61143_((Property)FACING)).m_122434_());
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighbour, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction.Axis axis = facing.m_122434_();
        if (direction.m_122434_() != axis) {
            return state;
        }
        boolean connect = AllBlocks.GANTRY_SHAFT.has(neighbour) && neighbour.m_61143_((Property)FACING) == facing;
        Part part = (Part)((Object)state.m_61143_(PART));
        if (direction.m_122421_() == facing.m_122421_()) {
            if (connect) {
                if (part == Part.END) {
                    part = Part.MIDDLE;
                }
                if (part == Part.SINGLE) {
                    part = Part.START;
                }
            } else {
                if (part == Part.MIDDLE) {
                    part = Part.END;
                }
                if (part == Part.START) {
                    part = Part.SINGLE;
                }
            }
        } else if (connect) {
            if (part == Part.START) {
                part = Part.MIDDLE;
            }
            if (part == Part.SINGLE) {
                part = Part.END;
            }
        } else {
            if (part == Part.MIDDLE) {
                part = Part.START;
            }
            if (part == Part.END) {
                part = Part.SINGLE;
            }
        }
        return (BlockState)state.m_61124_(PART, (Comparable)((Object)part));
    }

    public GantryShaftBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(PART, (Comparable)((Object)Part.SINGLE)));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState clickedState;
        BlockState state = super.m_5573_(context);
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        Direction face = context.m_43719_();
        BlockState neighbour = world.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()));
        BlockState blockState = clickedState = AllBlocks.GANTRY_SHAFT.has(neighbour) ? neighbour : world.m_8055_(pos.m_121945_(face.m_122424_()));
        if (AllBlocks.GANTRY_SHAFT.has(clickedState) && ((Direction)clickedState.m_61143_((Property)FACING)).m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            Direction facing = (Direction)clickedState.m_61143_((Property)FACING);
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)(context.m_43723_() == null || !context.m_43723_().m_6144_() ? facing : facing.m_122424_()));
        }
        return (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(this.shouldBePowered(state, world, pos)));
    }

    @Override
    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        InteractionResult onWrenched = super.onWrenched(state, context);
        if (onWrenched.m_19077_()) {
            BlockPos pos = context.m_8083_();
            Level world = context.m_43725_();
            this.m_6861_(world.m_8055_(pos), world, pos, state.m_60734_(), pos, false);
        }
        return onWrenched;
    }

    @Override
    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        if (!worldIn.m_5776_() && oldState.m_60713_((Block)AllBlocks.GANTRY_SHAFT.get())) {
            BlockEntity te;
            Part oldPart = (Part)((Object)oldState.m_61143_(PART));
            Part part = (Part)((Object)state.m_61143_(PART));
            if ((oldPart != Part.MIDDLE && part == Part.MIDDLE || oldPart == Part.SINGLE && part != Part.SINGLE) && (te = worldIn.m_7702_(pos)) instanceof GantryShaftTileEntity) {
                ((GantryShaftTileEntity)te).checkAttachedCarriageBlocks();
            }
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        if (worldIn.f_46443_) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        boolean shouldPower = worldIn.m_46753_(pos);
        if (!previouslyPowered && !shouldPower && this.shouldBePowered(state, worldIn, pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 3);
            return;
        }
        if (previouslyPowered == shouldPower) {
            return;
        }
        ArrayList<BlockPos> toUpdate = new ArrayList<BlockPos>();
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Direction.Axis axis = facing.m_122434_();
        block0: for (Direction d : Iterate.directionsInAxis(axis)) {
            BlockState currentState;
            BlockPos currentPos = pos.m_121945_(d);
            while (worldIn.m_46749_(currentPos) && (currentState = worldIn.m_8055_(currentPos)).m_60734_() instanceof GantryShaftBlock && currentState.m_61143_((Property)FACING) == facing) {
                if (!shouldPower && ((Boolean)currentState.m_61143_((Property)POWERED)).booleanValue() && worldIn.m_46753_(currentPos)) {
                    return;
                }
                if ((Boolean)currentState.m_61143_((Property)POWERED) == shouldPower) continue block0;
                toUpdate.add(currentPos);
                currentPos = currentPos.m_121945_(d);
            }
        }
        toUpdate.add(pos);
        for (BlockPos blockPos : toUpdate) {
            BlockState blockState = worldIn.m_8055_(blockPos);
            BlockEntity te = worldIn.m_7702_(blockPos);
            if (te instanceof KineticTileEntity) {
                ((KineticTileEntity)te).detachKinetics();
            }
            if (!(blockState.m_60734_() instanceof GantryShaftBlock)) continue;
            worldIn.m_7731_(blockPos, (BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(shouldPower)), 2);
        }
    }

    protected boolean shouldBePowered(BlockState state, Level worldIn, BlockPos pos) {
        boolean shouldPower = worldIn.m_46753_(pos);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        for (Direction d : Iterate.directionsInAxis(facing.m_122434_())) {
            BlockState neighbourState;
            BlockPos neighbourPos = pos.m_121945_(d);
            if (!worldIn.m_46749_(neighbourPos) || !((neighbourState = worldIn.m_8055_(neighbourPos)).m_60734_() instanceof GantryShaftBlock) || neighbourState.m_61143_((Property)FACING) != facing) continue;
            shouldPower |= ((Boolean)neighbourState.m_61143_((Property)POWERED)).booleanValue();
        }
        return shouldPower;
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    @Override
    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.m_61143_((Property)POWERED) == newState.m_61143_((Property)POWERED);
    }

    @Override
    public float getParticleTargetRadius() {
        return 0.35f;
    }

    @Override
    public float getParticleInitialRadius() {
        return 0.25f;
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Override
    public Class<GantryShaftTileEntity> getTileEntityClass() {
        return GantryShaftTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends GantryShaftTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.GANTRY_SHAFT.get();
    }

    public static enum Part implements StringRepresentable
    {
        START,
        MIDDLE,
        END,
        SINGLE;


        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }

    public static class PlacementHelper
    extends PoleHelper<Direction> {
        public PlacementHelper() {
            super(arg_0 -> AllBlocks.GANTRY_SHAFT.has(arg_0), s -> ((Direction)s.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_(), DirectionalKineticBlock.FACING);
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> AllBlocks.GANTRY_SHAFT.isIn(arg_0);
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = super.getOffset(player, world, state, pos, ray);
            offset.withTransform(offset.getTransform().andThen(s -> (BlockState)s.m_61124_((Property)POWERED, (Comparable)((Boolean)state.m_61143_((Property)POWERED)))));
            return offset;
        }
    }
}

