/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.processing.burner;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerBlockItem;
import com.simibubi.create.content.contraptions.processing.burner.BlazeBurnerTileEntity;
import com.simibubi.create.content.contraptions.wrench.IWrenchable;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.Lang;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BlazeBurnerBlock
extends HorizontalDirectionalBlock
implements ITE<BlazeBurnerTileEntity>,
IWrenchable {
    public static final EnumProperty<HeatLevel> HEAT_LEVEL = EnumProperty.m_61587_((String)"blaze", HeatLevel.class);

    public BlazeBurnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(HEAT_LEVEL, (Comparable)((Object)HeatLevel.NONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{HEAT_LEVEL, f_54117_});
    }

    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState p_220082_4_, boolean p_220082_5_) {
        if (world.f_46443_) {
            return;
        }
        BlockEntity tileEntity = world.m_7702_(pos.m_7494_());
        if (!(tileEntity instanceof BasinTileEntity)) {
            return;
        }
        BasinTileEntity basin = (BasinTileEntity)tileEntity;
        basin.notifyChangeOfContents();
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> list) {
        list.add((Object)AllItems.EMPTY_BLAZE_BURNER.asStack());
        super.m_49811_(group, list);
    }

    @Override
    public Class<BlazeBurnerTileEntity> getTileEntityClass() {
        return BlazeBurnerTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends BlazeBurnerTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.HEATER.get();
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(HEAT_LEVEL) == HeatLevel.NONE) {
            return null;
        }
        return ITE.super.m_142194_(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        ItemStack heldItem = player.m_21120_(hand);
        HeatLevel heat = (HeatLevel)((Object)state.m_61143_(HEAT_LEVEL));
        if (AllItems.GOGGLES.isIn(heldItem) && heat != HeatLevel.NONE) {
            return this.onTileEntityUse((BlockGetter)world, pos, bbte -> {
                if (bbte.goggles) {
                    return InteractionResult.PASS;
                }
                bbte.goggles = true;
                bbte.notifyUpdate();
                return InteractionResult.SUCCESS;
            });
        }
        if (heldItem.m_41619_() && heat != HeatLevel.NONE) {
            return this.onTileEntityUse((BlockGetter)world, pos, bbte -> {
                if (!bbte.goggles) {
                    return InteractionResult.PASS;
                }
                bbte.goggles = false;
                bbte.notifyUpdate();
                return InteractionResult.SUCCESS;
            });
        }
        if (heat == HeatLevel.NONE) {
            if (heldItem.m_41720_() instanceof FlintAndSteelItem) {
                world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.4f + 0.8f);
                if (world.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                heldItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
                world.m_46597_(pos, AllBlocks.LIT_BLAZE_BURNER.getDefaultState());
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        boolean doNotConsume = player.m_7500_();
        boolean forceOverflow = !(player instanceof FakePlayer);
        InteractionResultHolder<ItemStack> res = BlazeBurnerBlock.tryInsert(state, world, pos, heldItem, doNotConsume, forceOverflow, false);
        ItemStack leftover = (ItemStack)res.m_19095_();
        if (!(world.f_46443_ || doNotConsume || leftover.m_41619_())) {
            if (heldItem.m_41619_()) {
                player.m_21008_(hand, leftover);
            } else if (!player.m_150109_().m_36054_(leftover)) {
                player.m_36176_(leftover, false);
            }
        }
        return res.m_19089_() == InteractionResult.SUCCESS ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> tryInsert(BlockState state, Level world, BlockPos pos, ItemStack stack, boolean doNotConsume, boolean forceOverflow, boolean simulate) {
        if (!state.m_155947_()) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        BlockEntity te = world.m_7702_(pos);
        if (!(te instanceof BlazeBurnerTileEntity)) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        BlazeBurnerTileEntity burnerTE = (BlazeBurnerTileEntity)te;
        if (burnerTE.isCreativeFuel(stack)) {
            if (!simulate) {
                burnerTE.applyCreativeFuel();
            }
            return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
        }
        if (!burnerTE.tryUpdateFuel(stack, forceOverflow, simulate)) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        if (!doNotConsume) {
            ItemStack container;
            ItemStack itemStack = container = stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : ItemStack.f_41583_;
            if (!world.f_46443_) {
                stack.m_41774_(1);
            }
            return InteractionResultHolder.m_19090_((Object)container);
        }
        return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack stack = context.m_43722_();
        Item item = stack.m_41720_();
        BlockState defaultState = this.m_49966_();
        if (!(item instanceof BlazeBurnerBlockItem)) {
            return defaultState;
        }
        HeatLevel initialHeat = ((BlazeBurnerBlockItem)item).hasCapturedBlaze() ? HeatLevel.SMOULDERING : HeatLevel.NONE;
        return (BlockState)((BlockState)defaultState.m_61124_(HEAT_LEVEL, (Comparable)((Object)initialHeat))).m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return AllShapes.HEATER_BLOCK_SHAPE;
    }

    public VoxelShape m_5939_(BlockState p_220071_1_, BlockGetter p_220071_2_, BlockPos p_220071_3_, CollisionContext p_220071_4_) {
        if (p_220071_4_ == CollisionContext.m_82749_()) {
            return AllShapes.HEATER_BLOCK_SPECIAL_COLLISION_SHAPE;
        }
        return this.m_5940_(p_220071_1_, p_220071_2_, p_220071_3_, p_220071_4_);
    }

    public boolean m_7278_(BlockState p_149740_1_) {
        return true;
    }

    public int m_6782_(BlockState state, Level p_180641_2_, BlockPos p_180641_3_) {
        return Math.max(0, ((HeatLevel)((Object)state.m_61143_(HEAT_LEVEL))).ordinal() - 1);
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState state, Level world, BlockPos pos, Random random) {
        if (random.nextInt(10) != 0) {
            return;
        }
        if (!((HeatLevel)((Object)state.m_61143_(HEAT_LEVEL))).isAtLeast(HeatLevel.SMOULDERING)) {
            return;
        }
        world.m_7785_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + random.nextFloat(), random.nextFloat() * 0.7f + 0.6f, false);
    }

    public static HeatLevel getHeatLevelOf(BlockState blockState) {
        return blockState.m_61138_(HEAT_LEVEL) ? (HeatLevel)((Object)blockState.m_61143_(HEAT_LEVEL)) : HeatLevel.NONE;
    }

    public static int getLight(BlockState state) {
        HeatLevel level = (HeatLevel)((Object)state.m_61143_(HEAT_LEVEL));
        return switch (level) {
            case HeatLevel.NONE -> 0;
            case HeatLevel.SMOULDERING -> 8;
            default -> 15;
        };
    }

    public static LootTable.Builder buildLootTable() {
        LootItemCondition.Builder survivesExplosion = ExplosionCondition.m_81661_();
        BlazeBurnerBlock block = (BlazeBurnerBlock)AllBlocks.BLAZE_BURNER.get();
        LootTable.Builder builder = LootTable.m_79147_();
        LootPool.Builder poolBuilder = LootPool.m_79043_();
        for (HeatLevel level : HeatLevel.values()) {
            ItemLike drop = level == HeatLevel.NONE ? (ItemLike)AllItems.EMPTY_BLAZE_BURNER.get() : (ItemLike)AllBlocks.BLAZE_BURNER.get();
            poolBuilder.m_79076_(((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)drop).m_79080_(survivesExplosion)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_(HEAT_LEVEL, (Comparable)((Object)level)))));
        }
        builder.m_79161_(poolBuilder.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)));
        return builder;
    }

    public static enum HeatLevel implements StringRepresentable
    {
        NONE,
        SMOULDERING,
        FADING,
        KINDLED,
        SEETHING;


        public static HeatLevel byIndex(int index) {
            return HeatLevel.values()[index];
        }

        public HeatLevel nextActiveLevel() {
            return HeatLevel.byIndex(this.ordinal() % (HeatLevel.values().length - 1) + 1);
        }

        public boolean isAtLeast(HeatLevel heatLevel) {
            return this.ordinal() >= heatLevel.ordinal();
        }

        public String m_7912_() {
            return Lang.asId(this.name());
        }
    }
}

