/*
 * Decompiled with CFR 0.152.
 */
package wolforce.utils.registry;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class UtilItemRegistry {
    private static Class<?> itemsClass;

    public static void init(Class<?> itemsClass) {
        UtilItemRegistry.itemsClass = itemsClass;
    }

    @SubscribeEvent
    public static void onItemsRegistry(RegisterEvent event) {
        try {
            IForgeRegistry registry = event.getForgeRegistry();
            for (Field field : itemsClass.getDeclaredFields()) {
                Object object;
                if (!field.isAnnotationPresent(RegItem.class) || !((object = field.get(null)) instanceof Item)) continue;
                Item item = (Item)object;
                RegItem reg = field.getAnnotation(RegItem.class);
                registry.register(reg.regName(), (Object)item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface RegItem {
        public String regName() default "";
    }
}

