/*
 * Decompiled with CFR 0.152.
 */
package wolforce.utils.registry;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class UtilBlockRegistry {
    private static Class<?> blocksClass;

    public static void init(Class<?> blocksClass) {
        UtilBlockRegistry.blocksClass = blocksClass;
    }

    @SubscribeEvent
    public static void onItemsRegistry(RegisterEvent event) {
        try {
            IForgeRegistry registry = event.getForgeRegistry();
            for (Field field : blocksClass.getDeclaredFields()) {
                BlockItem blockItem;
                Object object;
                if (!field.isAnnotationPresent(RegBlock.class) || !((object = field.get(null)) instanceof Block)) continue;
                Block block = (Block)object;
                RegBlock reg = field.getAnnotation(RegBlock.class);
                if (block instanceof BlockWithItemProperties) {
                    BlockWithItemProperties blockWithProps = (BlockWithItemProperties)block;
                    blockItem = new BlockItem(block, blockWithProps.getItemProperties());
                } else {
                    blockItem = new BlockItem(block, new Item.Properties());
                }
                BlockItem item = blockItem;
                registry.register(reg.regName(), (Object)item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void onBlocksRegistry(RegisterEvent event) {
        try {
            IForgeRegistry registry = event.getForgeRegistry();
            for (Field field : blocksClass.getDeclaredFields()) {
                Object object;
                if (!field.isAnnotationPresent(RegBlock.class) || !((object = field.get(null)) instanceof Block)) continue;
                Block block = (Block)object;
                RegBlock reg = field.getAnnotation(RegBlock.class);
                registry.register(reg.regName(), (Object)block);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface RegBlock {
        public String regName() default "";
    }

    public static interface BlockWithItemProperties {
        public Item.Properties getItemProperties();
    }
}

