/*
 * Decompiled with CFR 0.152.
 */
package wolforce.utils.client;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import wolforce.utils.Vec3f;
import wolforce.utils.client.CustomVertexConsumer;
import wolforce.utils.stacks.UtilItemStack;

public class UtilRenderItem {
    public static Minecraft MC = Minecraft.m_91087_();
    public static ItemRenderer renderItem = MC.m_91291_();
    public static TextureManager textureManager = UtilRenderItem.MC.f_90987_;
    public static LocalPlayer player = Minecraft.m_91087_().f_91074_;
    private final ItemStack stack;
    private PoseStack poseStack;
    private Vec3 position = null;
    private Vec3f scale = null;
    private CustomVertexConsumer.ColorAction colorAction = null;
    private MultiBufferSource buffer = null;
    private Integer combinedLight = null;
    private Integer combinedOverlay = null;
    private boolean rotate = false;
    private static final Vec3 DEFAULT_POSITION = new Vec3(0.0, 0.0, 0.0);
    private static final Vec3f DEFAULT_SCALE = new Vec3f(1.0f, 1.0f, 1.0f);
    private static final int DEFAULT_COMBINED_LIGHT = 0xF000F0;
    private static final int DEFAULT_COMBINED_OVERLAY = OverlayTexture.f_118083_;

    private static MultiBufferSource DEFAULT_BUFFER() {
        return MC.m_91269_().m_110104_();
    }

    public static UtilRenderItem init(ItemStack stack) {
        return new UtilRenderItem(stack);
    }

    private UtilRenderItem(ItemStack stack) {
        this.stack = stack;
    }

    public UtilRenderItem pose(PoseStack poseStack) {
        this.poseStack = poseStack;
        return this;
    }

    public UtilRenderItem pos(Vec3 position) {
        this.position = position;
        return this;
    }

    public UtilRenderItem scale(double x, double y, double z) {
        this.scale = new Vec3f(x, y, z);
        return this;
    }

    public UtilRenderItem pos(double x, double y, double z) {
        this.position = new Vec3(x, y, z);
        return this;
    }

    public UtilRenderItem scale(Vec3 scale) {
        this.scale = new Vec3f(scale.f_82479_, scale.f_82480_, scale.f_82481_);
        return this;
    }

    public UtilRenderItem color(CustomVertexConsumer.ColorAction colorAction) {
        this.colorAction = colorAction;
        return this;
    }

    public UtilRenderItem rotate() {
        this.rotate = true;
        return this;
    }

    public UtilRenderItem buffer(MultiBufferSource buffer) {
        this.buffer = buffer;
        return this;
    }

    public UtilRenderItem combined(int combinedLight, int combinedOverlay) {
        this.combinedLight = combinedLight;
        this.combinedOverlay = combinedOverlay;
        return this;
    }

    public void renderGui() {
        if (!UtilItemStack.isValid(this.stack)) {
            return;
        }
        PoseStack poseStack = this.poseStack != null ? this.poseStack : RenderSystem.m_157191_();
        MultiBufferSource buffer = this.buffer != null ? this.buffer : MC.m_91269_().m_110104_();
        Vec3 position = this.position != null ? this.position : DEFAULT_POSITION;
        Vec3f scale = this.scale != null ? this.scale : DEFAULT_SCALE;
        int combinedLight = this.combinedLight != null ? this.combinedLight : 0xF000F0;
        int combinedOverlay = this.combinedOverlay != null ? this.combinedOverlay : DEFAULT_COMBINED_OVERLAY;
        BakedModel model = renderItem.m_174264_(this.stack, null, (LivingEntity)player, 0);
        poseStack.m_85836_();
        if (scale != null) {
            poseStack.m_85841_(scale.x, scale.y, scale.z);
        }
        if (position != null) {
            poseStack.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
        }
        if (this.rotate) {
            long time = System.currentTimeMillis() / 40L % 360L;
            poseStack.m_85845_(new Quaternion(Vector3f.f_122225_, (float)time, true));
        }
        poseStack.m_85837_(8.0, 8.0, 0.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        RenderSystem.m_157182_();
        Lighting.m_84930_();
        if (this.colorAction != null) {
            UtilRenderItem.renderCustomVertexConsumer(this.stack, ItemTransforms.TransformType.GUI, false, new PoseStack(), buffer, combinedLight, combinedOverlay, model, this.colorAction);
        } else {
            renderItem.m_115143_(this.stack, ItemTransforms.TransformType.GUI, false, new PoseStack(), buffer, combinedLight, combinedOverlay, model);
        }
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
            bufferSource.m_109911_();
        }
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    public void render() {
        if (!UtilItemStack.isValid(this.stack)) {
            return;
        }
        MultiBufferSource buffer = this.buffer != null ? this.buffer : UtilRenderItem.DEFAULT_BUFFER();
        Vec3 position = this.position != null ? this.position : DEFAULT_POSITION;
        Vec3f scale = this.scale != null ? this.scale : DEFAULT_SCALE;
        int combinedLight = this.combinedLight != null ? this.combinedLight : 0xF000F0;
        int combinedOverlay = this.combinedOverlay != null ? this.combinedOverlay : DEFAULT_COMBINED_OVERLAY;
        BakedModel model = renderItem.m_174264_(this.stack, null, (LivingEntity)player, 0);
        this.poseStack.m_85836_();
        boolean render3D = model.m_7539_();
        if (render3D) {
            Lighting.m_84931_();
        } else {
            Lighting.m_84930_();
        }
        if (scale != null) {
            this.poseStack.m_85841_(scale.x, scale.y, scale.z);
        }
        if (position != null) {
            this.poseStack.m_85837_(position.f_82479_, position.f_82480_, position.f_82481_);
        }
        if (this.rotate) {
            long time = System.currentTimeMillis() / 40L % 360L;
            this.poseStack.m_85845_(new Quaternion(Vector3f.f_122225_, (float)time, true));
        }
        if (!render3D) {
            this.poseStack.m_85841_(0.8f, 0.8f, 0.8f);
            this.poseStack.m_85837_(0.0, 0.1, 0.0);
        }
        if (this.colorAction != null) {
            UtilRenderItem.renderCustomVertexConsumer(this.stack, ItemTransforms.TransformType.GROUND, false, this.poseStack, buffer, combinedLight, combinedOverlay, model, this.colorAction);
        } else {
            renderItem.m_115143_(this.stack, ItemTransforms.TransformType.GROUND, false, this.poseStack, buffer, combinedLight, combinedOverlay, model);
        }
        this.poseStack.m_85849_();
    }

    public static void renderCustomVertexConsumer(ItemStack stack, ItemTransforms.TransformType transformType, boolean p_115146_, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel bakedModel, CustomVertexConsumer.ColorAction colorAction) {
        ItemRenderer itemRenderer = MC.m_91291_();
        ItemModelShaper itemModelShaper = itemRenderer.m_115103_();
        if (!stack.m_41619_()) {
            boolean flag;
            poseStack.m_85836_();
            boolean bl = flag = transformType == ItemTransforms.TransformType.GUI || transformType == ItemTransforms.TransformType.GROUND || transformType == ItemTransforms.TransformType.FIXED;
            if (flag) {
                if (stack.m_150930_(Items.f_42713_)) {
                    bakedModel = itemModelShaper.m_109393_().m_119422_(new ModelResourceLocation("minecraft:trident#inventory"));
                } else if (stack.m_150930_(Items.f_151059_)) {
                    bakedModel = itemModelShaper.m_109393_().m_119422_(new ModelResourceLocation("minecraft:spyglass#inventory"));
                }
            }
            bakedModel = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)bakedModel, (ItemTransforms.TransformType)transformType, (boolean)p_115146_);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            if (!(bakedModel.m_7521_() || stack.m_150930_(Items.f_42713_) && !flag)) {
                VertexConsumer vertexconsumer;
                Block block;
                boolean flag1 = transformType != ItemTransforms.TransformType.GUI && !transformType.m_111841_() && stack.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)stack.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                RenderType rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)stack, (boolean)flag1);
                if (stack.m_150930_(Items.f_42522_) && stack.m_41790_()) {
                    poseStack.m_85836_();
                    PoseStack.Pose posestack$pose = poseStack.m_85850_();
                    if (transformType == ItemTransforms.TransformType.GUI) {
                        posestack$pose.m_85861_().m_27630_(0.5f);
                    } else if (transformType.m_111841_()) {
                        posestack$pose.m_85861_().m_27630_(0.75f);
                    }
                    vertexconsumer = flag1 ? ItemRenderer.m_115207_((MultiBufferSource)buffer, (RenderType)rendertype, (PoseStack.Pose)posestack$pose) : ItemRenderer.m_115180_((MultiBufferSource)buffer, (RenderType)rendertype, (PoseStack.Pose)posestack$pose);
                    poseStack.m_85849_();
                } else {
                    vertexconsumer = flag1 ? ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.m_41790_()) : ItemRenderer.m_115211_((MultiBufferSource)buffer, (RenderType)rendertype, (boolean)true, (boolean)stack.m_41790_());
                }
                itemRenderer.m_115189_(bakedModel, stack, combinedLight, combinedOverlay, poseStack, (VertexConsumer)new CustomVertexConsumer(vertexconsumer, colorAction));
            }
            poseStack.m_85849_();
        }
    }
}

