/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.configs;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.minecraft.resources.ResourceLocation;

public class RegistryConfigs {
    public static final ConfigSpec REGISTRY_SPEC;
    private static final Map<String, Supplier<Boolean>> CONFIGS_BY_NAME;
    private static final Map<String, BooleanSupplier> MIXIN_VALUES;
    public static final Supplier<Boolean> ASH_ENABLED;
    public static final Supplier<Boolean> ASH_BRICKS_ENABLED;
    public static final Supplier<Boolean> PLANTER_ENABLED;
    public static final Supplier<Boolean> CLOCK_ENABLED;
    public static final Supplier<Boolean> PEDESTAL_ENABLED;
    public static final Supplier<Boolean> WIND_VANE_ENABLED;
    public static final Supplier<Boolean> ILLUMINATOR_ENABLED;
    public static final Supplier<Boolean> NOTICE_BOARD_ENABLED;
    public static final Supplier<Boolean> CRANK_ENABLED;
    public static final Supplier<Boolean> JAR_ENABLED;
    public static final Supplier<Boolean> FAUCET_ENABLED;
    public static final Supplier<Boolean> TURN_TABLE_ENABLED;
    public static final Supplier<Boolean> PISTON_LAUNCHER_ENABLED;
    public static final Supplier<Boolean> SPEAKER_BLOCK_ENABLED;
    public static final Supplier<Boolean> SIGN_POST_ENABLED;
    public static final Supplier<Boolean> HANGING_SIGN_ENABLED;
    public static final Supplier<Boolean> BELLOWS_ENABLED;
    public static final Supplier<Boolean> SCONCE_ENABLED;
    public static final Supplier<Boolean> SCONCE_GREEN_ENABLED;
    public static final Supplier<Boolean> CAGE_ENABLED;
    public static final Supplier<Boolean> ITEM_SHELF_ENABLED;
    public static final Supplier<Boolean> SCONCE_LEVER_ENABLED;
    public static final Supplier<Boolean> COG_BLOCK_ENABLED;
    public static final Supplier<Boolean> STONE_LAMP_ENABLED;
    public static final Supplier<Boolean> END_STONE_LAMP_ENABLED;
    public static final Supplier<Boolean> BLACKSTONE_LAMP_ENABLED;
    public static final Supplier<Boolean> DEEPSLATE_LAMP_ENABLED;
    public static final Supplier<Boolean> GLOBE_ENABLED;
    public static final Supplier<Boolean> HOURGLASS_ENABLED;
    public static final Supplier<Boolean> FLAG_ENABLED;
    public static final Supplier<Boolean> SACK_ENABLED;
    public static final Supplier<Boolean> BLACKBOARD_ENABLED;
    public static final Supplier<Boolean> SAFE_ENABLED;
    public static final Supplier<Boolean> COPPER_LANTERN_ENABLED;
    public static final Supplier<Boolean> FLUTE_ENABLED;
    public static final Supplier<Boolean> GOLD_TRAPDOOR_ENABLED;
    public static final Supplier<Boolean> GOLD_DOOR_ENABLED;
    public static final Supplier<Boolean> BAMBOO_SPIKES_ENABLED;
    public static final Supplier<Boolean> TIPPED_SPIKES_ENABLED;
    public static final Supplier<Boolean> CHECKERBOARD_ENABLED;
    public static final Supplier<Boolean> NETHERITE_TRAPDOOR_ENABLED;
    public static final Supplier<Boolean> NETHERITE_DOOR_ENABLED;
    public static final Supplier<Boolean> PANCAKES_ENABLED;
    public static final Supplier<Boolean> LOCK_BLOCK_ENABLED;
    public static final Supplier<Boolean> FLAX_ENABLED;
    public static final Supplier<Boolean> ROPE_ENABLED;
    public static final Supplier<Boolean> ROPE_ARROW_ENABLED;
    public static final Supplier<Boolean> PULLEY_ENABLED;
    public static final Supplier<Boolean> FODDER_ENABLED;
    public static final Supplier<Boolean> BOMB_ENABLED;
    public static final Supplier<Boolean> CRIMSON_LANTERN_ENABLED;
    public static final Supplier<Boolean> DAUB_ENABLED;
    public static final Supplier<Boolean> WATTLE_AND_DAUB_ENABLED;
    public static final Supplier<Boolean> TIMBER_FRAME_ENABLED;
    public static final Supplier<Boolean> TILE_ENABLED;
    public static final Supplier<Boolean> GOBLET_ENABLED;
    public static final Supplier<Boolean> RAKED_GRAVEL_ENABLED;
    public static final Supplier<Boolean> STATUE_ENABLED;
    public static final Supplier<Boolean> IRON_GATE_ENABLED;
    public static final Supplier<Boolean> FEATHER_BLOCK_ENABLED;
    public static final Supplier<Boolean> FLINT_BLOCK_ENABLED;
    public static final Supplier<Boolean> SLINGSHOT_ENABLED;
    public static final Supplier<Boolean> SHULKER_HELMET_ENABLED;
    public static final Supplier<Boolean> CANDY_ENABLED;
    public static final Supplier<Boolean> WRENCH_ENABLED;
    public static final Supplier<Boolean> QUIVER_ENABLED;
    public static final Supplier<Boolean> URN_ENABLED;
    public static final Supplier<Boolean> ANTIQUE_INK_ENABLED;
    public static final Supplier<Boolean> DOORMAT_ENABLED;
    public static final Supplier<Boolean> FLOWER_BOX_ENABLED;
    public static final Supplier<Boolean> BLACKSTONE_TILE_ENABLED;
    public static final Supplier<Boolean> SOAP_ENABLED;
    public static final Supplier<Boolean> BUBBLE_BLOWER_ENABLED;
    public static final Supplier<Boolean> GLOBE_SEPIA;
    public static final Supplier<Boolean> PRESENT_ENABLED;
    public static final Supplier<Boolean> STASIS_ENABLED;
    public static final Supplier<Boolean> SILVER_TRAPDOOR_ENABLED;
    public static final Supplier<Boolean> SILVER_DOOR_ENABLED;
    public static final Supplier<Boolean> LEAD_TRAPDOOR_ENABLED;
    public static final Supplier<Boolean> LEAD_DOOR_ENABLED;
    public static final Supplier<Boolean> DISPENSER_MINECART_ENABLED;
    public static final Supplier<Boolean> SUGAR_CUBE_ENABLED;
    public static final Supplier<Boolean> CRYSTAL_DISPLAY_ENABLED;
    public static final Supplier<Boolean> LAPIS_BRICKS_ENABLED;
    public static final Supplier<Boolean> RELAYER_ENABLED;
    public static final Supplier<Boolean> CANDLE_HOLDER_ENABLED;
    public static final Supplier<Boolean> ENDERMAN_HEAD_ENABLED;
    public static final Supplier<Boolean> JAR_TAB;
    public static final Supplier<Boolean> CREATIVE_TAB;
    public static final Supplier<Boolean> DISPENSERS;
    public static final Supplier<Boolean> CUSTOM_CONFIGURED_SCREEN;
    public static final Supplier<Boolean> DEBUG_RESOURCES;
    public static final Supplier<Boolean> PACK_DEPENDANT_ASSETS;

    public static void init() {
    }

    private static void warnIfTooManyOff() {
        int size = CONFIGS_BY_NAME.size();
        int on = 0;
        for (Supplier<Boolean> v : CONFIGS_BY_NAME.values()) {
            if (!v.get().booleanValue()) continue;
            ++on;
        }
        if ((double)((float)on / (float)size) < 0.2) {
            Supplementaries.LOGGER.warn("You seem to have disabled more than 80% of the mod. You should probably remove it");
        }
    }

    public static boolean isMixinEnabled(String className) {
        BooleanSupplier config = MIXIN_VALUES.get(className);
        return config == null || config.getAsBoolean();
    }

    private static Supplier<Boolean> regConfig(ConfigBuilder builder, String name, Boolean value) {
        Supplier config = builder.define(name, value.booleanValue());
        CONFIGS_BY_NAME.put(name, config);
        return config;
    }

    public static boolean isEnabled(String key) {
        if (key.contains("daub")) {
            return DAUB_ENABLED.get();
        }
        return switch (key) {
            case "way_sign" -> CommonConfigs.Spawns.WAY_SIGN_ENABLED.get();
            case "trapped_present" -> PRESENT_ENABLED.get();
            case "flax_block", "wild_flax" -> FLAX_ENABLED.get();
            case "soap_block" -> SOAP_ENABLED.get();
            case "checker_slab", "checker_vertical_slab" -> CHECKERBOARD_ENABLED.get();
            case "planter_rich", "planter_rich_soul" -> PLANTER_ENABLED.get();
            case "vertical_slabs" -> CompatHandler.isVerticalSlabEnabled();
            case "globe_sepia" -> {
                if (GLOBE_SEPIA.get().booleanValue() && ANTIQUE_INK_ENABLED.get().booleanValue()) {
                    yield true;
                }
                yield false;
            }
            case "key" -> {
                if (NETHERITE_DOOR_ENABLED.get().booleanValue() || NETHERITE_TRAPDOOR_ENABLED.get().booleanValue() || SAFE_ENABLED.get().booleanValue()) {
                    yield true;
                }
                yield false;
            }
            default -> CONFIGS_BY_NAME.getOrDefault(key, () -> true).get();
        };
    }

    static {
        CONFIGS_BY_NAME = new HashMap<String, Supplier<Boolean>>();
        MIXIN_VALUES = new HashMap<String, BooleanSupplier>();
        ConfigBuilder builder = ConfigBuilder.create((ResourceLocation)Supplementaries.res("registry"), (ConfigType)ConfigType.COMMON);
        builder.comment("Here are configs that need reloading to take effect");
        builder.push("general");
        CREATIVE_TAB = builder.comment("Enable Creative Tab").define("creative_tab", false);
        DISPENSERS = builder.comment("Set to false to disable custom dispenser behaviors (i.e: filling jars) if for some reason they are causing trouble").define("dispensers", true);
        JAR_TAB = builder.comment("Creates a creative tab full of filled jars").define("jar_tab", false);
        CUSTOM_CONFIGURED_SCREEN = builder.comment("Enables custom Configured config screen").define("custom_configured_screen", true);
        DEBUG_RESOURCES = builder.comment("Save generated resources to disk in a 'debug' folder in your game directory. Mainly for debug purposes but can be used to generate assets in all wood types for your mods :0").define("debug_save_dynamic_pack", false);
        PACK_DEPENDANT_ASSETS = () -> true;
        builder.pop();
        builder.push("blocks");
        PLANTER_ENABLED = RegistryConfigs.regConfig(builder, "planter", true);
        CLOCK_ENABLED = RegistryConfigs.regConfig(builder, "clock_block", true);
        PEDESTAL_ENABLED = RegistryConfigs.regConfig(builder, "pedestal", true);
        WIND_VANE_ENABLED = RegistryConfigs.regConfig(builder, "wind_vane", true);
        ILLUMINATOR_ENABLED = RegistryConfigs.regConfig(builder, "redstone_illuminator", true);
        NOTICE_BOARD_ENABLED = RegistryConfigs.regConfig(builder, "notice_board", true);
        CRANK_ENABLED = RegistryConfigs.regConfig(builder, "crank", true);
        JAR_ENABLED = RegistryConfigs.regConfig(builder, "jar", true);
        FAUCET_ENABLED = RegistryConfigs.regConfig(builder, "faucet", true);
        TURN_TABLE_ENABLED = RegistryConfigs.regConfig(builder, "turn_table", true);
        PISTON_LAUNCHER_ENABLED = RegistryConfigs.regConfig(builder, "spring_launcher", true);
        SPEAKER_BLOCK_ENABLED = RegistryConfigs.regConfig(builder, "speaker_block", true);
        SIGN_POST_ENABLED = RegistryConfigs.regConfig(builder, "sign_post", true);
        HANGING_SIGN_ENABLED = RegistryConfigs.regConfig(builder, "hanging_sign", true);
        BELLOWS_ENABLED = RegistryConfigs.regConfig(builder, "bellows", true);
        SCONCE_ENABLED = RegistryConfigs.regConfig(builder, "sconce", true);
        SCONCE_GREEN_ENABLED = RegistryConfigs.regConfig(builder, "sconce_green", false);
        CAGE_ENABLED = RegistryConfigs.regConfig(builder, "cage", true);
        ITEM_SHELF_ENABLED = RegistryConfigs.regConfig(builder, "item_shelf", true);
        SCONCE_LEVER_ENABLED = RegistryConfigs.regConfig(builder, "sconce_lever", true);
        COG_BLOCK_ENABLED = RegistryConfigs.regConfig(builder, "cog_block", true);
        GLOBE_ENABLED = RegistryConfigs.regConfig(builder, "globe", true);
        HOURGLASS_ENABLED = RegistryConfigs.regConfig(builder, "hourglass", true);
        SACK_ENABLED = RegistryConfigs.regConfig(builder, "sack", true);
        BLACKBOARD_ENABLED = RegistryConfigs.regConfig(builder, "blackboard", true);
        SAFE_ENABLED = RegistryConfigs.regConfig(builder, "safe", true);
        COPPER_LANTERN_ENABLED = RegistryConfigs.regConfig(builder, "copper_lantern", true);
        GOLD_TRAPDOOR_ENABLED = RegistryConfigs.regConfig(builder, "gold_trapdoor", true);
        GOLD_DOOR_ENABLED = RegistryConfigs.regConfig(builder, "gold_door", true);
        BAMBOO_SPIKES_ENABLED = RegistryConfigs.regConfig(builder, "bamboo_spikes", true);
        TIPPED_SPIKES_ENABLED = RegistryConfigs.regConfig(builder, "bamboo_spikes_tipped", true);
        STONE_LAMP_ENABLED = RegistryConfigs.regConfig(builder, "stone_lamp", true);
        END_STONE_LAMP_ENABLED = RegistryConfigs.regConfig(builder, "end_stone_lamp", true);
        BLACKSTONE_LAMP_ENABLED = RegistryConfigs.regConfig(builder, "blackstone_lamp", true);
        DEEPSLATE_LAMP_ENABLED = RegistryConfigs.regConfig(builder, "deepslate_lamp", true);
        CHECKERBOARD_ENABLED = RegistryConfigs.regConfig(builder, "checker_block", true);
        NETHERITE_DOOR_ENABLED = RegistryConfigs.regConfig(builder, "netherite_door", true);
        NETHERITE_TRAPDOOR_ENABLED = RegistryConfigs.regConfig(builder, "netherite_trapdoor", true);
        LOCK_BLOCK_ENABLED = RegistryConfigs.regConfig(builder, "lock_block", true);
        FLAX_ENABLED = RegistryConfigs.regConfig(builder, "flax", true);
        ROPE_ENABLED = RegistryConfigs.regConfig(builder.comment("Before disabling because other mods dont have such easy configs let me remind you that my ropes can:\n- be pulled up and down\n- be placed horizontally and walked upon\n- be tied to fences, walls and posts, horizontals too\n- be found in new mineshaft structures and chests\n- have custom break slide and step sound\n- negate all fall damage while not slowing your fall\n- rope arrows and pulleys\n- you can ring attached bells\n- mod integration (FD tomatoes)\n- can pull the last block attached to them\n- walking on one will wobble your screen"), "rope", true);
        PULLEY_ENABLED = RegistryConfigs.regConfig(builder, "pulley_block", true);
        FODDER_ENABLED = RegistryConfigs.regConfig(builder, "fodder", true);
        CRIMSON_LANTERN_ENABLED = RegistryConfigs.regConfig(builder, "crimson_lantern", true);
        DAUB_ENABLED = RegistryConfigs.regConfig(builder, "daub", true);
        WATTLE_AND_DAUB_ENABLED = RegistryConfigs.regConfig(builder, "wattle_and_daub", true);
        TIMBER_FRAME_ENABLED = RegistryConfigs.regConfig(builder, "timber_frame", true);
        FLAG_ENABLED = RegistryConfigs.regConfig(builder, "flag", true);
        TILE_ENABLED = RegistryConfigs.regConfig(builder, "stone_tile", true);
        GOBLET_ENABLED = RegistryConfigs.regConfig(builder, "goblet", true);
        RAKED_GRAVEL_ENABLED = RegistryConfigs.regConfig(builder, "raked_gravel", true);
        STATUE_ENABLED = RegistryConfigs.regConfig(builder, "statue", true);
        IRON_GATE_ENABLED = RegistryConfigs.regConfig(builder, "iron_gate", true);
        FEATHER_BLOCK_ENABLED = RegistryConfigs.regConfig(builder, "feather_block", true);
        FLINT_BLOCK_ENABLED = RegistryConfigs.regConfig(builder, "flint_block", true);
        URN_ENABLED = RegistryConfigs.regConfig(builder, "urn", true);
        ASH_ENABLED = RegistryConfigs.regConfig(builder, "ash", true);
        ASH_BRICKS_ENABLED = RegistryConfigs.regConfig(builder, "ash_bricks", true);
        DOORMAT_ENABLED = RegistryConfigs.regConfig(builder, "doormat", true);
        FLOWER_BOX_ENABLED = RegistryConfigs.regConfig(builder, "flower_box", true);
        BLACKSTONE_TILE_ENABLED = RegistryConfigs.regConfig(builder, "blackstone_tile", true);
        GLOBE_SEPIA = RegistryConfigs.regConfig(builder, "globe_sepia", true);
        PRESENT_ENABLED = RegistryConfigs.regConfig(builder, "present", true);
        SUGAR_CUBE_ENABLED = RegistryConfigs.regConfig(builder, "sugar_cube", true);
        CRYSTAL_DISPLAY_ENABLED = RegistryConfigs.regConfig(builder, "crystal_display", true);
        LAPIS_BRICKS_ENABLED = RegistryConfigs.regConfig(builder, "lapis_bricks", true);
        RELAYER_ENABLED = RegistryConfigs.regConfig(builder, "relayer", true);
        CANDLE_HOLDER_ENABLED = RegistryConfigs.regConfig(builder, "candle_holder", true);
        ENDERMAN_HEAD_ENABLED = RegistryConfigs.regConfig(builder, "enderman_head", true);
        SILVER_TRAPDOOR_ENABLED = RegistryConfigs.regConfig(builder, "silver_trapdoor", true);
        SILVER_DOOR_ENABLED = RegistryConfigs.regConfig(builder, "silver_door", true);
        LEAD_TRAPDOOR_ENABLED = RegistryConfigs.regConfig(builder, "lead_trapdoor", true);
        LEAD_DOOR_ENABLED = RegistryConfigs.regConfig(builder, "lead_door", true);
        builder.pop();
        builder.push("items");
        FLUTE_ENABLED = RegistryConfigs.regConfig(builder, "flute", true);
        STASIS_ENABLED = RegistryConfigs.regConfig(builder, "stasis", true);
        DISPENSER_MINECART_ENABLED = RegistryConfigs.regConfig(builder, "dispenser_minecart", true);
        SOAP_ENABLED = RegistryConfigs.regConfig(builder, "soap", true);
        BUBBLE_BLOWER_ENABLED = RegistryConfigs.regConfig(builder, "bubble_blower", true);
        ANTIQUE_INK_ENABLED = RegistryConfigs.regConfig(builder, "antique_ink", true);
        SHULKER_HELMET_ENABLED = RegistryConfigs.regConfig(builder, "shulker_shell", true);
        CANDY_ENABLED = RegistryConfigs.regConfig(builder, "candy", true);
        WRENCH_ENABLED = RegistryConfigs.regConfig(builder, "wrench", true);
        QUIVER_ENABLED = RegistryConfigs.regConfig(builder, "quiver", true);
        SLINGSHOT_ENABLED = RegistryConfigs.regConfig(builder, "slingshot", true);
        ROPE_ARROW_ENABLED = RegistryConfigs.regConfig(builder, "rope_arrow", true);
        BOMB_ENABLED = RegistryConfigs.regConfig(builder, "bomb", true);
        PANCAKES_ENABLED = RegistryConfigs.regConfig(builder, "pancake", true);
        builder.pop();
        REGISTRY_SPEC = builder.build();
        REGISTRY_SPEC.loadFromFile();
        RegistryConfigs.warnIfTooManyOff();
        builder.onChange(RegistryConfigs::warnIfTooManyOff);
    }
}

