/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.forge;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.supplementaries.api.IQuiverEntity;
import net.mehvahdjukaar.supplementaries.common.capabilities.CapabilityHandler;
import net.mehvahdjukaar.supplementaries.common.items.QuiverItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.CuriosCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class QuiverItemImpl {
    public static ItemStack getQuiver(LivingEntity entity) {
        IItemHandler cap;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (CompatHandler.CURIOS) {
                ItemStack q = CuriosCompat.getEquippedQuiver(player);
                if (q != null) {
                    return q;
                }
                if (CommonConfigs.Items.QUIVER_CURIO_ONLY.get().booleanValue()) {
                    return ItemStack.f_41583_;
                }
            }
        } else if (entity instanceof IQuiverEntity) {
            IQuiverEntity e = (IQuiverEntity)entity;
            return e.getQuiver();
        }
        if ((cap = (IItemHandler)CapabilityHandler.get((ICapabilityProvider)entity, ForgeCapabilities.ITEM_HANDLER)) != null) {
            for (int i = 0; i < cap.getSlots(); ++i) {
                ItemStack quiver = cap.getStackInSlot(i);
                if (quiver.m_41720_() != ModRegistry.QUIVER_ITEM.get()) continue;
                return quiver;
            }
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public static QuiverItem.Data getQuiverData(ItemStack stack) {
        return (QuiverCapability)CapabilityHandler.get((ICapabilityProvider)stack, ForgeCapabilities.ITEM_HANDLER);
    }

    public static class QuiverCapability
    extends ItemStackHandler
    implements ICapabilitySerializable<CompoundTag>,
    QuiverItem.Data {
        private final LazyOptional<IItemHandler> lazyOptional = LazyOptional.of(() -> this);
        private final LazyOptional<QuiverCapability> lazyOptional2 = LazyOptional.of(() -> this);
        private int selectedSlot = 0;

        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
            LazyOptional v = ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.lazyOptional);
            if (v.isPresent()) {
                return v;
            }
            v = CapabilityHandler.QUIVER_ITEM_HANDLER.orEmpty(cap, this.lazyOptional2);
            return v;
        }

        public CompoundTag serializeNBT() {
            CompoundTag c = super.serializeNBT();
            c.m_128405_("SelectedSlot", this.selectedSlot);
            return c;
        }

        public void deserializeNBT(CompoundTag nbt) {
            super.deserializeNBT(nbt);
            this.selectedSlot = nbt.m_128445_("SelectedSlot");
        }

        public QuiverCapability() {
            super(CommonConfigs.Items.QUIVER_SLOTS.get().intValue());
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.canAcceptItem(stack);
        }

        @Override
        public List<ItemStack> getContentView() {
            return this.stacks;
        }

        @Override
        public int getSelectedSlot() {
            return this.selectedSlot;
        }

        @Override
        public void setSelectedSlot(int selectedSlot) {
            if (!((ItemStack)this.stacks.get(selectedSlot)).m_41619_()) {
                this.selectedSlot = selectedSlot;
            }
        }

        @Override
        public boolean cycle(int slotsMoved) {
            ItemStack stack;
            int originalSlot = this.selectedSlot;
            int maxSlots = this.stacks.size();
            this.selectedSlot = (maxSlots + (this.selectedSlot + (slotsMoved %= maxSlots))) % maxSlots;
            for (int i = 0; i < maxSlots && (stack = this.getStackInSlot(this.selectedSlot)).m_41619_(); ++i) {
                this.selectedSlot = (maxSlots + (this.selectedSlot + (slotsMoved >= 0 ? 1 : -1))) % maxSlots;
            }
            return originalSlot != this.selectedSlot;
        }

        @Override
        public ItemStack tryAdding(ItemStack toInsert, boolean onlyOnExisting) {
            if (!toInsert.m_41619_() && toInsert.m_41720_().m_142095_()) {
                if (onlyOnExisting) {
                    int countToAdd = toInsert.m_41613_();
                    for (int i = 0; i < this.getSlots() && countToAdd > 0; ++i) {
                        ItemStack s = this.getStackInSlot(i);
                        if (!ItemStack.m_150942_((ItemStack)s, (ItemStack)toInsert)) continue;
                        int newCount = Math.min(s.m_41741_(), s.m_41613_() + countToAdd);
                        int increment = newCount - s.m_41613_();
                        countToAdd -= increment;
                        s.m_41769_(increment);
                        this.onContentsChanged(i);
                    }
                    toInsert.m_41764_(countToAdd);
                    return toInsert;
                }
                return ItemHandlerHelper.insertItem((IItemHandler)this, (ItemStack)toInsert, (boolean)false);
            }
            return toInsert;
        }

        @Override
        public Optional<ItemStack> removeOneStack() {
            int i = 0;
            for (ItemStack s : this.getContentView()) {
                if (!s.m_41619_()) {
                    ItemStack extracted = this.extractItem(i, s.m_41613_(), false);
                    this.updateSelectedIfNeeded();
                    return Optional.of(extracted);
                }
                ++i;
            }
            return Optional.empty();
        }

        @Override
        public void consumeArrow() {
            ItemStack s = this.getSelected();
            s.m_41774_(1);
            if (s.m_41619_()) {
                this.stacks.set(this.selectedSlot, (Object)ItemStack.f_41583_);
            }
            this.updateSelectedIfNeeded();
        }
    }
}

