/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.item.IFirstPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonAnimationProvider;
import net.mehvahdjukaar.moonlight.api.item.IThirdPersonSpecialItemRenderer;
import net.mehvahdjukaar.moonlight.api.misc.DualWeildState;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.supplementaries.common.items.InstrumentItem;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FluteItem
extends InstrumentItem
implements IThirdPersonAnimationProvider,
IThirdPersonSpecialItemRenderer,
IFirstPersonAnimationProvider {
    public FluteItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_6832_(ItemStack pStack, ItemStack pRepairCandidate) {
        return pRepairCandidate.m_150930_(Items.f_41911_);
    }

    public boolean m_5812_(ItemStack pStack) {
        CompoundTag tag = pStack.m_41783_();
        if (tag == null) {
            return false;
        }
        return tag.m_128441_("Pet") || super.m_5812_(pStack);
    }

    public static boolean interactWithPet(ItemStack stack, Player player, Entity target, InteractionHand hand) {
        TamableAnimal animal;
        if (!(target instanceof LivingEntity)) {
            return false;
        }
        CompoundTag c = stack.m_41737_("Pet");
        if (c != null) {
            return false;
        }
        if (target instanceof TamableAnimal && (animal = (TamableAnimal)target).m_21824_() && animal.m_21805_().equals(player.m_20148_()) || target.m_6095_().m_204039_(ModTags.FLUTE_PET)) {
            Fox fox;
            AbstractHorse horse;
            if (target instanceof AbstractHorse && !(horse = (AbstractHorse)target).m_30614_()) {
                return false;
            }
            if (target instanceof Fox && !(fox = (Fox)target).m_28529_(player.m_20148_())) {
                return false;
            }
            CompoundTag com = new CompoundTag();
            com.m_128359_("Name", target.m_7755_().getString());
            com.m_128362_("UUID", target.m_20148_());
            stack.m_41700_("Pet", (Tag)com);
            player.m_21008_(hand, stack);
            player.m_36335_().m_41524_(stack.m_41720_(), 20);
            return true;
        }
        return false;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand handIn) {
        ItemStack stack;
        block1: {
            block3: {
                int r;
                double z;
                double y;
                double x;
                block2: {
                    super.m_7203_(level, player, handIn);
                    stack = player.m_21120_(handIn);
                    if (!(level instanceof ServerLevel)) break block1;
                    ServerLevel serverLevel = (ServerLevel)level;
                    x = player.m_20185_();
                    y = player.m_20186_();
                    z = player.m_20189_();
                    r = CommonConfigs.Items.FLUTE_RADIUS.get();
                    CompoundTag com = stack.m_41737_("Pet");
                    if (com == null) break block2;
                    Entity entity = serverLevel.m_8791_(com.m_128342_("UUID"));
                    int maxDist = CommonConfigs.Items.FLUTE_DISTANCE.get() * CommonConfigs.Items.FLUTE_DISTANCE.get();
                    if (!(entity instanceof LivingEntity)) break block3;
                    LivingEntity pet = (LivingEntity)entity;
                    if (pet.f_19853_ != player.f_19853_ || !(pet.m_20280_((Entity)player) < (double)maxDist) || !pet.m_20984_(x, y, z, false)) break block3;
                    pet.m_5796_();
                    break block3;
                }
                AABB bb = new AABB(x - (double)r, y - (double)r, z - (double)r, x + (double)r, y + (double)r, z + (double)r);
                List entities = level.m_6249_((Entity)player, bb, TamableAnimal.class::isInstance);
                for (Entity e : entities) {
                    TamableAnimal pet = (TamableAnimal)e;
                    if (!pet.m_21824_() || pet.m_21827_() || !pet.m_21805_().equals(player.m_20148_())) continue;
                    pet.m_20984_(x, y, z, false);
                }
            }
            player.m_36335_().m_41524_((Item)this, 20);
        }
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Override
    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity entity, int pTimeCharged) {
        super.m_5551_(pStack, pLevel, entity, pTimeCharged);
        pStack.m_41622_(1, entity, en -> en.m_21166_(EquipmentSlot.MAINHAND));
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        CompoundTag tag = stack.m_41737_("Pet");
        if (tag != null) {
            tooltip.add((Component)Component.m_237113_((String)tag.m_128461_("Name")).m_130940_(ChatFormatting.GRAY));
        }
    }

    @Override
    public void spawnNoteParticle(Level level, LivingEntity entity, int note) {
        if (!ClientConfigs.Items.FLUTE_PARTICLES.get().booleanValue()) {
            return;
        }
        Vec3 bx = new Vec3(1.0, 0.0, 0.0);
        Vec3 by = new Vec3(0.0, 1.0, 0.0);
        Vec3 bz = new Vec3(0.0, 0.0, 1.0);
        float toRad = (float)Math.PI / 180;
        float xRot = -entity.m_146909_() * toRad;
        float yRot = -Mth.m_14177_((float)entity.f_20885_) * toRad;
        bx = bx.m_82496_(xRot).m_82524_(yRot);
        by = by.m_82496_(xRot).m_82524_(yRot);
        bz = bz.m_82496_(xRot).m_82524_(yRot);
        Vec3 armVec = new Vec3(0.0, 0.0, 0.28 + (double)level.f_46441_.m_188501_() * 0.5);
        int mirror = entity.m_5737_() == HumanoidArm.RIGHT ^ entity.m_7655_() == InteractionHand.MAIN_HAND ? -1 : 1;
        armVec = armVec.m_82524_((float)(-1.5707963267948966 * (double)mirror)).m_82520_(0.0, 0.15, 0.1);
        Vec3 newV = bx.m_82490_(armVec.f_82479_).m_82549_(by.m_82490_(armVec.f_82480_)).m_82549_(bz.m_82490_(armVec.f_82481_));
        double x = entity.m_20185_() + newV.f_82479_;
        double y = entity.m_20188_() + newV.f_82480_;
        double z = entity.m_20189_() + newV.f_82481_;
        SimpleParticleType particle = entity.m_5842_() ? ParticleTypes.f_123795_ : ParticleTypes.f_123758_;
        level.m_7106_((ParticleOptions)particle, x, y, z, (double)level.f_46441_.m_188503_(24) / 24.0, 0.0, 0.0);
    }

    public void animateItemFirstPerson(LivingEntity entity, ItemStack stack, InteractionHand hand, PoseStack matrixStack, float partialTicks, float pitch, float attackAnim, float handHeight) {
        if (entity.m_6117_() && entity.m_21212_() > 0 && entity.m_7655_() == hand) {
            int mirror = entity.m_5737_() == HumanoidArm.RIGHT ^ hand == InteractionHand.MAIN_HAND ? -1 : 1;
            matrixStack.m_85837_(-0.4 * (double)mirror, 0.2, 0.0);
            float timeLeft = (float)stack.m_41779_() - ((float)entity.m_21212_() - partialTicks + 1.0f);
            float sin = Mth.m_14031_((float)((timeLeft - 0.1f) * 1.3f));
            matrixStack.m_85837_(0.0, (double)(sin * 0.0038f), 0.0);
            matrixStack.m_85845_(Vector3f.f_122226_.m_122240_(90.0f));
            matrixStack.m_85841_(1.0f * (float)mirror, -1.0f * (float)mirror, -1.0f);
        }
    }

    public <T extends LivingEntity> boolean poseRightArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand, DualWeildState twoHanded) {
        if (entity.m_21212_() > 0 && entity.m_21211_().m_41720_() == this) {
            this.animateHands(model, entity, false);
            twoHanded.setTwoHanded(true);
            return true;
        }
        return false;
    }

    public <T extends LivingEntity> boolean poseLeftArm(ItemStack stack, HumanoidModel<T> model, T entity, HumanoidArm mainHand, DualWeildState twoHanded) {
        if (entity.m_21212_() > 0 && entity.m_21211_().m_41720_() == this) {
            this.animateHands(model, entity, true);
            twoHanded.setTwoHanded(true);
            return true;
        }
        return false;
    }

    private <T extends LivingEntity> void animateHands(HumanoidModel<T> model, T entity, boolean leftHand) {
        ModelPart mainHand = leftHand ? model.f_102812_ : model.f_102811_;
        ModelPart offHand = leftHand ? model.f_102811_ : model.f_102812_;
        Vec3 bx = new Vec3(1.0, 0.0, 0.0);
        Vec3 by = new Vec3(0.0, 1.0, 0.0);
        Vec3 bz = new Vec3(0.0, 0.0, 1.0);
        float headXRot = MthUtils.wrapRad((float)model.f_102808_.f_104203_);
        float headYRot = MthUtils.wrapRad((float)model.f_102808_.f_104204_);
        float downFacingRot = Mth.m_14036_((float)headXRot, (float)0.0f, (float)0.8f);
        float xRot = FluteItem.getMaxHeadXRot(headXRot) - (entity.m_6047_() ? 1.0f : 0.0f) - 0.3f + downFacingRot * 0.5f;
        bx = bx.m_82496_(xRot);
        by = by.m_82496_(xRot);
        bz = bz.m_82496_(xRot);
        Vec3 armVec = new Vec3(0.0, 0.0, 1.0);
        float mirror = leftHand ? -1.0f : 1.0f;
        armVec = armVec.m_82524_(-0.99f * mirror);
        Vec3 newV = bx.m_82490_(armVec.f_82479_).m_82549_(by.m_82490_(armVec.f_82480_)).m_82549_(bz.m_82490_(armVec.f_82481_));
        float yaw = (float)Math.atan2(-newV.f_82479_, newV.f_82481_);
        float len = (float)newV.m_82553_();
        float pitch = (float)Math.asin(newV.f_82480_ / (double)len);
        mainHand.f_104204_ = yaw + headYRot * 1.4f - 0.1f * mirror - 0.5f * downFacingRot * mirror;
        mainHand.f_104203_ = (float)((double)pitch - 1.5707963267948966);
        offHand.f_104204_ = (float)Mth.m_14008_((double)((double)(MthUtils.wrapRad((float)mainHand.f_104204_) - 1.0f * mirror) * 0.2), (double)-0.15, (double)0.15) + 1.1f * mirror;
        offHand.f_104203_ = MthUtils.wrapRad((float)(mainHand.f_104203_ - 0.06f));
        float offset = leftHand ? -Mth.m_14036_((float)headYRot, (float)-1.0f, (float)0.0f) : Mth.m_14036_((float)headYRot, (float)0.0f, (float)1.0f);
        mainHand.f_104202_ = -offset * 0.95f;
        AnimationUtils.m_170341_((ModelPart)model.f_102812_, (float)entity.f_19797_, (float)1.0f);
        AnimationUtils.m_170341_((ModelPart)model.f_102811_, (float)entity.f_19797_, (float)-1.0f);
    }

    public static float getMaxHeadXRot(float xRot) {
        return Mth.m_14036_((float)xRot, (float)-1.2566371f, (float)1.5707964f);
    }

    public <T extends Player, M extends EntityModel<T> & HeadedModel> void renderThirdPersonItem(M parentModel, LivingEntity entity, ItemStack stack, HumanoidArm humanoidArm, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        if (!stack.m_41619_()) {
            ItemTransforms.TransformType transform;
            boolean leftHand;
            poseStack.m_85836_();
            boolean bl = leftHand = humanoidArm == HumanoidArm.LEFT;
            if (entity.m_21211_() == stack) {
                ModelPart head = ((HeadedModel)parentModel).m_5585_();
                float oldRot = head.f_104203_;
                head.f_104203_ = FluteItem.getMaxHeadXRot(MthUtils.wrapRad((float)oldRot));
                head.m_104299_(poseStack);
                head.f_104203_ = oldRot;
                CustomHeadLayer.m_174483_((PoseStack)poseStack, (boolean)false);
                poseStack.m_85837_(0.0, -0.265625, -0.53125);
                if (leftHand) {
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                }
                transform = ItemTransforms.TransformType.HEAD;
            } else {
                ((ArmedModel)parentModel).m_6002_(humanoidArm, poseStack);
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                poseStack.m_85837_((double)((float)(leftHand ? -1 : 1) / 16.0f), 0.125, -0.625);
                transform = leftHand ? ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND : ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND;
            }
            Minecraft.m_91087_().m_91290_().m_234586_().m_109322_(entity, stack, transform, leftHand, poseStack, bufferSource, light);
            poseStack.m_85849_();
        }
    }
}

