/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.common.block.blocks.SpeakerBlock;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySpeakerMessagePacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class SpeakerBlockTile
extends BlockEntity
implements Nameable,
IOwnerProtected {
    private UUID owner = null;
    private String message = "";
    private Mode mode = Mode.CHAT;
    private double volume = CommonConfigs.Blocks.SPEAKER_RANGE.get().intValue();
    private Component customName;

    public SpeakerBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.SPEAKER_BLOCK_TILE.get(), pos, state);
    }

    public void setCustomName(Component name) {
        this.customName = name;
    }

    public Component m_7755_() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component m_7770_() {
        return this.customName;
    }

    public Component getDefaultName() {
        return Component.m_237115_((String)"block.supplementaries.speaker_block");
    }

    public double getVolume() {
        return this.volume;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setVolume(double volume) {
        this.volume = volume;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128425_("CustomName", 8)) {
            this.customName = Component.Serializer.m_130701_((String)compound.m_128461_("CustomName"));
        }
        this.message = compound.m_128461_("Message");
        Mode m = Mode.values()[compound.m_128451_("Mode")];
        if (m == Mode.NARRATOR && !CommonConfigs.Blocks.SPEAKER_NARRATOR.get().booleanValue()) {
            m = Mode.CHAT;
        }
        this.mode = m;
        this.volume = compound.m_128459_("Volume");
        this.loadOwner(compound);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (this.customName != null) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.customName));
        }
        compound.m_128359_("Message", this.message);
        compound.m_128405_("Mode", this.mode.ordinal());
        compound.m_128347_("Volume", this.volume);
        this.saveOwner(compound);
    }

    public void sendMessage() {
        BlockState state = this.m_58900_();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!this.message.equals("")) {
                BlockPos pos = this.m_58899_();
                this.f_58857_.m_7696_(pos, this.m_58900_().m_60734_(), 0, 0);
                Style style = (Boolean)state.m_61143_((Property)SpeakerBlock.ANTIQUE) == false ? Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.ITALIC}) : Style.f_131099_.m_131150_(ModTextures.ANTIQUABLE_FONT).m_131152_(new ChatFormatting[]{ChatFormatting.ITALIC});
                String name = this.m_7755_().getString();
                Object s = "";
                if (name.isEmpty()) {
                    s = "Speaker Block: ";
                } else if (!name.equals("\"\"") && !name.equals("\"")) {
                    s = (String)s + name + ": ";
                }
                MutableComponent component = Component.m_237113_((String)((String)s + this.message)).m_130948_(style);
                NetworkHandler.CHANNEL.sendToAllClientPlayersInRange((Level)server, pos, this.volume, (Message)new ClientBoundPlaySpeakerMessagePacket((Component)component, this.mode));
            }
        }
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static enum Mode {
        CHAT,
        STATUS_MESSAGE,
        TITLE,
        NARRATOR;

    }
}

