/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.mehvahdjukaar.supplementaries.client.ModMaterials;
import net.mehvahdjukaar.supplementaries.client.renderers.VertexUtils;
import net.mehvahdjukaar.supplementaries.common.block.tiles.FlagBlockTile;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;

public class FlagBlockTileRenderer
implements BlockEntityRenderer<FlagBlockTile> {
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final ModelPart flag;

    public FlagBlockTileRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.m_173582_(ModelLayers.f_171264_);
        this.flag = modelpart.m_171324_("flag");
    }

    public int m_142163_() {
        return 128;
    }

    private void renderBanner(float ang, PoseStack matrixStack, MultiBufferSource bufferSource, int light, int pPackedOverlay, List<Pair<Holder<BannerPattern>, DyeColor>> list) {
        matrixStack.m_85836_();
        matrixStack.m_85841_(0.6666667f, -0.6666667f, -0.6666667f);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(0.05f * ang));
        this.flag.f_104203_ = 1.5707964f;
        this.flag.f_104204_ = (float)Math.PI;
        this.flag.f_104205_ = 1.5707964f;
        this.flag.f_104201_ = -12.0f;
        this.flag.f_104200_ = 1.5f;
        BannerRenderer.m_112065_((PoseStack)matrixStack, (MultiBufferSource)bufferSource, (int)light, (int)pPackedOverlay, (ModelPart)this.flag, (Material)ModelBakery.f_119224_, (boolean)true, list);
        matrixStack.m_85849_();
    }

    public void render(FlagBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        List<Pair<Holder<BannerPattern>, DyeColor>> list = tile.getPatterns();
        if (list != null) {
            int lu = combinedLightIn & 0xFFFF;
            int lv = combinedLightIn >> 16 & 0xFFFF;
            int w = 24;
            int h = 16;
            matrixStackIn.m_85836_();
            matrixStackIn.m_85837_(0.5, 0.0, 0.5);
            matrixStackIn.m_85845_(RotHlpr.rot((Direction)tile.getDirection()));
            matrixStackIn.m_85845_(RotHlpr.XN90);
            matrixStackIn.m_85837_(0.0, 0.0, 0.0625);
            long time = tile.m_58904_().m_46467_();
            double l = ClientConfigs.Blocks.FLAG_WAVELENGTH.get();
            long period = ClientConfigs.Blocks.FLAG_PERIOD.get().intValue();
            double wavyness = ClientConfigs.Blocks.FLAG_AMPLITUDE.get();
            double invdamping = ClientConfigs.Blocks.FLAG_AMPLITUDE_INCREMENT.get();
            BlockPos bp = tile.m_58899_();
            float t = ((float)Math.floorMod((long)bp.m_123341_() * 7L + (long)bp.m_123343_() * 13L + time, period) + partialTicks) / (float)period;
            if (ClientConfigs.Blocks.FLAG_BANNER.get().booleanValue()) {
                float ang = (float)((wavyness + invdamping * (double)w) * (double)Mth.m_14031_((float)((float)((double)w / l - (double)(t * 2.0f * (float)Math.PI)))));
                this.renderBanner(ang, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, list);
            } else {
                int segmentLen = ((GraphicsStatus)this.minecraft.f_91066_.m_232060_().m_231551_()).m_35965_() >= ClientConfigs.Blocks.FLAG_FANCINESS.get().ordinal() ? 1 : w;
                for (int dX = 0; dX < w; dX += segmentLen) {
                    float ang = (float)((wavyness + invdamping * (double)dX) * (double)Mth.m_14031_((float)((float)((double)dX / l - (double)(t * 2.0f * (float)Math.PI)))));
                    FlagBlockTileRenderer.renderPatterns(bufferIn, matrixStackIn, list, lu, lv, dX, w, h, segmentLen, ang);
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(ang));
                    matrixStackIn.m_85837_(0.0, 0.0, (double)((float)segmentLen / 16.0f));
                    matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(-ang));
                }
            }
            matrixStackIn.m_85849_();
        }
    }

    public static void renderPatterns(PoseStack matrixStackIn, MultiBufferSource bufferIn, List<Pair<Holder<BannerPattern>, DyeColor>> list, int combinedLightIn) {
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        FlagBlockTileRenderer.renderPatterns(bufferIn, matrixStackIn, list, lu, lv, 0, 24, 16, 24, 0.0f);
    }

    private static void renderPatterns(MultiBufferSource bufferIn, PoseStack matrixStackIn, List<Pair<Holder<BannerPattern>, DyeColor>> list, int lu, int lv, int dX, int w, int h, int segmentlen, float ang) {
        for (int p = 0; p < list.size(); ++p) {
            Material material = ModMaterials.FLAG_MATERIALS.get().get(((Holder)list.get(p).getFirst()).m_203334_());
            if (material == null) continue;
            VertexConsumer builder = material.m_119194_(bufferIn, p == 0 ? RenderType::m_110446_ : RenderType::m_110482_);
            matrixStackIn.m_85836_();
            float[] color = ((DyeColor)list.get(p).getSecond()).m_41068_();
            float b = color[2];
            float g = color[1];
            float r = color[0];
            FlagBlockTileRenderer.renderCurvedSegment(builder, material.m_119204_(), matrixStackIn, ang, dX, segmentlen, h, lu, lv, dX + segmentlen >= w, r, g, b);
            matrixStackIn.m_85849_();
        }
    }

    private static void renderCurvedSegment(VertexConsumer builder, TextureAtlasSprite sprite, PoseStack matrixStack, float angle, int dX, int length, int height, int lu, int lv, boolean end, float r, float g, float b) {
        float textW = 32.0f;
        float textH = 16.0f;
        float u = (float)dX / textW;
        float v = 0.0f;
        float maxV = v + (float)height / textH;
        float maxU = u + (float)length / textW;
        float w = 0.0625f;
        float hw = w / 2.0f;
        float l = (float)length / 16.0f;
        float h = (float)height / 16.0f;
        float pU = VertexUtils.getRelativeU(sprite, maxU - 1.0f / textW);
        float pV = VertexUtils.getRelativeV(sprite, maxV - w);
        float pV2 = VertexUtils.getRelativeV(sprite, w);
        maxU = VertexUtils.getRelativeU(sprite, maxU);
        u = VertexUtils.getRelativeU(sprite, u);
        maxV = VertexUtils.getRelativeV(sprite, maxV);
        v = VertexUtils.getRelativeV(sprite, v);
        Quaternion rotation = Vector3f.f_122225_.m_122240_(angle);
        Quaternion rotation2 = Vector3f.f_122225_.m_122240_(-angle);
        int nx = 1;
        boolean nz = false;
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)hw, 0.0, 0.0);
        VertexUtils.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, u, maxV, r, g, b, 1.0f, lu, lv, nx, 0.0f, (float)nz);
        VertexUtils.addVert(builder, matrixStack, 0.0f, h, 0.0f, u, v, r, g, b, 1.0f, lu, lv, nx, 0.0f, (float)nz);
        matrixStack.m_85845_(rotation);
        matrixStack.m_85837_(0.0, 0.0, (double)l);
        VertexUtils.addVert(builder, matrixStack, 0.0f, h, 0.0f, maxU, v, r, g, b, 1.0f, lu, lv, nx, 0.0f, (float)nz);
        VertexUtils.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, maxU, maxV, r, g, b, 1.0f, lu, lv, nx, 0.0f, (float)nz);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(-hw), 0.0, 0.0);
        VertexUtils.addVert(builder, matrixStack, 0.0f, h, 0.0f, u, v, r, g, b, 1.0f, lu, lv, -nx, 0.0f, (float)nz);
        VertexUtils.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, u, maxV, r, g, b, 1.0f, lu, lv, -nx, 0.0f, (float)nz);
        matrixStack.m_85845_(rotation);
        matrixStack.m_85837_(0.0, 0.0, (double)l);
        VertexUtils.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, maxU, maxV, r, g, b, 1.0f, lu, lv, -nx, 0.0f, (float)nz);
        VertexUtils.addVert(builder, matrixStack, 0.0f, h, 0.0f, maxU, v, r, g, b, 1.0f, lu, lv, -nx, 0.0f, (float)nz);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)hw, 0.0, 0.0);
        VertexUtils.addVert(builder, matrixStack, 0.0f, h, 0.0f, u, v, r, g, b, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStack.m_85837_((double)(-w), 0.0, 0.0);
        VertexUtils.addVert(builder, matrixStack, 0.0f, h, 0.0f, u, pV2, r, g, b, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStack.m_85845_(rotation);
        matrixStack.m_85837_(0.0, 0.0, (double)l);
        VertexUtils.addVert(builder, matrixStack, 0.0f, h, 0.0f, maxU, pV2, r, g, b, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStack.m_85845_(rotation2);
        matrixStack.m_85837_((double)w, 0.0, 0.0);
        VertexUtils.addVert(builder, matrixStack, 0.0f, h, 0.0f, maxU, v, r, g, b, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)(-hw), 0.0, 0.0);
        VertexUtils.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, u, pV, r, g, b, 1.0f, lu, lv, 0.0f, -1.0f, 0.0f);
        matrixStack.m_85837_((double)w, 0.0, 0.0);
        VertexUtils.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, u, maxV, r, g, b, 1.0f, lu, lv, 0.0f, -1.0f, 0.0f);
        matrixStack.m_85845_(rotation);
        matrixStack.m_85837_(0.0, 0.0, (double)l);
        VertexUtils.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, maxU, maxV, r, g, b, 1.0f, lu, lv, 0.0f, -1.0f, 0.0f);
        matrixStack.m_85845_(rotation2);
        matrixStack.m_85837_((double)(-w), 0.0, 0.0);
        VertexUtils.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, maxU, pV, r, g, b, 1.0f, lu, lv, 0.0f, -1.0f, 0.0f);
        matrixStack.m_85849_();
        if (end) {
            matrixStack.m_85836_();
            matrixStack.m_85845_(rotation);
            matrixStack.m_85837_(0.0, 0.0, (double)l);
            matrixStack.m_85845_(rotation2);
            matrixStack.m_85837_((double)(-hw), 0.0, 0.0);
            VertexUtils.addVert(builder, matrixStack, 0.0f, h, 0.0f, pU, v, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            VertexUtils.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, pU, maxV, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            matrixStack.m_85837_((double)w, 0.0, 0.0);
            VertexUtils.addVert(builder, matrixStack, 0.0f, 0.0f, 0.0f, maxU, maxV, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            VertexUtils.addVert(builder, matrixStack, 0.0f, h, 0.0f, maxU, v, r, g, b, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            matrixStack.m_85849_();
        }
    }
}

