/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import virtuoel.no_fog.NoFogClient;
import virtuoel.no_fog.util.VersionUtils;

public class ReflectionUtils {
    public static final MethodHandle FOG_DENSITY;
    public static final MethodHandle FOG_START;
    public static final MethodHandle FOG_END;
    public static final ReflectionUtils INSTANCE;

    public static void setFogDensity(float f) throws Throwable {
        if (FOG_DENSITY != null) {
            FOG_DENSITY.invokeExact(f);
        }
    }

    public static void setFogStart(float f) throws Throwable {
        if (FOG_START != null) {
            FOG_START.invokeExact(f);
        }
    }

    public static void setFogEnd(float f) throws Throwable {
        if (FOG_END != null) {
            FOG_END.invokeExact(f);
        }
    }

    public static <T> T getFieldValue(Field field, Object object, Supplier<T> defaultValue) {
        try {
            return (T)field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return defaultValue.get();
        }
    }

    private ReflectionUtils() {
    }

    static {
        Int2ObjectArrayMap h = new Int2ObjectArrayMap();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        String mapped = "unset";
        try {
            boolean is116;
            boolean bl = is116 = VersionUtils.MINOR == 16;
            if (is116) {
                Class<?> clazz = Class.forName("com.mojang.blaze3d.systems.RenderSystem");
                Method m = clazz.getMethod("fogDensity", Float.TYPE);
                h.put(0, (Object)lookup.unreflect(m));
                m = clazz.getMethod("fogStart", Float.TYPE);
                h.put(1, (Object)lookup.unreflect(m));
                m = clazz.getMethod("fogEnd", Float.TYPE);
                h.put(2, (Object)lookup.unreflect(m));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException e1) {
            NoFogClient.LOGGER.error("Last method lookup: {}", (Object)mapped);
            NoFogClient.LOGGER.catching((Throwable)e1);
        }
        FOG_DENSITY = (MethodHandle)h.get(0);
        FOG_START = (MethodHandle)h.get(1);
        FOG_END = (MethodHandle)h.get(2);
        INSTANCE = new ReflectionUtils();
    }
}

