/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.no_fog.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.gui.registry.GuiRegistry;
import me.shedaniel.autoconfig.gui.registry.api.GuiRegistryAccess;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.gui.entries.SubCategoryListEntry;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModLoadingContext;
import virtuoel.no_fog.api.NoFogConfig;
import virtuoel.no_fog.util.FogToggles;
import virtuoel.no_fog.util.I18nUtils;
import virtuoel.no_fog.util.NoFogConfigImpl;
import virtuoel.no_fog.util.ReflectionUtils;
import virtuoel.no_fog.util.TriState;
import virtuoel.no_fog.util.VersionUtils;

public class AutoConfigUtils {
    public static final Supplier<NoFogConfig> CONFIG = () -> (NoFogConfig)AutoConfig.getConfigHolder(NoFogConfigImpl.class).getConfig();
    private static final ConfigEntryBuilder ENTRY_BUILDER = ConfigEntryBuilder.create();

    public static void initialize() {
        AutoConfig.register(NoFogConfigImpl.class, GsonConfigSerializer::new);
        GuiRegistry registry = AutoConfig.getGuiRegistry(NoFogConfigImpl.class);
        registry.registerPredicateProvider(AutoConfigUtils::globalToggleEntry, f -> f.getName().equals("globalToggles"));
        registry.registerPredicateProvider(AutoConfigUtils::dimensionToggleMapEntries, f -> f.getName().equals("dimensionToggles"));
        registry.registerPredicateProvider(AutoConfigUtils::biomeToggleMapEntries, f -> f.getName().equals("biomeToggles"));
        AutoConfigUtils.registerConfigScreenFactoryExtensionPoint();
    }

    private static void registerConfigScreenFactoryExtensionPoint() {
        Class<?> c;
        BiFunction<Minecraft, Screen, Screen> screenFunction = (mc, screen) -> (Screen)AutoConfig.getConfigScreen(NoFogConfigImpl.class, (Screen)screen).get();
        try {
            c = Class.forName("net.minecraftforge.client.ConfigScreenHandler$ConfigScreenFactory");
        }
        catch (ClassNotFoundException e) {
            try {
                c = Class.forName("net.minecraftforge.client.ConfigGuiHandler$ConfigGuiFactory");
            }
            catch (ClassNotFoundException e1) {
                e1.printStackTrace();
                return;
            }
        }
        Class<?> clazz = c;
        try {
            ModLoadingContext.class.getMethod("registerExtensionPoint", Class.class, Supplier.class).invoke((Object)ModLoadingContext.get(), clazz, () -> {
                try {
                    return clazz.cast(clazz.getConstructor(BiFunction.class).newInstance(screenFunction));
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            });
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static List<AbstractConfigListEntry> globalToggleEntry(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
        try {
            LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
            entries.add((AbstractConfigListEntry)ENTRY_BUILDER.startSubCategory(I18nUtils.translate("text.no_fog.config.category.global", "Global settings"), AutoConfigUtils.addToggleEntries((FogToggles)field.get(config))).build());
            return entries;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            return new LinkedList<AbstractConfigListEntry>();
        }
    }

    private static List<AbstractConfigListEntry> dimensionToggleMapEntries(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
        Map data = ReflectionUtils.getFieldValue(field, config, HashMap::new);
        LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
        LinkedList<SubCategoryListEntry> dimensionEntries = new LinkedList<SubCategoryListEntry>();
        Minecraft client = Minecraft.m_91087_();
        List<String> ids = Arrays.asList(Level.f_46428_.m_135782_().toString(), Level.f_46429_.m_135782_().toString(), Level.f_46430_.m_135782_().toString());
        if (client != null && client.f_91073_ != null) {
            Registry dimensionRegistry = client.f_91073_.m_5962_().m_175515_(Registry.f_122818_);
            ids = dimensionRegistry.m_6566_().stream().map(ResourceLocation::toString).collect(Collectors.toList());
        }
        for (String id : ids) {
            data.computeIfAbsent(id, xva$0 -> new FogToggles(xva$0));
            dimensionEntries.add(ENTRY_BUILDER.startSubCategory(I18nUtils.literal(id, new Object[0]), AutoConfigUtils.addToggleEntries((FogToggles)data.get(id))).build());
        }
        entries.add((AbstractConfigListEntry)ENTRY_BUILDER.startSubCategory(I18nUtils.translate("text.no_fog.config.category.dimensions", "Dimension Type settings"), dimensionEntries).build());
        return entries;
    }

    private static List<AbstractConfigListEntry> biomeToggleMapEntries(String i13n, Field field, Object config, Object defaults, GuiRegistryAccess registry) {
        Map data = ReflectionUtils.getFieldValue(field, config, HashMap::new);
        LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
        LinkedList<SubCategoryListEntry> biomeEntries = new LinkedList<SubCategoryListEntry>();
        Minecraft client = Minecraft.m_91087_();
        Registry biomeRegistry = BuiltinRegistries.f_123865_;
        if (client != null && client.f_91073_ != null) {
            biomeRegistry = client.f_91073_.m_5962_().m_175515_(Registry.f_122885_);
        }
        List ids = biomeRegistry.m_6566_().stream().collect(Collectors.toList());
        Collections.sort(ids, (l, r) -> I18n.m_118938_((String)Util.m_137492_((String)"biome", (ResourceLocation)l), (Object[])new Object[0]).compareTo(I18n.m_118938_((String)Util.m_137492_((String)"biome", (ResourceLocation)r), (Object[])new Object[0])));
        for (ResourceLocation id : ids) {
            String idStr = id.toString();
            data.computeIfAbsent(idStr, xva$0 -> new FogToggles(xva$0));
            biomeEntries.add(ENTRY_BUILDER.startSubCategory(I18nUtils.translate(Util.m_137492_((String)"biome", (ResourceLocation)id), Util.m_137492_((String)"biome", (ResourceLocation)id)), AutoConfigUtils.addToggleEntries((FogToggles)data.get(idStr))).setTooltip(new Component[]{I18nUtils.literal(idStr, new Object[0])}).build());
        }
        entries.add((AbstractConfigListEntry)ENTRY_BUILDER.startSubCategory(I18nUtils.translate("text.no_fog.config.category.biomes", "Biome settings"), biomeEntries).build());
        return entries;
    }

    private static List<AbstractConfigListEntry> addToggleEntries(FogToggles data) {
        LinkedList<AbstractConfigListEntry> entries = new LinkedList<AbstractConfigListEntry>();
        String enabledKey = "text.no_fog.config.default.enabled";
        String enabledDefault = "Default: enabled";
        String disabledKey = "text.no_fog.config.default.disabled";
        String disabledDefault = "Default: disabled";
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.sky_fog", data.skyFog, newValue -> {
            data.skyFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.enabled", "Default: enabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.terrain_fog", data.terrainFog, newValue -> {
            data.terrainFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.thick_fog", data.thickFog, newValue -> {
            data.thickFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.thick_fog.tooltip", "Enable thick fog"), I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.water_fog", data.waterFog, newValue -> {
            data.waterFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.lava_fog", data.lavaFog, newValue -> {
            data.lavaFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        if (VersionUtils.MINOR >= 17) {
            entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.powder_snow_fog", data.powderSnowFog, newValue -> {
                data.powderSnowFog = newValue;
            }, I18nUtils.translate("text.no_fog.config.default.disabled", "Default: disabled")));
        }
        entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.blindness_fog", data.blindnessFog, newValue -> {
            data.blindnessFog = newValue;
        }, I18nUtils.translate("text.no_fog.config.default.enabled", "Default: enabled")));
        if (VersionUtils.MINOR >= 19) {
            entries.add((AbstractConfigListEntry)AutoConfigUtils.triStateEntry("text.no_fog.config.darkness_fog", data.darknessFog, newValue -> {
                data.darknessFog = newValue;
            }, I18nUtils.translate("text.no_fog.config.default.enabled", "Default: enabled")));
        }
        return entries;
    }

    private static EnumListEntry<TriState> triStateEntry(String key, TriState value, Consumer<TriState> saveConsumer, Component ... tooltip) {
        return ENTRY_BUILDER.startEnumSelector(I18nUtils.translate(key, key), TriState.class, (Enum)(value != null ? value : TriState.DEFAULT)).setDefaultValue((Enum)TriState.DEFAULT).setSaveConsumer(saveConsumer).setTooltip(tooltip).build();
    }
}

