/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.fml.loading.FMLEnvironment;
import twilightforest.command.TFCommand;
import twilightforest.init.BiomeKeys;
import twilightforest.item.MagicMapItem;
import twilightforest.util.ColorUtil;
import twilightforest.world.registration.TFGenerationSettings;

public class MapBiomesCommand {
    private static final DecimalFormat numberFormat = new DecimalFormat("#.00");
    private static final HashMap<ResourceLocation, MapColor> BIOME2COLOR = new HashMap();

    private static void init() {
        BIOME2COLOR.put(BiomeKeys.STREAM.m_135782_(), new MapColor(0, 0, 255));
        BIOME2COLOR.put(BiomeKeys.LAKE.m_135782_(), new MapColor(0, 0, 255));
        BIOME2COLOR.put(BiomeKeys.CLEARING.m_135782_(), new MapColor(132, 245, 130));
        BIOME2COLOR.put(BiomeKeys.OAK_SAVANNAH.m_135782_(), new MapColor(239, 245, 130));
        BIOME2COLOR.put(BiomeKeys.FOREST.m_135782_(), new MapColor(0, 255, 0));
        BIOME2COLOR.put(BiomeKeys.DENSE_FOREST.m_135782_(), new MapColor(0, 170, 0));
        BIOME2COLOR.put(BiomeKeys.FIREFLY_FOREST.m_135782_(), new MapColor(88, 252, 102));
        BIOME2COLOR.put(BiomeKeys.ENCHANTED_FOREST.m_135782_(), new MapColor(0, 255, 255));
        BIOME2COLOR.put(BiomeKeys.SPOOKY_FOREST.m_135782_(), new MapColor(119, 0, 255));
        BIOME2COLOR.put(BiomeKeys.MUSHROOM_FOREST.m_135782_(), new MapColor(204, 0, 139));
        BIOME2COLOR.put(BiomeKeys.DENSE_MUSHROOM_FOREST.m_135782_(), new MapColor(184, 48, 184));
        BIOME2COLOR.put(BiomeKeys.SWAMP.m_135782_(), new MapColor(0, 204, 187));
        BIOME2COLOR.put(BiomeKeys.FIRE_SWAMP.m_135782_(), new MapColor(140, 0, 0));
        BIOME2COLOR.put(BiomeKeys.DARK_FOREST.m_135782_(), new MapColor(25, 61, 13));
        BIOME2COLOR.put(BiomeKeys.DARK_FOREST_CENTER.m_135782_(), new MapColor(157, 79, 0));
        BIOME2COLOR.put(BiomeKeys.SNOWY_FOREST.m_135782_(), new MapColor(255, 255, 255));
        BIOME2COLOR.put(BiomeKeys.GLACIER.m_135782_(), new MapColor(130, 191, 245));
        BIOME2COLOR.put(BiomeKeys.HIGHLANDS.m_135782_(), new MapColor(100, 65, 0));
        BIOME2COLOR.put(BiomeKeys.THORNLANDS.m_135782_(), new MapColor(128, 100, 90));
        BIOME2COLOR.put(BiomeKeys.FINAL_PLATEAU.m_135782_(), new MapColor(128, 128, 128));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"biomepng").requires(cs -> cs.m_6761_(2))).executes(context -> MapBiomesCommand.createMap((CommandSourceStack)context.getSource(), 4096, 4096, true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"width", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> MapBiomesCommand.createMap((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), true))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"height", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> MapBiomesCommand.createMap((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"height"), true))).then(Commands.m_82129_((String)"showBiomePercents", (ArgumentType)BoolArgumentType.bool()).executes(context -> MapBiomesCommand.createMap((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"width"), IntegerArgumentType.getInteger((CommandContext)context, (String)"height"), BoolArgumentType.getBool((CommandContext)context, (String)"showBiomePercents"))))));
    }

    private static int createMap(CommandSourceStack source, int width, int height, boolean showBiomePercents) throws CommandSyntaxException {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return -1;
        }
        if (!TFGenerationSettings.usesTwilightChunkGenerator(source.m_81372_())) {
            throw TFCommand.NOT_IN_TF.create();
        }
        if (BIOME2COLOR.isEmpty()) {
            MapBiomesCommand.init();
        }
        HashMap<Biome, Integer> biomeCount = new HashMap<Biome, Integer>();
        NativeImage img = new NativeImage(width, height, false);
        int progressUpdate = img.m_85084_() / 8;
        for (int x = 0; x < img.m_85084_(); ++x) {
            for (int z = 0; z < img.m_84982_(); ++z) {
                ServerLevel level = source.m_81372_();
                Biome b = (Biome)level.m_203495_(x - img.m_84982_() / 2, 0, z - img.m_85084_() / 2).m_203334_();
                ResourceLocation key = level.m_5962_().m_206191_(Registry.f_122885_).m_7981_((Object)b);
                MapColor color = BIOME2COLOR.get(key);
                if (color == null) {
                    int colorInt = MagicMapItem.getBiomeColor((Level)source.m_81372_(), b);
                    if (colorInt == 0) {
                        colorInt = b.m_47464_(0.0, 0.0);
                    }
                    color = new MapColor(colorInt | 0xFF000000);
                    BIOME2COLOR.put(key, color);
                }
                if (!biomeCount.containsKey(b)) {
                    biomeCount.put(b, 0);
                } else {
                    biomeCount.put(b, (Integer)biomeCount.get(b) + 1);
                }
                img.m_84988_(x, z, ColorUtil.argbToABGR(color.getARGB()));
            }
            if (x % progressUpdate != 0) continue;
            source.m_81354_((Component)Component.m_237115_((String)((double)x / (double)img.m_85084_() * 100.0 + "% Done mapping")), false);
        }
        if (showBiomePercents) {
            source.m_81354_((Component)Component.m_237113_((String)("Approximate biome-block counts within a " + width + "x" + height + " region")), false);
            int totalCount = biomeCount.values().stream().mapToInt(i -> i).sum();
            biomeCount.forEach((biome, integer) -> source.m_81354_((Component)Component.m_237113_((String)source.m_81372_().m_5962_().m_206191_(Registry.f_122885_).m_7981_(biome).toString()).m_130946_(": " + integer + ChatFormatting.GRAY + " (" + numberFormat.format((double)integer.intValue() / (double)totalCount * 100.0) + "%)"), false));
        }
        int startX = Mth.m_14107_((double)source.m_81371_().m_7096_()) - img.m_84982_() / 2;
        int startZ = Mth.m_14107_((double)source.m_81371_().m_7094_()) - img.m_85084_() / 2;
        Path p = Paths.get("biome_map-" + source.m_81372_().m_7328_() + "-(" + startX + "." + startZ + ")-(" + (startX + width) + "." + (startZ + height) + ").png", new String[0]);
        try {
            img.m_85056_(p.toAbsolutePath().toFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            source.m_81352_((Component)Component.m_237113_((String)"Could not save image! Please report this!"));
            return 0;
        }
        source.m_81354_((Component)Component.m_237113_((String)"Image saved!"), false);
        return 1;
    }

    public static class MapColor {
        private final int value;

        public MapColor(int r, int g, int b) {
            this(r, g, b, 255);
        }

        public MapColor(int r, int g, int b, int a) {
            this.value = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }

        public MapColor(int rgb) {
            this.value = 0xFF000000 | rgb;
        }

        public int getARGB() {
            return this.value;
        }
    }
}

