/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.entity.passive.QuestRam;

@OnlyIn(value=Dist.CLIENT)
public class QuestRamModel
extends QuadrupedModel<QuestRam> {
    public final ModelPart horns;
    public ModelPart backtorso;
    public ModelPart frontTorso;
    public ModelPart[] segments = new ModelPart[16];
    int[] colorOrder = new int[]{0, 8, 7, 15, 14, 1, 4, 5, 13, 3, 9, 11, 10, 2, 6, 12};

    public QuestRamModel(ModelPart root) {
        super(root, false, 4.0f, 4.0f, 2.0f, 2.0f, 24);
        this.horns = root.m_171324_("horns");
        this.backtorso = root.m_171324_("back_torso");
        this.frontTorso = root.m_171324_("front_torso");
        for (int i = 0; i < 16; ++i) {
            this.segments[i] = this.frontTorso.m_171324_("segment_" + i);
        }
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = QuadrupedModel.m_170864_((int)16, (CubeDeformation)CubeDeformation.f_171458_);
        PartDefinition partRoot = mesh.m_171576_();
        PartDefinition horns = partRoot.m_171599_("horns", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171481_(-9.0f, -11.0f, -1.0f, 4.0f, 10.0f, 10.0f).m_171514_(48, 0).m_171481_(-13.0f, -11.0f, 5.0f, 4.0f, 4.0f, 4.0f).m_171514_(92, 0).m_171481_(5.0f, -11.0f, -1.0f, 4.0f, 10.0f, 10.0f).m_171514_(110, 0).m_171481_(9.0f, -11.0f, 5.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)-10.0f, (float)-8.0f));
        horns.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(74, 70).m_171481_(-6.0f, -2.0f, -13.0f, 12.0f, 8.0f, 15.0f).m_171514_(42, 71).m_171481_(-6.0f, -5.0f, -9.0f, 12.0f, 3.0f, 11.0f), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)3.0f, (float)0.43633232f, (float)0.0f, (float)0.0f));
        PartDefinition frontTorso = partRoot.m_171599_("front_torso", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-8.0f, -7.0f, -6.0f, 16.0f, 14.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        frontTorso.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(84, 93).m_171481_(-5.0f, -11.0f, -2.0f, 10.0f, 12.0f, 12.0f), PartPose.m_171423_((float)0.0f, (float)2.0f, (float)-3.0f, (float)0.61086524f, (float)0.0f, (float)0.0f));
        partRoot.m_171599_("back_torso", CubeListBuilder.m_171558_().m_171514_(0, 30).m_171481_(-8.0f, -7.0f, 8.0f, 16.0f, 14.0f, 16.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)6.0f));
        partRoot.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 60).m_171481_(-3.0f, 2.0f, -3.0f, 6.0f, 16.0f, 6.0f).m_171514_(54, 20).m_171481_(-4.0f, -4.0f, -5.0f, 8.0f, 10.0f, 10.0f), PartPose.m_171419_((float)-5.0f, (float)6.0f, (float)0.0f));
        partRoot.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(24, 60).m_171481_(-3.0f, 2.0f, -3.0f, 6.0f, 16.0f, 6.0f).m_171514_(90, 20).m_171481_(-4.0f, -4.0f, -5.0f, 8.0f, 10.0f, 10.0f), PartPose.m_171419_((float)5.0f, (float)6.0f, (float)0.0f));
        partRoot.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 82).m_171481_(7.0f, 2.0f, -5.0f, 6.0f, 16.0f, 6.0f).m_171514_(54, 50).m_171481_(6.0f, -4.0f, -7.0f, 8.0f, 10.0f, 10.0f), PartPose.m_171419_((float)-16.0f, (float)6.0f, (float)0.0f));
        partRoot.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(24, 82).m_171481_(-13.0f, 2.0f, -5.0f, 6.0f, 16.0f, 6.0f).m_171514_(90, 50).m_171481_(-14.0f, -4.0f, -7.0f, 8.0f, 10.0f, 10.0f), PartPose.m_171419_((float)16.0f, (float)6.0f, (float)0.0f));
        for (int i = 0; i < 16; ++i) {
            frontTorso.m_171599_("segment_" + i, CubeListBuilder.m_171558_().m_171514_(0, 112).m_171481_(-8.0f, -7.0f, 8.0f, 16.0f, 14.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)10.0f));
        }
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)128);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.horns);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.horns, (Object)this.frontTorso, (Object)this.backtorso, (Object)this.f_170854_, (Object)this.f_170855_, (Object)this.f_170852_, (Object)this.f_170853_);
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int light, int overlay, float red, float green, float blue, float alpha) {
        super.m_7695_(stack, builder, light, overlay, red, green, blue, alpha);
        for (int i = 0; i < 16; ++i) {
            float[] dyeRgb = Sheep.m_29829_((DyeColor)DyeColor.m_41053_((int)i));
            this.segments[i].m_104306_(stack, builder, light, overlay, dyeRgb[0], dyeRgb[1], dyeRgb[2], alpha);
        }
    }

    public void setupAnim(QuestRam entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.horns.f_104203_ = headPitch / 57.295776f;
        this.horns.f_104204_ = netHeadYaw / 57.295776f;
        this.f_170853_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.f_170852_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.f_170855_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.f_170854_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
    }

    public void prepareMobModel(QuestRam entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        int count = entity.countColorsSet();
        this.backtorso.f_104202_ = 2 + 2 * count;
        this.f_170853_.f_104202_ = 25 + 2 * count;
        this.f_170852_.f_104202_ = 25 + 2 * count;
        int segmentOffset = 2;
        for (int color : this.colorOrder) {
            if (entity.isColorPresent(DyeColor.m_41053_((int)color))) {
                this.segments[color].f_104207_ = true;
                this.segments[color].f_104202_ = segmentOffset;
                segmentOffset += 2;
                continue;
            }
            this.segments[color].f_104207_ = false;
        }
    }
}

