/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import org.jetbrains.annotations.Nullable;
import twilightforest.init.TFBlockEntities;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFSounds;

@OnlyIn(value=Dist.CLIENT, _interface=LidBlockEntity.class)
public class KeepsakeCasketBlockEntity
extends RandomizableContainerBlockEntity
implements LidBlockEntity {
    private static final int limit = 45;
    public NonNullList<ItemStack> contents = NonNullList.m_122780_((int)45, (Object)ItemStack.f_41583_);
    @Nullable
    public String f_58622_;
    @Nullable
    public String casketname;
    @Nullable
    public UUID playeruuid;
    protected float lidAngle;
    protected float prevLidAngle;
    protected int numPlayersUsing;
    private int ticksSinceSync;

    public KeepsakeCasketBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TFBlockEntities.KEEPSAKE_CASKET.get(), pos, state);
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public NonNullList<ItemStack> m_7086_() {
        return this.contents;
    }

    public void m_6520_(NonNullList<ItemStack> items) {
        int limit = Math.min(this.contents.size(), items.size());
        for (int i = 0; i < limit; ++i) {
            ItemStack stack = (ItemStack)items.get(i);
            if (stack == null) continue;
            this.contents.set(i, (Object)((ItemStack)items.get(i)));
            items.set(i, (Object)ItemStack.f_41583_);
        }
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"block.twilightforest.keepsake_casket");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return new ChestMenu(MenuType.f_39961_, id, player, (Container)this, 5);
    }

    public int m_6643_() {
        return 45;
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        if (!this.m_59634_(compound)) {
            ContainerHelper.m_18973_((CompoundTag)compound, this.contents);
        }
        if (this.playeruuid != null) {
            compound.m_128362_("deadPlayer", this.playeruuid);
        }
        if (this.casketname != null) {
            compound.m_128359_("playerName", this.casketname);
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.contents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(nbt)) {
            ContainerHelper.m_18980_((CompoundTag)nbt, this.contents);
        }
        if (nbt.m_128403_("deadPlayer")) {
            this.playeruuid = nbt.m_128342_("deadPlayer");
        }
        if (nbt.m_128403_("playerName")) {
            this.casketname = nbt.m_128461_("playerName");
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, KeepsakeCasketBlockEntity te) {
        if (++te.ticksSinceSync % 20 * 4 == 0) {
            level.m_7696_(pos, (Block)TFBlocks.KEEPSAKE_CASKET.get(), 1, te.numPlayersUsing);
        }
        te.prevLidAngle = te.lidAngle;
        if (te.numPlayersUsing > 0 && te.lidAngle == 0.0f) {
            level.m_5594_(null, pos, (SoundEvent)TFSounds.CASKET_OPEN.get(), SoundSource.BLOCKS, 0.5f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
        }
        if (te.numPlayersUsing == 0 && te.lidAngle > 0.0f || te.numPlayersUsing > 0 && te.lidAngle < 1.0f) {
            float f2 = te.lidAngle;
            te.lidAngle = te.numPlayersUsing > 0 ? (te.lidAngle += 0.025f) : (te.lidAngle -= 0.075f);
            if (te.lidAngle > 1.0f) {
                te.lidAngle = 1.0f;
            }
            if (te.lidAngle < 0.4f && f2 >= 0.4f) {
                level.m_5594_(null, pos, (SoundEvent)TFSounds.CASKET_CLOSE.get(), SoundSource.BLOCKS, 0.75f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
            }
            if (te.lidAngle < 0.0f) {
                te.lidAngle = 0.0f;
            }
        }
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.m_7531_(id, type);
    }

    public boolean m_6542_(Player user) {
        if (this.playeruuid != null) {
            if (user.m_20310_(3) || user.m_36316_().getId().equals(this.playeruuid)) {
                return super.m_6542_(user);
            }
            return false;
        }
        return super.m_6542_(user);
    }

    public boolean m_7525_(Player user) {
        if (this.playeruuid != null) {
            if (user.m_20310_(3) || user.m_36316_().getId().equals(this.playeruuid)) {
                return super.m_7525_(user);
            }
            user.m_6330_((SoundEvent)TFSounds.CASKET_LOCKED.get(), SoundSource.BLOCKS, 0.5f, 0.5f);
            user.m_5661_((Component)Component.m_237110_((String)"block.twilightforest.casket.locked", (Object[])new Object[]{this.f_58622_}).m_130940_(ChatFormatting.RED), true);
            return false;
        }
        return super.m_7525_(user);
    }

    protected IItemHandler createUnSidedHandler() {
        return new EmptyHandler();
    }

    public void m_7651_() {
        this.playeruuid = null;
        this.invalidateCaps();
        super.m_7651_();
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.m_58904_().m_7696_(this.m_58899_(), (Block)TFBlocks.KEEPSAKE_CASKET.get(), 1, this.numPlayersUsing);
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            --this.numPlayersUsing;
            this.m_58904_().m_7696_(this.m_58899_(), (Block)TFBlocks.KEEPSAKE_CASKET.get(), 1, this.numPlayersUsing);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float m_6683_(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
    }
}

