/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config;

import java.nio.file.Path;
import mezz.jei.common.config.ClientConfig;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.config.IIngredientGridConfig;
import mezz.jei.common.config.IModIdFormatConfig;
import mezz.jei.common.config.IngredientFilterConfig;
import mezz.jei.common.config.IngredientGridConfig;
import mezz.jei.common.config.ModIdFormatConfig;
import mezz.jei.common.config.file.ConfigSchemaBuilder;
import mezz.jei.common.config.file.IConfigSchema;
import mezz.jei.common.gui.overlay.options.HorizontalAlignment;
import mezz.jei.core.config.IClientConfig;

public class JEIClientConfigs {
    private final IClientConfig clientConfig;
    private final IIngredientFilterConfig filterConfig;
    private final IModIdFormatConfig modIdFormat;
    private final IIngredientGridConfig ingredientListConfig;
    private final IIngredientGridConfig bookmarkListConfig;
    private final IConfigSchema schema;

    public JEIClientConfigs(Path configFile) {
        ConfigSchemaBuilder builder = new ConfigSchemaBuilder(configFile);
        this.clientConfig = new ClientConfig(builder);
        this.filterConfig = new IngredientFilterConfig(builder);
        this.modIdFormat = new ModIdFormatConfig(builder);
        this.ingredientListConfig = new IngredientGridConfig("IngredientList", builder, HorizontalAlignment.RIGHT);
        this.bookmarkListConfig = new IngredientGridConfig("BookmarkList", builder, HorizontalAlignment.LEFT);
        this.schema = builder.build();
    }

    public void register(Path configFile) {
        this.schema.register(configFile);
    }

    public IClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public IIngredientFilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public IIngredientGridConfig getIngredientListConfig() {
        return this.ingredientListConfig;
    }

    public IIngredientGridConfig getBookmarkListConfig() {
        return this.bookmarkListConfig;
    }

    public IModIdFormatConfig getModIdFormat() {
        return this.modIdFormat;
    }
}

