/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.custom;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.creeperoverhaul.api.PluginRegistry;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.WaterCreeper;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperMeleeAttackGoal;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModSounds;

public class PufferfishCreeper
extends WaterCreeper {
    private static final TargetingConditions TARGETS = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26888_(entity -> entity.m_6336_() != MobType.f_21644_ && EntitySelector.f_20406_.test(entity) && entity.m_6084_());
    private static final List<EntityDimensions> DIMENSIONS = List.of(EntityDimensions.m_20395_((float)0.6875f, (float)1.125f), EntityDimensions.m_20395_((float)0.625f, (float)0.9375f), EntityDimensions.m_20395_((float)1.0f, (float)1.375f));
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(PufferfishCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> PUFF_STATE = SynchedEntityData.m_135353_(PufferfishCreeper.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private int inflateCounter;
    private int deflateTimer;

    public PufferfishCreeper(EntityType<? extends PufferfishCreeper> entityType, Level level, CreeperType type) {
        super(entityType, level, type);
    }

    public static EntityType.EntityFactory<PufferfishCreeper> ofPufferfish(CreeperType type) {
        return (entityType, level) -> new PufferfishCreeper((EntityType<? extends PufferfishCreeper>)entityType, level, type);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType type, @Nullable SpawnGroupData group, @Nullable CompoundTag tag) {
        this.setVariant(level.m_213780_().m_188499_() ? Variant.TEAL : Variant.BROWN);
        return super.m_6518_(level, difficulty, type, group, tag);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new PuffGoal(this));
    }

    @Override
    protected void registerAttackGoals() {
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, entity -> PluginRegistry.getInstance().canAttack(this, (LivingEntity)entity)));
        this.f_21345_.m_25352_(4, (Goal)new CreeperMeleeAttackGoal(this, 3.0, false));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(PUFF_STATE, (Object)0);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (VARIANT.equals(accessor)) {
            this.m_6210_();
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(VARIANT, (Object)(tag.m_128445_("Variant") == 0 ? (byte)0 : 1));
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("Variant", ((Byte)this.f_19804_.m_135370_(VARIANT)).byteValue());
    }

    public byte getPuffState() {
        return (Byte)this.f_19804_.m_135370_(PUFF_STATE);
    }

    public void setPuffState(int puffState) {
        this.f_19804_.m_135381_(PUFF_STATE, (Object)((byte)puffState));
    }

    public Variant getVariant() {
        return Variant.byId((Byte)this.f_19804_.m_135370_(VARIANT));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)((byte)variant.ordinal()));
    }

    public int getPuffId() {
        return switch (this.getPuffState()) {
            case 0 -> 1;
            case 1 -> 2;
            default -> 3;
        };
    }

    @Override
    public void m_8119_() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.m_6142_()) {
            if (this.inflateCounter > 0) {
                if (this.getPuffState() == 0) {
                    this.m_5496_(ModSounds.OCEAN_INFLATE.get(), this.m_6121_(), this.m_6100_());
                    this.setPuffState(1);
                } else if (this.inflateCounter > 40 && this.getPuffState() == 1) {
                    this.m_5496_(ModSounds.OCEAN_INFLATE.get(), this.m_6121_(), this.m_6100_());
                    this.setPuffState(2);
                }
                ++this.inflateCounter;
            } else if (this.getPuffState() != 0) {
                if (this.deflateTimer > 60 && this.getPuffState() == 2) {
                    this.m_5496_(ModSounds.OCEAN_DEFLATE.get(), this.m_6121_(), this.m_6100_());
                    this.setPuffState(1);
                } else if (this.deflateTimer > 100 && this.getPuffState() == 1) {
                    this.m_5496_(ModSounds.OCEAN_DEFLATE.get(), this.m_6121_(), this.m_6100_());
                    this.setPuffState(0);
                }
                ++this.deflateTimer;
            }
        }
        super.m_8119_();
    }

    @Override
    public boolean m_7327_(@NotNull Entity entity) {
        byte state = this.getPuffState();
        if (entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (6.0f + (float)state) * (this.m_7090_() ? 2.0f : 1.0f))) {
            this.m_5496_(SoundEvents.f_12295_, 1.0f, 1.0f);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 60 * state, 0));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canSwell() {
        return false;
    }

    private boolean canTouch(LivingEntity entity) {
        return TARGETS.m_26885_((LivingEntity)this, entity);
    }

    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return DIMENSIONS.get(this.getPuffId() - 1);
    }

    public static enum Variant {
        TEAL,
        BROWN;


        public static Variant byId(byte id) {
            return id == 0 ? TEAL : BROWN;
        }
    }

    public static class PuffGoal
    extends Goal {
        private final PufferfishCreeper creeper;

        public PuffGoal(PufferfishCreeper creeper) {
            this.creeper = creeper;
        }

        public boolean m_8036_() {
            List list = this.creeper.f_19853_.m_6443_(Player.class, this.creeper.m_20191_().m_82400_(6.0), this.creeper::canTouch);
            return !list.isEmpty();
        }

        public void m_8056_() {
            this.creeper.inflateCounter = 1;
            this.creeper.deflateTimer = 0;
        }

        public void m_8041_() {
            this.creeper.inflateCounter = 0;
        }
    }
}

