/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.IntConsumer;
import java.util.function.ToIntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Mth;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.callback.JadeAfterRenderCallback;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.callback.JadeRenderBackgroundCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.config.Theme;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.TooltipRenderer;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.ClientPlatformProxy;
import snownee.jade.util.Color;

public class OverlayRenderer {
    public static float ticks;
    public static int backgroundColorRaw;
    public static int gradientStartRaw;
    public static int gradientEndRaw;
    public static int stressedTextColorRaw;
    public static int normalTextColorRaw;
    public static boolean shown;
    public static float alpha;
    private static TooltipRenderer fadeTooltip;
    private static Rect2i morphRect;

    public static boolean shouldShow() {
        if (WailaTickHandler.instance().tooltipRenderer == null) {
            return false;
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (!general.shouldDisplayTooltip()) {
            return false;
        }
        return general.getDisplayMode() != IWailaConfig.DisplayMode.HOLD_KEY || JadeClient.showOverlay.m_90857_();
    }

    public static boolean shouldShowImmediately(TooltipRenderer tooltipRenderer) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return false;
        }
        if (!ClientPlatformProxy.shouldShowWithOverlay(mc, mc.f_91080_)) {
            return false;
        }
        if (mc.f_91080_ instanceof BaseOptionsScreen) {
            Rect2i position = tooltipRenderer.getPosition();
            Window window = mc.m_91268_();
            double x = mc.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_();
            double y = mc.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_();
            WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
            if (position.m_110087_((int)(x += (double)((float)position.m_110090_() * overlay.tryFlip(overlay.getAnchorX()))), (int)(y += (double)((float)position.m_110091_() * overlay.getAnchorY())))) {
                return false;
            }
        }
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (mc.f_91066_.f_92063_ && general.shouldHideFromDebug()) {
            return false;
        }
        if (mc.m_91265_() != null || mc.f_91066_.f_92062_) {
            return false;
        }
        return !mc.f_91065_.m_93088_().f_94524_ || !general.shouldHideFromTabList();
    }

    public static void renderOverlay478757(PoseStack poseStack) {
        shown = false;
        boolean show = OverlayRenderer.shouldShow();
        TooltipRenderer tooltipRenderer = WailaTickHandler.instance().tooltipRenderer;
        float delta = Minecraft.m_91087_().m_91297_();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        WailaConfig.ConfigGeneral general = Jade.CONFIG.get().getGeneral();
        if (overlay.getAnimation()) {
            if (tooltipRenderer == null) {
                tooltipRenderer = fadeTooltip;
            } else {
                fadeTooltip = tooltipRenderer;
            }
            float speed = general.isDebug() ? 0.1f : 0.6f;
            alpha += (show ? speed : -speed) * delta;
            alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
        } else {
            float f = alpha = show ? 1.0f : 0.0f;
        }
        if (alpha < 0.1f || tooltipRenderer == null || !OverlayRenderer.shouldShowImmediately(tooltipRenderer)) {
            fadeTooltip = null;
            morphRect = null;
            return;
        }
        ticks += delta;
        Minecraft.m_91087_().m_91307_().m_6180_("Jade Overlay");
        OverlayRenderer.renderOverlay(tooltipRenderer, poseStack);
        Minecraft.m_91087_().m_91307_().m_7238_();
    }

    public static void renderOverlay(TooltipRenderer tooltip, PoseStack matrixStack) {
        Rect2i rect;
        IWailaConfig.BossBarOverlapMode mode;
        matrixStack.m_85836_();
        Rect2i position = tooltip.getPosition();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        if (!overlay.getSquare()) {
            position.m_173056_(position.m_110090_() + 2);
            position.m_173058_(position.m_110091_() + 2);
            position.m_173049_(position.m_110085_() + 1, position.m_110086_() + 1);
        }
        if ((mode = Jade.CONFIG.get().getGeneral().getBossBarOverlapMode()) == IWailaConfig.BossBarOverlapMode.PUSH_DOWN && (rect = ClientPlatformProxy.getBossBarRect()) != null) {
            int tw = position.m_110090_();
            int th = position.m_110091_();
            int rw = rect.m_110090_();
            int rh = rect.m_110091_();
            int tx = position.m_110085_();
            int ty = position.m_110086_();
            int rx = rect.m_110085_();
            int ry = rect.m_110086_();
            if ((rw += rx) > tx && (rh += ry) > ty && (tw += tx) > rx && (th += ty) > ry) {
                position.m_173054_(rect.m_110091_());
            }
        }
        if (morphRect == null) {
            morphRect = new Rect2i(position.m_110085_(), position.m_110086_(), position.m_110090_(), position.m_110091_());
        } else {
            OverlayRenderer.chase(position, Rect2i::m_110085_, arg_0 -> ((Rect2i)morphRect).m_173047_(arg_0));
            OverlayRenderer.chase(position, Rect2i::m_110086_, arg_0 -> ((Rect2i)morphRect).m_173054_(arg_0));
            OverlayRenderer.chase(position, Rect2i::m_110090_, arg_0 -> ((Rect2i)morphRect).m_173056_(arg_0));
            OverlayRenderer.chase(position, Rect2i::m_110091_, arg_0 -> ((Rect2i)morphRect).m_173058_(arg_0));
        }
        JadeBeforeRenderCallback.ColorSetting colorSetting = new JadeBeforeRenderCallback.ColorSetting();
        colorSetting.alpha = overlay.getAlpha();
        colorSetting.backgroundColor = backgroundColorRaw;
        colorSetting.gradientStart = gradientStartRaw;
        colorSetting.gradientEnd = gradientEndRaw;
        for (JadeBeforeRenderCallback callback : WailaClientRegistration.INSTANCE.beforeRenderCallbacks) {
            if (!callback.beforeRender(tooltip.getTooltip(), morphRect, matrixStack, ObjectDataCenter.get(), colorSetting)) continue;
            matrixStack.m_85849_();
            return;
        }
        matrixStack.m_85837_((double)morphRect.m_110085_(), (double)morphRect.m_110086_(), 1.0);
        float scale = overlay.getOverlayScale();
        Window window = Minecraft.m_91087_().m_91268_();
        float thresholdHeight = (float)window.m_85446_() * overlay.getAutoScaleThreshold();
        if ((float)position.m_110091_() * scale > thresholdHeight) {
            scale = Math.max(scale * 0.5f, thresholdHeight / (float)position.m_110091_());
        }
        if (scale != 1.0f) {
            matrixStack.m_85841_(scale, scale, 1.0f);
        }
        matrixStack.m_85837_((double)((float)(-morphRect.m_110090_()) * overlay.tryFlip(overlay.getAnchorX())), (double)((float)(-morphRect.m_110091_()) * overlay.getAnchorY()), 0.0);
        boolean doDefault = true;
        colorSetting.alpha *= alpha;
        for (JadeRenderBackgroundCallback callback : WailaClientRegistration.INSTANCE.renderBackgroundCallbacks) {
            if (!callback.onRender(tooltip, morphRect, matrixStack, ObjectDataCenter.get(), colorSetting)) continue;
            doDefault = false;
            break;
        }
        if (doDefault && colorSetting.alpha > 0.0f) {
            OverlayRenderer.drawTooltipBox(matrixStack, 0, 0, morphRect.m_110090_(), morphRect.m_110091_(), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.backgroundColor, colorSetting.alpha), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.gradientStart, colorSetting.alpha), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.gradientEnd, colorSetting.alpha), overlay.getSquare());
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        tooltip.draw(matrixStack);
        RenderSystem.m_69461_();
        for (JadeAfterRenderCallback callback : WailaClientRegistration.INSTANCE.afterRenderCallbacks) {
            callback.afterRender(tooltip.getTooltip(), morphRect, matrixStack, ObjectDataCenter.get());
        }
        RenderSystem.m_69482_();
        matrixStack.m_85849_();
        if (Jade.CONFIG.get().getGeneral().shouldEnableTextToSpeech() && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_46467_() % 5L == 0L) {
            WailaTickHandler.narrate(tooltip.getTooltip(), true);
        }
        shown = true;
    }

    private static void chase(Rect2i pos, ToIntFunction<Rect2i> getter, IntConsumer setter) {
        if (Jade.CONFIG.get().getOverlay().getAnimation()) {
            int value = getter.applyAsInt(morphRect);
            int target = getter.applyAsInt(pos);
            float diff = target - value;
            if (diff == 0.0f) {
                return;
            }
            float delta = Minecraft.m_91087_().m_91297_() * 2.0f;
            if (delta < 1.0f) {
                diff *= delta;
            }
            if (Mth.m_14154_((float)diff) < 1.0f) {
                diff = diff > 0.0f ? 1.0f : -1.0f;
            }
            setter.accept((int)((float)value + diff));
        } else {
            setter.accept(getter.applyAsInt(pos));
        }
    }

    public static void drawTooltipBox(PoseStack matrixStack, int x, int y, int w, int h, int bg, int grad1, int grad2, boolean square) {
        if (!square) {
            w -= 2;
            h -= 2;
        }
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + 1, y + 1, w - 2, h - 2, bg, bg);
        if (!square) {
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y - 1, w, 1.0f, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + h, w, 1.0f, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x - 1, y, 1.0f, h, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + w, y, 1.0f, h, bg, bg);
        }
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + 1, 1.0f, h - 2, grad1, grad2);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + w - 1, y + 1, 1.0f, h - 2, grad1, grad2);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y, w, 1.0f, grad1, grad1);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + h - 1, w, 1.0f, grad2, grad2);
    }

    public static void updateTheme() {
        Theme theme = Jade.CONFIG.get().getOverlay().getTheme();
        backgroundColorRaw = Color.valueOf(theme.backgroundColor).toInt();
        gradientEndRaw = Color.valueOf(theme.gradientEnd).toInt();
        gradientStartRaw = Color.valueOf(theme.gradientStart).toInt();
        normalTextColorRaw = IWailaConfig.IConfigOverlay.applyAlpha(Color.valueOf(theme.normalTextColor).toInt(), 1.0f);
        stressedTextColorRaw = IWailaConfig.IConfigOverlay.applyAlpha(Color.valueOf(theme.stressedTextColor).toInt(), 1.0f);
    }
}

